package net.atlabo.money.dao;

import net.atlabo.money.db.helper.DBOpenHelperManager;
import net.atlabo.money.db.helper.DBOpenHelperManager.DBOpenHelper;
import android.content.Context;
import android.database.sqlite.SQLiteCursor;
import android.database.sqlite.SQLiteDatabase;
import android.database.sqlite.SQLiteStatement;
import android.util.Log;

public class ConnectionManager {
	private static ConnectionManager self;
	
	private DBOpenHelper helper;
	private SQLiteDatabase db;
	
	/**
	 * RXgN^
	 * ͎gȂ
	 */
	private ConnectionManager() {
	}
		
	/**
	 * CX^X𐶐
	 * @param context
	 * @return
	 */
	public static ConnectionManager getInstance(Context context) {
		if (self == null) {
			self = new ConnectionManager();
		}
		
		if (self.helper == null) {
			self.helper = DBOpenHelperManager.getInstance(context);
		}
		
		return self;
	}
	
	/**
	 * SQLiteStatement𐶐ĕԋp
	 * @param sql
	 * @return
	 */
	public SQLiteStatement prepareStatement(String sql) {
		return db.compileStatement(sql);
	}
	
	/**
	 * DB݉\ŊJn
	 */
	public void setWritableDatabase() {
		if (db != null) {
			Log.v("ConnectionManager", "DB͂łɐĂ܂B");
		} else {
			db = helper.getWritableDatabase();
			db.beginTransaction();
		}	
	}
	
	/**
	 * DBǂݍ݉\ŊJn
	 */
	public void setReadableDatabase() {
		if (db != null) {
			Log.v("ConnectionManager", "DB͂łɐĂ܂B");
		} else {
			db = helper.getReadableDatabase();
		}
	}
	
	public void insert(String sql) {
		if (db == null) {
			db = helper.getWritableDatabase();
		}
		db.execSQL(sql);
	}
	
	/**
	 * DBɊi[
	 * @param sql
	 * @param map
	 */
	public void insert(String sql, Object[] args) {
		if (db == null) {
			db = helper.getWritableDatabase();
		}
		db.execSQL(sql, args);
	}
	
	/**
	 * R[hXV
	 * @param sql
	 * @param args
	 */
	public void update(String sql, Object[] args) {
		insert(sql, args);
	}
	
	/**
	 * R[h폜
	 * @param sql
	 */
	public void delete(String sql) {
		insert(sql);
	}
	
	/**
	 * R[h폜
	 * @param sql
	 * @param args
	 */
	public void delete(String sql, Object[] args) {
		insert(sql, args);
	}
	
	/**
	 * R[h擾
	 * @param sql
	 * @return
	 */
	public SQLiteCursor select(String sql) {
		return select(sql, null);
	}
	
	/**
	 * R[h擾
	 * @param sql
	 * @param args
	 * @return
	 */
	public SQLiteCursor select(String sql, String[] args) {
		if (db == null) {
			db = helper.getReadableDatabase();
		}
		return (SQLiteCursor) db.rawQuery(sql, args);
	}
	
	/**
	 * gUNVR~bg
	 */
	public void commit() {
		db.setTransactionSuccessful();
	}
	
	/**
	 * gUNVI
	 */
	public void endTransaction() {
		db.endTransaction();
	}
	
	/**
	 * ڑ
	 */
	public void close() {
		if (db != null) {
			db.close();
			db = null;
		}
		if (helper != null) {
			helper.close();
			helper = null;
		}
	}
	
}
