package net.atlabo.money.dao;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import net.atlabo.money.db.table.BudgetCreditcardExtTable;
import net.atlabo.money.db.table.BudgetTable;
import android.database.sqlite.SQLiteCursor;

public class BudgetDao extends BaseDao {
	
	/**
	 * RXgN^
	 * @param manager
	 */
	public BudgetDao(ConnectionManager manager) {
		super(manager);
	}

	/**
	 * xe[uɓo^
	 * @param map
	 */
	public void insertBudget(Map<String, Object> map) {
		String sql = "insert into BUDGET ( "
				+ "TX_ID, "
				+ "TX_DATE, "
				+ "AMOUNT, "
				+ "CONTENTS, "
				+ "CATEGORY, "
				+ "MEMO "
			+ ") values ( "
				+ "?, "
				+ "?, "
				+ "?, "
				+ "?, "
				+ "?, "
				+ "? "
			+ ") ";
		
		manager.insert(sql, new Object[]{
				map.get(BudgetTable.COLUMN_TX_ID),
				map.get(BudgetTable.COLUMN_TX_DATE),
				map.get(BudgetTable.COLUMN_AMOUNT),
				map.get(BudgetTable.COLUMN_CONTENTS),
				map.get(BudgetTable.COLUMN_CATEGORY),
				map.get(BudgetTable.COLUMN_MEMO)
		});
	}

	/**
	 * xe[uXV
	 * @param map
	 */
	public void updateBudget(Map<String, Object> map) {
		String sql = "update BUDGET set "
				+ "TX_DATE = ?, "
				+ "AMOUNT = ?, "
				+ "CONTENTS = ?, "
				+ "CATEGORY = ?, "
				+ "MEMO = ? "
			+ "where TX_ID = ? ";

		manager.update(sql, new Object[]{
				map.get(BudgetTable.COLUMN_TX_DATE),
				map.get(BudgetTable.COLUMN_AMOUNT),
				map.get(BudgetTable.COLUMN_CONTENTS),
				map.get(BudgetTable.COLUMN_CATEGORY),
				map.get(BudgetTable.COLUMN_MEMO),
				map.get(BudgetTable.COLUMN_TX_ID)
		});

	}

	/**
	 * 1̏ڍׂ擾
	 * @param date yyyyMMddtH[}bg
	 * @return
	 */
	public List<Map<String, Object>> selectDailyDetail(String date) {
		String sql = "select B.TX_ID, TX_DATE, AMOUNT, CONTENTS, CATEGORY, MEMO, STATUS, FINISH_DATE, CREDITCARD_ID "
			+ "from BUDGET B left join BUDGET_CREDITCARD_EXT C on "
			+ "B.TX_ID = C.TX_ID "
			+ "where TX_DATE = ? or FINISH_DATE = ? "
			+ "order by B.TX_ID desc ";

		List<Map<String, Object>> list = new ArrayList<Map<String,Object>>();
		Map<String, Object> map = null;
		SQLiteCursor c = (SQLiteCursor) manager.select(sql, new String[]{ date, date });
		while (c.moveToNext()) {
			map = new HashMap<String, Object>();
			map.put(BudgetTable.COLUMN_TX_ID, c.getString(0));
			map.put(BudgetTable.COLUMN_TX_DATE, c.getString(1));
			map.put(BudgetTable.COLUMN_AMOUNT, c.getInt(2));
			map.put(BudgetTable.COLUMN_CONTENTS, c.getString(3));
			map.put(BudgetTable.COLUMN_CATEGORY, c.getString(4));
			map.put(BudgetTable.COLUMN_MEMO, c.getString(5));
			map.put(BudgetCreditcardExtTable.COLUMN_STATUS, c.getString(6));
			map.put(BudgetCreditcardExtTable.COLUMN_FINISH_DATE, c.getString(7));
			map.put(BudgetCreditcardExtTable.COLUMN_CREDITCARD_ID, c.getString(8));
			list.add(map);
		}

		c.close();
		return list;
	}

	/**
	 * 1̃g[^擾
	 * @param date yyyyMMddtH[}bg
	 * @return
	 */
	public int selectDailyTotal(String date) {
		int totalAmount = 0;
		String sql = "select SUM(AMOUNT) TOTAL_AMOUNT "
			+ "from BUDGET "
			+ "where TX_DATE = ? ";

		SQLiteCursor c = (SQLiteCursor) manager.select(sql, new String[]{ date });
		if (c.moveToNext()) {
			// R[h擾oꍇ
			totalAmount = c.getInt(0);
		}
		c.close();
		return totalAmount;
	}
	
	/**
	 * 1̃g[^擾(㕥p)
	 * 
	 * @param date
	 * @return
	 */
	public int selectDailyTotalAfterPay(String date) {
		int totalAmount = 0;
		String sql = "select SUM(AMOUNT) TOTAL_AMOUNT "
				+ "from BUDGET B left join BUDGET_CREDITCARD_EXT C "
				+ "on B.TX_ID = C.TX_ID "
				+ "where (TX_DATE = ? and C.TX_ID is null) "
				+ "or (FINISH_DATE = ? )";
		
		SQLiteCursor c = (SQLiteCursor) manager.select(sql, new String[] {date, date});
		if (c.moveToNext()) {
			// R[h擾łꍇ
			totalAmount = c.getInt(0);
		}
		
		c.close();
		return totalAmount;
	}

	/**
	 * ʂ̗݌v擾
	 * @param fromDate
	 * @param toDate
	 * @return
	 */
	public int selectDailyRuikei(String fromDate, String toDate) {
		int totalAmount = 0;
		String sql = "select SUM(AMOUNT) TOTAL_AMOUNT "
			+ "from BUDGET "
			+ "where TX_DATE between ? and ? ";

		SQLiteCursor c = (SQLiteCursor) manager.select(sql, new String[]{ fromDate, toDate});
		if (c.moveToNext()) {
			// R[h擾oꍇ
			totalAmount = c.getInt(0);
		}
		c.close();
		return totalAmount;
	}
	
	/**
	 * ʂ̗݌v擾(㕥p)
	 * @param fromDate
	 * @param toDate
	 * @return
	 */
	public int selectDailyRuikeiAfterPay(String fromDate, String toDate) {
		int totalAmount = 0;
		String sql = "select SUM(AMOUNT) TOTAL_AMOUNT "
				+ "from BUDGET B left join BUDGET_CREDITCARD_EXT C "
				+ "on B.TX_ID = C.TX_ID "
				+ "where ((TX_DATE between ? and ?) and C.TX_ID is null) "
				+ "or (FINISH_DATE between ? and ?)";
		
		SQLiteCursor c = (SQLiteCursor) manager.select(sql, new String[] {fromDate, toDate, fromDate, toDate});
		if (c.moveToNext()) {
			totalAmount = c.getInt(0);
		}
		c.close();
		return totalAmount;
	}

	/**
	 * 1̃g[^擾
	 * @param date yyyyMMtH[}bg
	 * @return
	 */
	public int selectMonthlyTotal(String date) {
		int totalAmount = 0;
		String sql = "select SUM(AMOUNT) TOTAL_AMOUNT "
			+ "from BUDGET "
			+ "where TX_DATE between ? and ? ";

		String start = date + "01";
		String end = date + "31";

		SQLiteCursor c = (SQLiteCursor) manager.select(sql, new String[]{start, end});
		if (c.moveToNext()) {
			// R[h擾łꍇ
			totalAmount = c.getInt(0);
		}
		c.close();
		return totalAmount;
	}
	
	/**
	 * 1̃g[^擾(㕥p)
	 * 
	 * @param date
	 * @return
	 */
	public int selectMonthlyTotalAfterPay(String date) {
		int totalAmount = 0;
		String sql = "select SUM(AMOUNT) TOTAL_AMOUNT "
				+ "from BUDGET B left join BUDGET_CREDITCARD_EXT C "
				+ "on B.TX_ID = C.TX_ID "
				+ "where ((TX_DATE between ? and ?) and C.TX_ID is null) "
				+ "or (FINISH_DATE between ? and ?)";
		
		String start = date + "01";
		String end = date + "31";

		SQLiteCursor c = (SQLiteCursor) manager.select(sql, new String[]{start, end, start, end});
		if (c.moveToNext()) {
			// R[h擾łꍇ
			totalAmount = c.getInt(0);
		}
		c.close();
		return totalAmount;
	}

	/**
	 * JeSʂɎ擾
	 * @param date yyyyMM
	 * @return
	 */
	public List<Map<String, Object>> selectMonthlyByCategory(String date) {
		String sql = "select COALESCE(CATEGORY, '̑'), SUM(AMOUNT) TOTAL_AMOUNT "
				+ "from BUDGET "
				+ "where TX_DATE between ? and ? "
				+ "group by CATEGORY "
				+ "order by TOTAL_AMOUNT desc ";

		String start = date + "01";
		String end = date + "31";

		SQLiteCursor c = (SQLiteCursor) manager.select(sql, new String[]{start, end});

		List<Map<String, Object>> list = new ArrayList<Map<String,Object>>();
		Map<String, Object> map = null;

		while (c.moveToNext()) {
			map = new HashMap<String, Object>();
			map.put(BudgetTable.COLUMN_CATEGORY, c.getString(0));
			map.put(BudgetTable.COLUMN_AMOUNT, c.getInt(1));
			list.add(map);
		}

		c.close();
		return list;
	}
	
	/**
	 * JeSʂɎ擾(㕥p)
	 * @param date yyyyMM
	 * @return
	 */
	public List<Map<String, Object>> selectMonthlyByCategoryAfterPay(String date) {
		String sql = "select COALESCE(CATEGORY, '̑'), SUM(AMOUNT) TOTAL_AMOUNT "
				+ "from BUDGET B left join BUDGET_CREDITCARD_EXT C "
				+ "on B.TX_ID = C.TX_ID "
				+ "where ((TX_DATE between ? and ?) and C.TX_ID is null) "
				+ "or (FINISH_DATE between ? and ?)"
				+ "group by CATEGORY "
				+ "order by TOTAL_AMOUNT desc ";

		String start = date + "01";
		String end = date + "31";

		SQLiteCursor c = (SQLiteCursor) manager.select(sql, new String[]{start, end, start, end});

		List<Map<String, Object>> list = new ArrayList<Map<String,Object>>();
		Map<String, Object> map = null;

		while (c.moveToNext()) {
			map = new HashMap<String, Object>();
			map.put(BudgetTable.COLUMN_CATEGORY, c.getString(0));
			map.put(BudgetTable.COLUMN_AMOUNT, c.getInt(1));
			list.add(map);
		}

		c.close();
		return list;
	}

	/**
	 * Ƃ1̃R[h擾
	 * 
	 * @param date
	 * @return
	 */
	public List<Map<String, Object>> selectMonthlyByDay(String date) {
		String sql = "select substr(TX_DATE, 7, 2) TX_DATE, sum(AMOUNT) TOTAL_AMOUNT "
				+ "from BUDGET "
				+ "where TX_DATE between ? and ? "
				+ "group by TX_DATE "
				+ "order by TX_DATE asc ";

		String start = date + "01";
		String end = date + "31";

		SQLiteCursor c = (SQLiteCursor) manager.select(sql, new String[]{start, end});

		List<Map<String, Object>> list = new ArrayList<Map<String,Object>>();
		Map<String, Object> map = null;

		while (c.moveToNext()) {
			map = new HashMap<String, Object>();
			map.put(BudgetTable.COLUMN_TX_DATE, c.getString(0));
			map.put(BudgetTable.COLUMN_AMOUNT, c.getInt(1));
			list.add(map);
		}

		c.close();
		return list;
	}
	
	/**
	 * Ƃ1̃R[h擾(㕥p)
	 * 
	 * @param date
	 * @return
	 */
	public List<Map<String, Object>> selectMonthlyByDayAfterPay(String date) {
		String sql = "select substr(TX_DATE, 7, 2) TX_DATE, "
				+ "sum(AMOUNT) TOTAL_AMOUNT, "
				+ "substr(FINISH_DATE, 7, 2) FINISH_DATE, "
				+ "STATUS "
				+ "from BUDGET B left join BUDGET_CREDITCARD_EXT C "
				+ "on B.TX_ID = C.TX_ID "
				+ "where ((TX_DATE between ? and ?) and C.TX_ID is null) "
				+ "or (FINISH_DATE between ? and ?) "
				+ "group by TX_DATE "
				+ "order by TX_DATE asc ";

		String start = date + "01";
		String end = date + "31";

		SQLiteCursor c = (SQLiteCursor) manager.select(sql, new String[]{start, end, start, end});

		List<Map<String, Object>> list = new ArrayList<Map<String,Object>>();
		Map<String, Object> map = null;

		while (c.moveToNext()) {
			map = new HashMap<String, Object>();
			map.put(BudgetTable.COLUMN_TX_DATE, c.getString(0));
			map.put(BudgetTable.COLUMN_AMOUNT, c.getInt(1));
			map.put(BudgetCreditcardExtTable.COLUMN_FINISH_DATE, c.getString(2));
			map.put(BudgetCreditcardExtTable.COLUMN_STATUS, c.getString(3));
			list.add(map);
		}

		c.close();
		return list;
	}

	/**
	 * 1폜
	 * @param txId
	 */
	public void deleteDetail(String txId) {
		String sql = "delete from BUDGET where TX_ID = ? ";

		manager.delete(sql, new String[]{ txId });
	}
}
