package net.atlabo.money.dao;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import net.atlabo.money.db.table.BudgetCreditcardExtTable;
import net.atlabo.money.db.table.BudgetTable;
import android.database.sqlite.SQLiteCursor;

public class BudgetCreditcardExtDao extends BaseDao {
	
	public BudgetCreditcardExtDao(ConnectionManager manager) {
		super(manager);
	}

	/**
	 * xe[uɓo^
	 * @param map
	 */
	public void insertBudget(Map<String, Object> map) {		
		String sql = "insert into BUDGET_CREDITCARD_EXT ( "
				+ "TX_ID, "
				+ "STATUS, "
				+ "FINISH_DATE, "
				+ "CREDITCARD_ID "
			+ ") values ( "
				+ "?, "
				+ "?, "
				+ "?, "
				+ "? "
			+ ") ";

		manager.insert(sql, new Object[]{
				map.get(BudgetTable.COLUMN_TX_ID),
				"0",
				null,
				map.get(BudgetCreditcardExtTable.COLUMN_CREDITCARD_ID)
		});
	}
	
	/**
	 * 1폜
	 * @param txId
	 */
	public void deleteDetail(String txId) {
		String sql = "delete from BUDGET_CREDITCARD_EXT where TX_ID = ? ";

		manager.delete(sql, new String[]{ txId });
	}
	
	public void update(Map<String, Object> map) {
		String sql = "update BUDGET_CREDITCARD_EXT set "
				+ "STATUS = ?, "
				+ "FINISH_DATE = ?, "
				+ "CREDITCARD_ID = ? "
			+ "where TX_ID = ?";
		
		manager.update(sql, new Object[] {
			map.get(BudgetCreditcardExtTable.COLUMN_STATUS),
			map.get(BudgetCreditcardExtTable.COLUMN_FINISH_DATE),
			map.get(BudgetCreditcardExtTable.COLUMN_CREDITCARD_ID),
			map.get(BudgetCreditcardExtTable.COLUMN_TX_ID)
		});
	}
	
	/**
	 * NJge[u背R[h擾
	 * R[h݂ȂꍇNULLԋp
	 * @param txId
	 * @return
	 */
	public Map<String, Object> select(String txId) {
		String sql = "select STATUS, FINISH_DATE, CREDITCARD_ID from BUDGET_CREDITCARD_EXT "
				+ "where TX_ID = ? ";
		
		SQLiteCursor c = manager.select(sql, new String[]{txId});
		Map<String, Object> map = null;
		while (c.moveToNext()) {
			map = new HashMap<String, Object>();
			map.put(BudgetCreditcardExtTable.COLUMN_STATUS, c.getString(0));
			map.put(BudgetCreditcardExtTable.COLUMN_FINISH_DATE, c.getString(1));
			map.put(BudgetCreditcardExtTable.COLUMN_CREDITCARD_ID, c.getString(2));
		}
		
		return map;
	}
	
	/**
	 * ̂̂擾
	 * @param txId
	 * @return
	 */
	public List<Map<String, Object>> selectWithNotFinished() {
		String sql = "select B.TX_ID TX_ID, "
				+ "TX_DATE, "
				+ "AMOUNT, "
				+ "CONTENTS, "
				+ "CATEGORY, "
				+ "MEMO "
				+ "from BUDGET B join BUDGET_CREDITCARD_EXT C "
				+ "on B.TX_ID = C.TX_ID "
				+ "where STATUS = '0' "
				+ "order by TX_DATE desc ";
		
		SQLiteCursor c = manager.select(sql);
		Map<String, Object> map = null;
		List<Map<String, Object>> list = new ArrayList<Map<String,Object>>();
		while (c.moveToNext()) {
			map = new HashMap<String, Object>();
			map.put(BudgetCreditcardExtTable.COLUMN_TX_ID, c.getString(0));
			map.put(BudgetTable.COLUMN_TX_DATE, c.getString(1));
			map.put(BudgetTable.COLUMN_AMOUNT, c.getInt(2));
			map.put(BudgetTable.COLUMN_CONTENTS, c.getString(3));
			map.put(BudgetTable.COLUMN_CATEGORY, c.getString(4));
			map.put(BudgetTable.COLUMN_MEMO, c.getString(5));
			list.add(map);
		}
		
		return list;
	}
}
