package net.atlabo.money.component;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.Map;

import net.atlabo.money.chart.CustomChartView;
import net.atlabo.money.db.table.BudgetCreditcardExtTable;
import net.atlabo.money.db.table.BudgetTable;
import net.atlabo.money.db.table.PlanMonthTable;
import net.atlabo.money.logic.MonthlyPlanLogic;

import org.afree.chart.AFreeChart;
import org.afree.chart.ChartFactory;
import org.afree.chart.axis.DateAxis;
import org.afree.chart.plot.XYPlot;
import org.afree.chart.renderer.xy.XYItemRenderer;
import org.afree.chart.renderer.xy.XYLineAndShapeRenderer;
import org.afree.data.time.Day;
import org.afree.data.time.TimeSeries;
import org.afree.data.time.TimeSeriesCollection;
import org.afree.data.xy.XYDataset;
import org.afree.graphics.SolidColor;
import org.afree.ui.RectangleInsets;

import android.app.Activity;
import android.content.Context;
import android.graphics.Color;
import android.util.Log;

public class TimeSeriesChartView extends CustomChartView {
	private Activity activity;
	private Date date;
	private SimpleDateFormat df = new SimpleDateFormat("yyyyMM");
	private SimpleDateFormat df2 = new SimpleDateFormat("yyyyMMdd");

	public TimeSeriesChartView(Context context, Activity activity, Date date) {
        super(context);
        this.activity = activity;
        this.date = date;
        final AFreeChart chart = createChart(createDataset());

        setChart(chart);
	}

    /**
     * Creates a chart.
     *
     * @param dataset  a dataset.
     *
     * @return A chart.
     */
    private static AFreeChart createChart(XYDataset dataset) {

        AFreeChart chart = ChartFactory.createTimeSeriesChart(
            "ԃ`[g",  // title
            "t",             // x-axis label
            "z",   // y-axis label
            dataset,            // data
            true,               // create legend?
            true,               // generate tooltips?
            false               // generate URLs?
        );

        chart.setBackgroundPaintType(new SolidColor(Color.WHITE));
        chart.setBorderVisible(false);

        XYPlot plot = (XYPlot) chart.getPlot();
        plot.setBackgroundPaintType(new SolidColor(Color.LTGRAY));
        plot.setDomainGridlinePaintType(new SolidColor(Color.WHITE));
        plot.setRangeGridlinePaintType(new SolidColor(Color.WHITE));
        plot.setAxisOffset(new RectangleInsets(5.0, 5.0, 5.0, 5.0));
        plot.setDomainCrosshairVisible(true);
        plot.setRangeCrosshairVisible(true);

        XYItemRenderer r = plot.getRenderer();
        if (r instanceof XYLineAndShapeRenderer) {
            XYLineAndShapeRenderer renderer = (XYLineAndShapeRenderer) r;
            renderer.setBaseShapesVisible(true);
            renderer.setBaseShapesFilled(true);
            renderer.setDrawSeriesLineAsPath(true);
        }

        DateAxis axis = (DateAxis) plot.getDomainAxis();
        axis.setDateFormatOverride(new SimpleDateFormat("Md"));

        return chart;

    }

    /**
     * Creates a dataset, consisting of two series of monthly data.
     *
     * @return The dataset.
     */
    private XYDataset createDataset() {

    	// ڕWƎxo擾
    	MonthlyPlanLogic logic = new MonthlyPlanLogic();
    	List<Map<String, Object>> list = logic.buildRuikeiList(activity, date);

        TimeSeries s1 = new TimeSeries("o݌v");
        TimeSeries s2 = new TimeSeries("ԖڕW");

        Date d = null;
        int ruikei;
        int planAmount;
        String yyyyMM = df.format(date);
        for (Map<String, Object> map : list) {
			try {
				String status = (String) map.get(BudgetCreditcardExtTable.COLUMN_STATUS);
				if (status == null) {
					d = df2.parse(yyyyMM + (String) map.get(BudgetTable.COLUMN_TX_DATE));
				} else {
					String tmpDate = (String) map.get(BudgetCreditcardExtTable.COLUMN_FINISH_DATE);
					if (tmpDate == null) {
						d = df2.parse(yyyyMM + (String) map.get(BudgetTable.COLUMN_TX_DATE));
					} else {
						d = df2.parse(yyyyMM + tmpDate);
					}
				}

				ruikei = (Integer) map.get(BudgetTable.CONST_RUIKEI);
	        	planAmount = (Integer) map.get(PlanMonthTable.COLUMN_PLAN_AMOUNT);
	        	s1.add(new Day(d), ruikei);
	        	s2.add(new Day(d), planAmount);
			} catch (ParseException e) {
				Log.e("money", "t̃tH[}bgɎs܂B");
			}

        }

        TimeSeriesCollection dataset = new TimeSeriesCollection();
        dataset.addSeries(s1);
        dataset.addSeries(s2);

        return dataset;
    }
}
