package net.atlabo.money.component;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.Map;

import net.atlabo.money.chart.CustomChartView;
import net.atlabo.money.db.table.BudgetCreditcardExtTable;
import net.atlabo.money.db.table.BudgetTable;
import net.atlabo.money.db.table.PlanMonthTable;
import net.atlabo.money.logic.MonthlyPlanLogic;

import org.afree.chart.AFreeChart;
import org.afree.chart.axis.DateAxis;
import org.afree.chart.axis.DateTickMarkPosition;
import org.afree.chart.axis.NumberAxis;
import org.afree.chart.axis.ValueAxis;
import org.afree.chart.plot.DatasetRenderingOrder;
import org.afree.chart.plot.XYPlot;
import org.afree.chart.renderer.xy.StandardXYItemRenderer;
import org.afree.chart.renderer.xy.XYBarRenderer;
import org.afree.chart.renderer.xy.XYItemRenderer;
import org.afree.chart.renderer.xy.XYLineAndShapeRenderer;
import org.afree.data.time.Day;
import org.afree.data.time.TimeSeries;
import org.afree.data.time.TimeSeriesCollection;
import org.afree.graphics.GradientColor;
import org.afree.graphics.SolidColor;
import org.afree.ui.RectangleInsets;

import android.content.Context;
import android.graphics.Color;
import android.graphics.CornerPathEffect;
import android.util.Log;

public class MonthlySummaryChartView extends CustomChartView {
	private Date date;
	private SimpleDateFormat df = new SimpleDateFormat("yyyyMM");
	private SimpleDateFormat df2 = new SimpleDateFormat("yyyyMMdd");

	public MonthlySummaryChartView(Context context, Date date) {
        super(context);
        this.date = date;
        final AFreeChart chart = createChart();

        setChart(chart);
	}

    /**
     * Creates a chart.
     *
     * @param dataset  a dataset.
     *
     * @return A chart.
     */
    private AFreeChart createChart() {



        XYPlot plot = createDataset();
        plot.setBackgroundPaintType(new SolidColor(Color.WHITE));
        plot.setDomainGridlinesVisible(false);
        plot.setRangeGridlinesVisible(false);
        plot.setAxisOffset(new RectangleInsets(0, 0, 2, 0));
        plot.setBackgroundPaintType(new GradientColor(Color.LTGRAY, Color.WHITE));

        XYItemRenderer r = plot.getRenderer();
        if (r instanceof XYLineAndShapeRenderer) {
            XYLineAndShapeRenderer renderer = (XYLineAndShapeRenderer) r;
            renderer.setBaseShapesVisible(false);
            renderer.setBaseShapesFilled(false);
            renderer.setDrawSeriesLineAsPath(false);
        }

        // X
        DateAxis axis = (DateAxis) plot.getDomainAxis();
        axis.setDateFormatOverride(new SimpleDateFormat("M/d"));

        // Y
        ValueAxis rangeAxis = plot.getRangeAxis();
        rangeAxis.setVisible(false);

        AFreeChart chart = new AFreeChart(plot);

        chart.setBackgroundPaintType(new SolidColor(Color.WHITE));
        chart.setBorderVisible(false);

        return chart;

    }

    /**
     * Creates a dataset, consisting of two series of monthly data.
     *
     * @return The dataset.
     */
    private XYPlot createDataset() {

    	// ڕWƎxo擾
    	MonthlyPlanLogic logic = new MonthlyPlanLogic();
    	List<Map<String, Object>> list = logic.buildRuikeiList(getContext(), date);

        TimeSeries s1 = new TimeSeries("o݌v");
        TimeSeries s2 = new TimeSeries("ԖڕW");
        TimeSeries s3 = new TimeSeries("oz");

        Date d = null;
        int amount;
        int ruikei;
        int planAmount;
        String yyyyMM = df.format(date);
        for (Map<String, Object> map : list) {
			try {
				String status = (String) map.get(BudgetCreditcardExtTable.COLUMN_STATUS);
				if (status == null) {
					d = df2.parse(yyyyMM + (String) map.get(BudgetTable.COLUMN_TX_DATE));
				} else {
					String tmpDate = (String) map.get(BudgetCreditcardExtTable.COLUMN_FINISH_DATE);
					if (tmpDate == null) {
						d = df2.parse(yyyyMM + (String) map.get(BudgetTable.COLUMN_TX_DATE));
					} else {
						d = df2.parse(yyyyMM + tmpDate);
					}
				}
				amount = (Integer) map.get(BudgetTable.COLUMN_AMOUNT);
	        	ruikei = (Integer) map.get(BudgetTable.CONST_RUIKEI);
	        	planAmount = (Integer) map.get(PlanMonthTable.COLUMN_PLAN_AMOUNT);
	        	s1.add(new Day(d), ruikei);
	        	s2.add(new Day(d), planAmount);
	        	s3.add(new Day(d), amount);
			} catch (ParseException e) {
				Log.e("money", "t̃tH[}bgɎs܂B");
			}

        }

        DateAxis domainAxis = new DateAxis();
        domainAxis.setTickMarkPosition(DateTickMarkPosition.MIDDLE);

        ValueAxis rangeAxis = new NumberAxis();

        XYBarRenderer renderer = new XYBarRenderer(0d);
        renderer.setShadowVisible(false);
        renderer.setSeriesPaintType(0, new GradientColor(Color.parseColor("#191970"), Color.parseColor("#000080")));

        XYPlot plot = new XYPlot(new TimeSeriesCollection(s3), domainAxis, rangeAxis, renderer);

        ValueAxis rangeAxis2 = new NumberAxis();
        rangeAxis2.setVisible(false);



        StandardXYItemRenderer renderer1 = new StandardXYItemRenderer();
        renderer1.setSeriesStroke(0, 3f);
        renderer1.setSeriesPaintType(0, new SolidColor(Color.BLUE));
        plot.setRangeAxis(1, rangeAxis2);
        plot.setDataset(1, new TimeSeriesCollection(s1));
        plot.setRenderer(1, renderer1);

        StandardXYItemRenderer renderer2 = new StandardXYItemRenderer();
        renderer2.setSeriesStroke(0, 3f);
        renderer2.setSeriesPaintType(0, new SolidColor(Color.RED));
        plot.setRangeAxis(2, rangeAxis2);
        plot.setDataset(2, new TimeSeriesCollection(s2));
        plot.setRenderer(2, renderer2);

        plot.setDatasetRenderingOrder(DatasetRenderingOrder.FORWARD);

        plot.setOutlineEffect(new CornerPathEffect(10.0f));
        plot.setOutlineStroke(1.5f);

        plot.mapDatasetToRangeAxis(0, 1);

        return plot;
    }
}
