package net.atlabo.money.adapter;

import java.util.List;

import net.atlabo.money.R;
import net.atlabo.money.bean.TopMenuBean;

import android.content.Context;
import android.content.Intent;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.View.OnClickListener;
import android.widget.ArrayAdapter;
import android.widget.ImageView;
import android.widget.TextView;

public class TopPageAdapter extends ArrayAdapter<TopMenuBean> {
	private LayoutInflater inflater;

	public TopPageAdapter(Context context, List<TopMenuBean> objects) {
		super(context, 0, objects);

		inflater = (LayoutInflater) context.getSystemService(Context.LAYOUT_INFLATER_SERVICE);
	}

	/**
	 * TODO
	 */
	public View getView(final int position, View convertView, ViewGroup parent) {
		if (convertView == null) {
			convertView = inflater.inflate(R.layout.top_item, null);
		}
		final TopMenuBean bean = getItem(position);

		ImageView imageView = (ImageView) convertView.findViewById(R.id.image);
		imageView.setImageResource(bean.resource);

		TextView textView = (TextView) convertView.findViewById(R.id.text);
		textView.setText(bean.text);

		convertView.setOnClickListener(new OnClickListener() {
			public void onClick(View v) {
				Intent intent = new Intent(getContext(), bean.activityClass);
				getContext().startActivity(intent);
			}
		});

		return convertView;
	}



}
