package net.atlabo.money.adapter;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.DecimalFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.Locale;
import java.util.Map;

import net.atlabo.money.R;
import net.atlabo.money.activity.DailyDetailActivity;
import net.atlabo.money.activity.ExtendedActivity;
import net.atlabo.money.component.MonthlySummaryChartView;
import net.atlabo.money.dao.BudgetDao;
import net.atlabo.money.dao.ConnectionManager;
import net.atlabo.money.dao.PlanMonthDao;
import net.atlabo.money.db.table.BudgetCreditcardExtTable;
import net.atlabo.money.db.table.BudgetTable;
import net.atlabo.money.exception.SystemException;
import net.atlabo.money.logic.MonthlyPlanLogic;
import net.atlabo.money.util.Preference;
import net.atlabo.money.util.StringUtil;
import android.content.Context;
import android.graphics.Color;
import android.os.Parcelable;
import android.support.v4.view.PagerAdapter;
import android.support.v4.view.ViewPager;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.view.View.OnClickListener;
import android.widget.LinearLayout;
import android.widget.TextView;

public class MonthlyPagerAdapter extends PagerAdapter {

	private int[] ids = new int[]{
			R.id.sun,
			R.id.mon,
			R.id.tue,
			R.id.wed,
			R.id.thu,
			R.id.fri,
			R.id.sat
	};

	private SimpleDateFormat df2 = new SimpleDateFormat("yyyyMM");
	private SimpleDateFormat df3 = new SimpleDateFormat("yyyyMMdd");
	private SimpleDateFormat df4 = new SimpleDateFormat("MMMMM, yyyy ", Locale.US);

	private DecimalFormat decimalFormat = new DecimalFormat("###,###,###~");

	private Integer planAmount;

	private Context context;

	//  xݒ肵ύXȂ
	private Date baseDate;
	private Date today;

	private static final int COUNT = 999;
	public static final int INITIAL = 500;

	public MonthlyPagerAdapter(Context context, Date baseDate) {
		this.context = context;
		this.baseDate = baseDate;
		today = new Date();
	}

	@Override
	public void destroyItem(View view, int position, Object obj) {
		Log.v("pager", "destroyItem start!! [" + position + "]");
		((ViewPager) view).removeView((View) obj);
	}

	@Override
	public void finishUpdate(View arg0) {

	}

	@Override
	public int getCount() {
		// ꂽ\bhEX^u
		return COUNT;
	}

	@Override
	public Object instantiateItem(View collection, int position) {
		Log.v("money", "MonthlyPagerAdapter#instantiateItem start!! [" + position + "]");

		// ݓtݒ
		Calendar cal = new GregorianCalendar();
		cal.setTime(baseDate);
		cal.add(Calendar.MONTH, position - INITIAL);
		Date currentDate = cal.getTime();

		// J_[擾
		LayoutInflater inflater = LayoutInflater.from(context);

		LinearLayout monthlyPageLayout = (LinearLayout) inflater.inflate(R.layout.monthly_page, null);

		// NWbg^C~O擾
		Preference pref = new Preference(context);
		String timing = pref.getCreditPayTiming();

		// tTextView擾
		TextView tvDate = (TextView) monthlyPageLayout.findViewById(R.id.date);
		// tݒ
		tvDate.setText(df4.format(currentDate));

		// v擾
		ConnectionManager manager = ConnectionManager.getInstance(context);
		BudgetDao dao = new BudgetDao(manager);
		int totalAmount = 0;
		if (Preference.CREDIT_BUY.equals(timing)) {
			// x
			totalAmount = dao.selectMonthlyTotal(df2.format(currentDate));
		} else {
			// 
			totalAmount = dao.selectMonthlyTotalAfterPay(df2.format(currentDate));
		}

		TextView tvTotalAmount = (TextView) monthlyPageLayout.findViewById(R.id.totalAmount);
		tvTotalAmount.setText(decimalFormat.format(totalAmount));

		// ԖڕW擾
		PlanMonthDao planDao = new PlanMonthDao(manager);
		planAmount = planDao.selectPlan(df2.format(currentDate));
		String strPlanAmount = null;
		if (planAmount == null) {
			strPlanAmount = "----";
		} else {
			strPlanAmount = decimalFormat.format(planAmount);
		}

		TextView tvPlanAmount = (TextView) monthlyPageLayout.findViewById(R.id.planAmount);
		tvPlanAmount.setText(strPlanAmount);

		// 1̃R[h擾
		MonthlyPlanLogic logic = new MonthlyPlanLogic();
		List<List<Map<String, Object>>> list = logic.buildCalendarList(context, currentDate);

		// J_[𐶐
		createCalendar(list, currentDate, monthlyPageLayout);

		((ViewPager) collection).addView(monthlyPageLayout, 0);

		// Ot𐶐
		LinearLayout layout = (LinearLayout) monthlyPageLayout.findViewById(R.id.monthlySummaryChart);
		MonthlySummaryChartView monthlySummaryChartView = new MonthlySummaryChartView(context, currentDate);
		layout.addView(monthlySummaryChartView);

		manager.close();
		
		Log.v("money", "MonthlyPagerAdapter#instantiateItem finish!!");

		return monthlyPageLayout;
	}

	@Override
	public boolean isViewFromObject(View view, Object obj) {
		return view == obj;
	}

	@Override
	public void restoreState(Parcelable arg0, ClassLoader arg1) {

	}

	@Override
	public Parcelable saveState() {
		return null;
	}

	@Override
	public void startUpdate(View arg0) {

	}

	/**
	 * ݓ擾
	 * @param position
	 * @return
	 */
	public Date getCurrentDate(int position) {
		Calendar cal = new GregorianCalendar();
		cal.setTime(baseDate);
		cal.add(Calendar.MONTH, position - INITIAL);
		return cal.getTime();
	}

    /**
     * J_[𐶐B
     * @param list
     */
    private void createCalendar(List<List<Map<String, Object>>> list, final Date currentDate, LinearLayout monthlyPageLayout) {
    	LayoutInflater inflater = (LayoutInflater) context.getSystemService(Context.LAYOUT_INFLATER_SERVICE);
    	LinearLayout layout = null;

    	LinearLayout monthlyCalendarLayout = (LinearLayout) inflater.inflate(R.layout.monthly_calendar, null);
    	LinearLayout calendarLayout = (LinearLayout) monthlyPageLayout.findViewById(R.id.calendar);

    	// wb_ݒ肷
    	calendarLayout.addView(monthlyCalendarLayout);

    	LinearLayout weeklyField = (LinearLayout) calendarLayout.findViewById(R.id.weeklyField);

    	// Sč폜
    	weeklyField.removeAllViews();

    	for (List<Map<String, Object>> list2 : list) {
    		layout = (LinearLayout) inflater.inflate(R.layout.weekly_calendar, null);
    		Log.v("pager", "weekly_calendar擾");
    		TextView tvDate = null;
    		TextView tvAmount = null;
    		LinearLayout linearLayout = null;
    		for (int i=0, size=list2.size(); i<size; i++) {
    			Map<String, Object> map = list2.get(i);
    			if (map == null) {
    				continue;
    			}

    			final String txDate = StringUtil.leftpadZero((String) map.get(BudgetTable.COLUMN_TX_DATE), 2);

    			// Og
    			linearLayout = (LinearLayout) layout.findViewById(ids[i]);
    			linearLayout.setOnClickListener(new OnClickListener() {
					public void onClick(View v) {
						try {
							// onClick̓
							((ExtendedActivity) context).moveActivity(DailyDetailActivity.class,
									df3.parse(df2.format(currentDate) + txDate));
						} catch (ParseException e) {
							throw new SystemException("t̃p[XɎs܂B", e);
						}
					}
				});

    			// {̏ꍇ͔wiFς
				if ((df2.format(currentDate) + txDate).equals(df3.format(today))) {
					linearLayout.setBackgroundColor(Color.parseColor("#fffacd"));
				}


    			// tTextView
    			tvDate = (TextView) linearLayout.getChildAt(0);
    			tvDate.setText(Integer.toString(Integer.parseInt(txDate)));

    			// zTextView
    			Integer amount = (Integer) map.get(BudgetTable.COLUMN_AMOUNT);
    			if (amount != null && amount > 0) {
    				tvAmount = (TextView) linearLayout.getChildAt(1);
    				tvAmount.setText(decimalFormat.format(amount));

    				Log.v("money", "planAmount = " + planAmount);

    				if (planAmount != null && planAmount > 0) {
    					// eLXg̐F𔒂ɐݒ
    					tvAmount.setTextColor(Color.WHITE);
    					// F߂
    					tvAmount.setBackgroundResource(getAmountColorId(amount, planAmount));
    				}
    			}
    		}

    		weeklyField.addView(layout);
    	}
    }

    private int getAmountColorId(int amount, int planAmount) {
    	BigDecimal bdAmount = new BigDecimal(amount);
    	BigDecimal bdPlanAmount = new BigDecimal(planAmount);
    	Log.v("money", "amount = " + amount + ", planAmount = " + planAmount);
    	BigDecimal bdResult = bdAmount.divide(bdPlanAmount, 4, RoundingMode.CEILING);
    	double result = bdResult.doubleValue();

    	if (result >= 0d && result < 0.03) {
    		return R.drawable.amount1;
    	} else if (result >= 0.03 && result < 0.06) {
    		return R.drawable.amount2;
    	} else if (result >= 0.06 && result < 0.1) {
    		return R.drawable.amount3;
    	} else if (result >= 0.1 && result < 0.2) {
    		return R.drawable.amount4;
    	} else if (result >= 0.2 && result < 0.5) {
    		return R.drawable.amount5;
    	} else {
    		return R.drawable.amount6;
    	}
    }

}
