package net.atlabo.money.adapter;

import java.text.DecimalFormat;
import java.util.List;
import java.util.Map;

import net.atlabo.money.R;
import net.atlabo.money.db.table.BudgetTable;

import android.content.Context;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ArrayAdapter;
import android.widget.TextView;

public class MonthlyCategoryListAdapter extends ArrayAdapter<Map<String, Object>> {
	private LayoutInflater inflater;
	private DecimalFormat decimalFormat = new DecimalFormat("###,###,###~");

	public MonthlyCategoryListAdapter(Context context, List<Map<String, Object>> objects) {
		super(context, 0, objects);

		inflater = (LayoutInflater) context.getSystemService(Context.LAYOUT_INFLATER_SERVICE);
	}

	/**
	 * TODO
	 */
	public View getView(final int position, View convertView, ViewGroup parent) {
		if (convertView == null) {
			convertView = inflater.inflate(R.layout.monthly_category_item, null);
		}
		Map<String, Object> item = getItem(position);

		// JeS
		TextView tvCategory = (TextView) convertView.findViewById(R.id.category);
		tvCategory.setText((String) item.get(BudgetTable.COLUMN_CATEGORY));
		// z
		TextView tvAmount = (TextView) convertView.findViewById(R.id.amount);
		tvAmount.setText(decimalFormat.format(item.get(BudgetTable.COLUMN_AMOUNT)));

		return convertView;
	}



}
