package net.atlabo.money.adapter;

import java.util.ArrayList;
import java.util.List;

import net.atlabo.money.R;
import android.content.Context;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.BaseAdapter;
import android.widget.Filter;
import android.widget.Filterable;
import android.widget.TextView;

public class HistoryAdapter extends BaseAdapter implements Filterable {
	private LayoutInflater inflater;
	private List<String> results;
	private List<String> filterdResults;

	public HistoryAdapter(Context context, List<String> objects) {
		results = objects;
		inflater = LayoutInflater.from(context);
	}
	

	public View getView(int position, View convertView, ViewGroup viewgroup) {
		if (convertView == null) {
			convertView = inflater.inflate(R.layout.history_list_item, null);
		}

		TextView tv = (TextView) convertView.findViewById(R.id.text1);
		String word = getItem(position);
		tv.setText(word);

		return convertView;
	}

	public Filter getFilter() {
		Filter f = new Filter() {
			protected FilterResults performFiltering(CharSequence constraint) {
				Log.v("filter", "performFiltering start [" + constraint + "]");
				FilterResults filterResults = new FilterResults();
				if(constraint != null && !"".equals(constraint)) {
					List<String> list = new ArrayList<String>();
					for (String str : results) {
						if (str.indexOf(constraint.toString()) != -1) {
							Log.v("filter", "list.add -> " + str);
							list.add(str);
						}
					}
					filterResults.values = list;
					filterResults.count = list.size();
					return filterResults;
				} else {
					filterResults.values = results;
					filterResults.count = results.size();
					return filterResults;
				}
			}

			@Override
			protected void publishResults(CharSequence charsequence,
					FilterResults filterresults) {
				filterdResults = (List<String>) filterresults.values;
				Log.v("filter", "publishResults");
				if (filterresults != null && filterresults.count > 0) {
					// ĕ`
					notifyDataSetChanged();
				} else {
					notifyDataSetInvalidated();
				}

			}
		};
		return f;
	}


	@Override
	public int getCount() {
		return filterdResults.size();
	}


	@Override
	public String getItem(int position) {
		return filterdResults.get(position);
	}


	@Override
	public long getItemId(int position) {
		return position;
	}
}
