package net.atlabo.money.adapter;

import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.Map;

import net.atlabo.money.R;
import net.atlabo.money.db.table.BudgetCreditcardExtTable;
import net.atlabo.money.db.table.BudgetTable;
import net.atlabo.money.util.Preference;

import android.content.Context;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ArrayAdapter;
import android.widget.TextView;

public class DailyDetailListAdapter extends ArrayAdapter<Map<String, Object>> {
	private LayoutInflater inflater;
	private DecimalFormat decimalFormat = new DecimalFormat("###,###,###~");
	private SimpleDateFormat df = new SimpleDateFormat("yyyyMMdd");
	private String todayDate;

	public DailyDetailListAdapter(Context context, List<Map<String, Object>> objects, Date today) {
		super(context, 0, objects);
		this.todayDate = df.format(today);
		inflater = (LayoutInflater) context.getSystemService(Context.LAYOUT_INFLATER_SERVICE);
	}

	/**
	 * TODO
	 */
	public View getView(final int position, View convertView, ViewGroup parent) {
		if (convertView == null) {
			convertView = inflater.inflate(R.layout.daily_detail_item, null);
		}
		Map<String, Object> item = getItem(position);

		// e
		TextView tvContent = (TextView) convertView.findViewById(R.id.content);
		tvContent.setText((String) item.get(BudgetTable.COLUMN_CONTENTS));
		// JeS
		TextView tvCategory = (TextView) convertView.findViewById(R.id.category);
		tvCategory.setText((String) item.get(BudgetTable.COLUMN_CATEGORY));
		// z
		TextView tvAmount = (TextView) convertView.findViewById(R.id.amount);
		tvAmount.setText(decimalFormat.format(item.get(BudgetTable.COLUMN_AMOUNT)));
		// 
		String memo = (String) item.get(BudgetTable.COLUMN_MEMO);
		convertView.setTag(R.string.resource_memo, memo);
		// tO
		if (memo != null && !"".equals(memo)) {
			TextView tvMemoFlag = (TextView) convertView.findViewById(R.id.memoFlag);
			tvMemoFlag.setVisibility(View.VISIBLE);
		} else {
			TextView tvMemoFlag = (TextView) convertView.findViewById(R.id.memoFlag);
			tvMemoFlag.setVisibility(View.INVISIBLE);
		}
		// TX_ID
		convertView.setTag(R.string.resource_tx_id, item.get(BudgetTable.COLUMN_TX_ID));
		
		// o
		String txDate = (String) item.get(BudgetTable.COLUMN_TX_DATE);
		// 
		String finishDate = (String) item.get(BudgetCreditcardExtTable.COLUMN_FINISH_DATE);
		
		// xXe[^X
		TextView tvPayStatus = (TextView) convertView.findViewById(R.id.payStatus);
		Preference pref = new Preference(getContext());
		String timing = pref.getCreditPayTiming();
		String status = (String) item.get(BudgetCreditcardExtTable.COLUMN_STATUS);
		if ("1".equals(status)) {
			if (Preference.CREDIT_BUY.equals(timing)) {
				if (todayDate.equals(finishDate)) {
					tvPayStatus.setText("\n");
				}
			} else {
				if (todayDate.equals(txDate)) {
					tvPayStatus.setText("\n");
				}
			}
		} else if ("0".equals(status)) {
			if (Preference.CREDIT_PAY.equals(timing)) {
				// 㕥
				tvPayStatus.setText("\n");
			}
		}
		
		return convertView;
	}



}
