package net.atlabo.money.adapter;

import java.text.DecimalFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.List;
import java.util.Map;

import net.atlabo.money.R;
import net.atlabo.money.db.table.BudgetTable;

import android.content.Context;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ArrayAdapter;
import android.widget.TextView;

public class CreditListAdapter extends ArrayAdapter<Map<String, Object>> {
	private LayoutInflater inflater;
	private DecimalFormat decimalFormat = new DecimalFormat("###,###,###~");
	private SimpleDateFormat df = new SimpleDateFormat("yyyy.M.d");
	private SimpleDateFormat df2 = new SimpleDateFormat("yyyyMMdd");

	public CreditListAdapter(Context context, List<Map<String, Object>> objects) {
		super(context, 0, objects);

		inflater = (LayoutInflater) context.getSystemService(Context.LAYOUT_INFLATER_SERVICE);
	}

	/**
	 * TODO
	 */
	public View getView(final int position, View convertView, ViewGroup parent) {
		if (convertView == null) {
			convertView = inflater.inflate(R.layout.credit_list_item, null);
		}
		Map<String, Object> item = getItem(position);

		// t
		TextView tvDate = (TextView) convertView.findViewById(R.id.date);
		try {
			tvDate.setText(df.format(df2.parse((String) item.get(BudgetTable.COLUMN_TX_DATE))));
		} catch (ParseException e) {
		}
		
		// e
		TextView tvContent = (TextView) convertView.findViewById(R.id.content);
		tvContent.setText((String) item.get(BudgetTable.COLUMN_CONTENTS));
		// JeS
		TextView tvCategory = (TextView) convertView.findViewById(R.id.category);
		tvCategory.setText((String) item.get(BudgetTable.COLUMN_CATEGORY));
		// z
		TextView tvAmount = (TextView) convertView.findViewById(R.id.amount);
		tvAmount.setText(decimalFormat.format(item.get(BudgetTable.COLUMN_AMOUNT)));
		// 
		String memo = (String) item.get(BudgetTable.COLUMN_MEMO);
		convertView.setTag(R.string.resource_memo, memo);
		// tO
		if (memo != null && !"".equals(memo)) {
			TextView tvMemoFlag = (TextView) convertView.findViewById(R.id.memoFlag);
			tvMemoFlag.setVisibility(View.VISIBLE);
		} else {
			TextView tvMemoFlag = (TextView) convertView.findViewById(R.id.memoFlag);
			tvMemoFlag.setVisibility(View.INVISIBLE);
		}
		// TX_ID
		convertView.setTag(R.string.resource_tx_id, item.get(BudgetTable.COLUMN_TX_ID));

		return convertView;
	}



}
