package net.atlabo.money.adapter;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

import net.atlabo.money.R;
import android.content.Context;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ArrayAdapter;
import android.widget.ImageView;
import android.widget.TextView;

public class CategoryAdapter extends ArrayAdapter<Map<String, Object>> {
	private static final List<Map<String, Object>> CATEGORY_LIST = new ArrayList<Map<String,Object>>();
	private LayoutInflater inflater;

	static {
		HashMap<String, Object> map = new HashMap<String, Object>();
		map.put("NAME", "");
		map.put("RESOURCE_ID", -1);
		CATEGORY_LIST.add(map);

		map = new HashMap<String, Object>();
		map.put("NAME", "H");
		map.put("RESOURCE_ID", R.drawable.knife_fork2);
		CATEGORY_LIST.add(map);

		map = new HashMap<String, Object>();
		map.put("NAME", "M");
		map.put("RESOURCE_ID", R.drawable.light);
		CATEGORY_LIST.add(map);

		map = new HashMap<String, Object>();
		map.put("NAME", "۔");
		map.put("RESOURCE_ID", R.drawable.couple_sc44);
		CATEGORY_LIST.add(map);

		map = new HashMap<String, Object>();
		map.put("NAME", "");
		map.put("RESOURCE_ID", R.drawable.pencil1);
		CATEGORY_LIST.add(map);

		map = new HashMap<String, Object>();
		map.put("NAME", "ʐM");
		map.put("RESOURCE_ID", R.drawable.phone_cell);
		CATEGORY_LIST.add(map);

		map = new HashMap<String, Object>();
		map.put("NAME", "ʔ");
		map.put("RESOURCE_ID", R.drawable.bus3_sc44);
		CATEGORY_LIST.add(map);

		map = new HashMap<String, Object>();
		map.put("NAME", "[");
		map.put("RESOURCE_ID", R.drawable.home7);
		CATEGORY_LIST.add(map);

		map = new HashMap<String, Object>();
		map.put("NAME", "핞");
		map.put("RESOURCE_ID", R.drawable.shirt1);
		CATEGORY_LIST.add(map);

		map = new HashMap<String, Object>();
		map.put("NAME", "Ô");
		map.put("RESOURCE_ID", R.drawable.pill);
		CATEGORY_LIST.add(map);

		map = new HashMap<String, Object>();
		map.put("NAME", "y");
		map.put("RESOURCE_ID", R.drawable.soccer);
		CATEGORY_LIST.add(map);

		map = new HashMap<String, Object>();
		map.put("NAME", "ŋ");
		map.put("RESOURCE_ID", R.drawable.yen);
		CATEGORY_LIST.add(map);

		map = new HashMap<String, Object>();
		map.put("NAME", "R");
		map.put("RESOURCE_ID", R.drawable.gaspump2);
		CATEGORY_LIST.add(map);

		map = new HashMap<String, Object>();
		map.put("NAME", "e");
		map.put("RESOURCE_ID", R.drawable.scissors_comb1_sc44);
		CATEGORY_LIST.add(map);

		map = new HashMap<String, Object>();
		map.put("NAME", "ی");
		map.put("RESOURCE_ID", R.drawable.heart_solid_sc44);
		CATEGORY_LIST.add(map);

		map = new HashMap<String, Object>();
		map.put("NAME", "G");
		map.put("RESOURCE_ID", R.drawable.cube);
		CATEGORY_LIST.add(map);

		map = new HashMap<String, Object>();
		map.put("NAME", "̑");
		map.put("RESOURCE_ID", R.drawable.question);
		CATEGORY_LIST.add(map);
	}

	/**
	 * RXgN^
	 * @param context
	 * @param objects
	 */
	private CategoryAdapter(Context context, List<Map<String, Object>> objects) {
		super(context, 0, objects);
	}

	/**
	 * RXgN^
	 * @param context
	 */
	public CategoryAdapter(Context context) {
		super(context, 0, CATEGORY_LIST);
		inflater = (LayoutInflater) context.getSystemService(Context.LAYOUT_INFLATER_SERVICE);
	}

	public View getView(int position, View convertView, ViewGroup viewgroup) {
		Log.v("CategoryAdapter", "getView start!!");

		Map<String, Object> item = getItem(position);

		TextView textView = new TextView(getContext());
		textView.setText((String) item.get("NAME"));

		return textView;
	}

	public View getDropDownView(int position, View convertView, ViewGroup viewgroup) {
		Log.v("CategoryAdapter", "getDropDownView start!! [i=" + position + "view=" + convertView + "viewgroup=" + viewgroup + "]");

		if (convertView == null) {
			convertView = inflater.inflate(R.layout.category, null);
		}

		Map<String, Object> item = getItem(position);

		ImageView imageView = (ImageView) convertView.findViewById(R.id.categoryImage);
		TextView textView = (TextView) convertView.findViewById(R.id.categoryText);

		int resourceId = (Integer) item.get("RESOURCE_ID");

		if (resourceId != -1) {
			imageView.setImageDrawable(convertView.getResources().getDrawable(resourceId));
		} else {
			imageView.setImageDrawable(null);
		}
		textView.setText((String) item.get("NAME"));

		return convertView;
	}

	/**
	 * JeŜʒu擾
	 * ݂Ȃꍇ́u0vԋp
	 * @param name
	 * @return
	 */
	public int getPosition(String name) {
		Iterator<Map<String, Object>> it = CATEGORY_LIST.iterator();
		Map<String, Object> map = null;
		int i = 0;
		while (it.hasNext()) {
			map = it.next();
			if (name.equals((String) map.get("NAME"))) {
				return i;
			}
			i++;
		}

		return 0;
	}


}
