package net.atlabo.money.adapter;

import java.util.List;
import java.util.Map;

import net.atlabo.money.R;
import net.atlabo.money.db.table.BudgetTable;
import android.content.Context;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ArrayAdapter;
import android.widget.TextView;

public class CalendarAdapter extends ArrayAdapter<List<Map<String, Object>>> {

	private LayoutInflater inflater;

	private int[] ids = new int[]{
		R.id.sun,
		R.id.mon,
		R.id.tue,
		R.id.wed,
		R.id.thu,
		R.id.fri,
		R.id.sat
	};


	public CalendarAdapter(Context context, List<List<Map<String, Object>>> objects) {
		super(context, 0, objects);
		inflater = (LayoutInflater) context.getSystemService(Context.LAYOUT_INFLATER_SERVICE);
	}

	public View getView(final int position, View convertView, ViewGroup parent) {
		convertView = inflater.inflate(R.layout.weekly_calendar, null);

		List<Map<String, Object>> list = getItem(position);

		Map<String, Object> map = null;
		TextView tvDate = null;
		for (int i=0; i<7; i++) {
			map = list.get(i);
			if (map == null) {
				continue;
			}

			tvDate = (TextView) convertView.findViewById(ids[i]);
			tvDate.setText(Integer.toString(Integer.parseInt((String) map.get(BudgetTable.COLUMN_TX_DATE))));
		}

		return convertView;
	}

}
