package net.atlabo.money.activity;

import net.atlabo.money.R;
import net.atlabo.money.util.Preference;
import twitter4j.TwitterException;
import twitter4j.auth.AccessToken;
import twitter4j.auth.OAuthAuthorization;
import twitter4j.conf.Configuration;
import twitter4j.conf.ConfigurationBuilder;
import android.content.Intent;
import android.net.Uri;
import android.os.Bundle;
import android.util.Log;

public class TwitterActivity extends ExtendedActivity {
	public  static final int RET_OK = 1;
	public static final int RET_NG = 9;

	private OAuthAuthorization mOauth;

	public void onCreate(Bundle savedInstanceState) {
		super.onCreate(savedInstanceState);

		try {
			// vt@Xݒl擾
			Preference pref = new Preference(this);
			String accessToken = pref.getAccessToken();
			String accessTokenSecret = pref.getAccessTokenSecret();

			if (accessToken == null || accessTokenSecret == null) {
				// ǂ炩Ȃꍇ擾
				askOAuth();
			} else {
				// ݂ꍇAI
				setResult(RET_OK);
				Log.v("twitter", "RESULT OK1");
				finish();
			}
		} catch (Exception e) {
			Log.e("twitter", "G[܂B", e);
			setResult(RET_NG);
			Log.v("twitter", "RESULT_NG1");
			finish();
		}


	}

	private void askOAuth() throws TwitterException {
		ConfigurationBuilder cbuilder = new ConfigurationBuilder();
		cbuilder.setOAuthConsumerKey(getString(R.string.consumer_key));
		cbuilder.setOAuthConsumerSecret(getString(R.string.consumer_secret));
		Configuration conf = cbuilder.build();
		mOauth = new OAuthAuthorization(conf);
		mOauth.setOAuthAccessToken(null); // ȂƉLgetOAuthRequestToken()ŗO
		String authUrl = null;

		authUrl = mOauth.getOAuthRequestToken(getString(R.string.callback_url)).getAuthorizationURL();

		Intent intent = new Intent(Intent.ACTION_VIEW, Uri.parse(authUrl));
		startActivity(intent);
	}

	@Override
	protected void onNewIntent(Intent intent) {
		super.onNewIntent(intent);

		Uri uri = intent.getData();
		if (uri != null && uri.toString().startsWith(getString(R.string.callback_url))) {
			String verifier = uri.getQueryParameter("oauth_verifier");
			try {
				AccessToken at = mOauth.getOAuthAccessToken(verifier);
				// i ***** ŗLȂ̂ŁARs[ꍇ͂ςB *******
				Preference preference = new Preference(this);
				preference.setAccessToken(at.getToken());
				preference.setAccessTokenSecret(at.getTokenSecret());
				preference.commit();
				setResult(RET_OK);
				Log.v("twitter", "RESULT_OK2");
				finish();
			} catch (Exception e) {
				Log.e("twitter", "CX^X擾Ɏs܂", e);
				setResult(RET_NG);
				Log.v("twitter", "RESULT_NG2");
				finish();
			}
		}
	}


}
