package net.atlabo.money.activity;

import java.text.SimpleDateFormat;
import java.util.List;
import java.util.Map;

import org.afree.chart.AFreeChart;
import org.afree.chart.ChartFactory;
import org.afree.data.general.DefaultPieDataset;
import org.afree.data.general.PieDataset;

import net.atlabo.money.R;
import net.atlabo.money.component.SamplePieChartView;
import net.atlabo.money.dao.BudgetDao;
import net.atlabo.money.dao.ConnectionManager;
import net.atlabo.money.db.table.BudgetTable;
import net.atlabo.money.util.Preference;

import android.os.Bundle;
import android.view.View;
import android.widget.TextView;

/**
 * Ԃ̃JeSʃOt\NX
 * @author Atsushi Nakamoto
 *
 */
public class MonthlyCategoryChartActivity extends ExtendedActivity {
	private SimpleDateFormat df = new SimpleDateFormat("yyyyNM");
	private SimpleDateFormat df2 = new SimpleDateFormat("yyyyMM");

	@Override
	public void onCreate(Bundle savedInstanceState) {
		super.onCreate(savedInstanceState);

		setContentView(R.layout.monthly_category_chart);
		
		// NWbg^C~O擾
		Preference pref = new Preference(this);
		String timing = pref.getCreditPayTiming();

		// JeSʂ̏o擾
		ConnectionManager manager = ConnectionManager.getInstance(this);
		manager.setReadableDatabase();
		BudgetDao budgetDao = new BudgetDao(manager);
		List<Map<String, Object>> list = null;
		
		if (Preference.CREDIT_BUY.equals(timing)) {
			// x
			list = budgetDao.selectMonthlyByCategory(df2.format(date));
		} else {
			list = budgetDao.selectMonthlyByCategoryAfterPay(df2.format(date));
		}

		SamplePieChartView view = (SamplePieChartView) findViewById(R.id.pieChartView);
		if (list.size() > 0) {
			// R[hꍇ
			AFreeChart chart = ChartFactory.createPieChart(
					df.format(date), createDataset(list), true, true, false);
			view.setChart(chart);
		} else {
			// R[hȂꍇ
			TextView tv = (TextView) findViewById(R.id.errorMsg);
			tv.setVisibility(View.VISIBLE);

			view.setVisibility(View.GONE);
		}

		manager.close();
	}

	/**
	 * DataSet𐶐
	 * @param list
	 * @return
	 */
	private PieDataset createDataset(List<Map<String, Object>> list) {
		DefaultPieDataset dataset = new DefaultPieDataset();

		String category = null;
		int amount = 0;
		for (Map<String, Object> map : list) {
			// JeS
			category = (String) map.get(BudgetTable.COLUMN_CATEGORY);
			// z
			amount = (Integer) map.get(BudgetTable.COLUMN_AMOUNT);

			// DataSetɒlݒ
			dataset.setValue(category, amount);
		}


		return dataset;
	}

	/**
	 * ԃ{^̏
	 * @param view
	 */
	public void onMonthlyClick(View view) {
		moveActivity(DailySummaryActivity.class);
	}

    /**
     * JeS{^̏
     * @param view
     */
    public void onCategoryClick(View view) {
    	moveActivity(MonthlyCategoryActivity.class);
    }
}
