package net.atlabo.money.activity;

import java.util.Date;

import android.app.Activity;
import android.content.Intent;
import android.os.Bundle;

/**
 * ActivitypAvʂ̓
 * @author Atsushi Nakamoto
 *
 */
public class ExtendedActivity extends Activity {
	/** Intentň񂷓tp[^ */
	public static final String PARAM_DATE = "PARAM_DATE";
	/** Jڌ */
	public static final String PARAM_FROM_ACTIVITY = "PARAM_FROM_ACTIVITY";

	// Ώۓt
	protected Date date;

	public void onCreate(Bundle savedInstanceState) {
		super.onCreate(savedInstanceState);

		/*
		 * Intentt擾
		 */
		Intent intent = getIntent();
		date = (Date) intent.getSerializableExtra(PARAM_DATE);
		if (date == null) {
			// MȂꍇ͖{tݒ
			date = new Date();
		}
	}

	public void onResume() {
		super.onResume();
	}

	/**
	 * ʑJڂ
	 * @param activity
	 * @param c
	 * @param finishActivity
	 */
	public void moveActivity(Class<? extends Activity> c) {
		moveActivityWithAnimation(c, -1, -1);
	}

	public void moveActivity(Class<? extends Activity> c, Date date) {
		moveActivityWithAnimation(c, -1, -1, date);
	}

	/**
	 * ʑJڂ
	 * @param intent
	 */
	protected void moveActivity(Intent intent) {
		intent.putExtra(PARAM_DATE, date);
		intent.putExtra(PARAM_FROM_ACTIVITY, this.getClass().getName());
		startActivity(intent);
	}

	/**
	 * ʑJڂ
	 * ʑJڎɃAj[V𔭐
	 * @param c
	 * @param fromAnim
	 * @param toAnim
	 * @param finishActivity
	 */
	protected void moveActivityWithAnimation(Class<? extends Activity> c,
			int fromAnim,
			int toAnim) {
		moveActivityWithAnimation(c, fromAnim, toAnim, date);
	}

	protected void moveActivityWithAnimation(Class<? extends Activity> c,
			int fromAnim,
			int toAnim,
			Date date) {
		Intent intent = new Intent(this, c);
		intent.putExtra(PARAM_DATE, date);
		intent.putExtra(PARAM_FROM_ACTIVITY, this.getClass().getName());
		startActivity(intent);

		if (fromAnim != -1 && toAnim != -1) {
			overridePendingTransition(fromAnim, toAnim);
		}
	}


}
