package net.atlabo.money.activity;

import java.text.DecimalFormat;
import java.util.List;
import java.util.Map;

import net.atlabo.money.R;
import net.atlabo.money.adapter.CreditListAdapter;
import net.atlabo.money.dao.BudgetCreditcardExtDao;
import net.atlabo.money.dao.ConnectionManager;
import net.atlabo.money.db.table.BudgetTable;
import android.app.Activity;
import android.os.Bundle;
import android.view.View;
import android.widget.ListView;
import android.widget.TextView;

public class CreditListActivity extends Activity {
	
	private DecimalFormat decimalFormat = new DecimalFormat("###,###,###~");

	public void onCreate(Bundle savedInstanceState) {
		super.onCreate(savedInstanceState);

		setContentView(R.layout.credit_list);
		
		// NWbgJ[hxꗗ擾
		ConnectionManager manager = ConnectionManager.getInstance(this);
		manager.setReadableDatabase();
		BudgetCreditcardExtDao dao = new BudgetCreditcardExtDao(manager);
		List<Map<String, Object>> list = dao.selectWithNotFinished();
		ListView listView = (ListView) findViewById(R.id.listview);
		
		if (list.isEmpty()) {
			// x݂Ȃꍇ
			TextView tvNothingMsg = (TextView) findViewById(R.id.nothingMsg);
			tvNothingMsg.setVisibility(View.VISIBLE);
			listView.setVisibility(View.GONE);
		}
		
		// vz擾
		int totalAmount = 0;
		for (Map<String, Object> map : list) {
			Integer amount = (Integer) map.get(BudgetTable.COLUMN_AMOUNT);
			totalAmount += amount;
		}
		
		TextView tvTotalAmount = (TextView) findViewById(R.id.totalAmount);
		tvTotalAmount.setText(decimalFormat.format(totalAmount));
		
		CreditListAdapter adapter = new CreditListAdapter(this, list);
		listView.setAdapter(adapter);
		manager.close();
	}
}
