package net.atlabo.money.activity;

import net.atlabo.money.R;
import net.atlabo.money.dao.ConnectionManager;
import net.atlabo.money.dao.HistoryDao;
import net.atlabo.money.logic.WidgetLogic;
import net.atlabo.money.util.ConfigUtil;
import net.atlabo.money.util.Preference;
import android.app.Activity;
import android.content.Intent;
import android.os.Bundle;
import android.util.Log;
import android.view.View;
import android.widget.Button;
import android.widget.RadioButton;
import android.widget.RadioGroup;
import android.widget.RadioGroup.OnCheckedChangeListener;
import android.widget.TextView;

/**
 * ݒpActivity
 * @author Atsushi Nakamoto
 *
 */
public class ConfigActivity extends Activity {

	/** twitter̐ݒ肪Ă邩ǂ */
	private String twitterTag = null;
	/** facebook̐ݒ肪Ă邩ǂ */
	private String facebookTag = null;

	public void onCreate(Bundle savedInstanceState) {
		super.onCreate(savedInstanceState);

		setContentView(R.layout.config);
	}

	public void onResume() {
		super.onResume();
		
		// NWbgJ[hݒ
		RadioGroup radioGroup = (RadioGroup) findViewById(R.id.radiogroup);
		radioGroup.setOnCheckedChangeListener(new OnCheckedChangeListener() {
			@Override
			public void onCheckedChanged(RadioGroup group, int checkedId) {
				RadioButton radio = (RadioButton) findViewById(checkedId);
				String flag = (String) radio.getTag();
				onCreditPayCheck(flag);
			}
		});
		Preference pref = new Preference(this);
		String timing = pref.getCreditPayTiming();
		if (Preference.CREDIT_BUY.equals(timing)) {
			radioGroup.check(R.id.buy);
		} else if (Preference.CREDIT_PAY.equals(timing)) {
			radioGroup.check(R.id.pay);
		}

		// ̌擾
		ConnectionManager manager = ConnectionManager.getInstance(this);
		HistoryDao dao = new HistoryDao(manager);
		int count = dao.count();
		manager.close();

		TextView tvHistoryCount = (TextView) findViewById(R.id.historyCount);

		if (count == 0) {
			tvHistoryCount.setEnabled(false);
		} else {
			tvHistoryCount.setEnabled(true);
		}

		tvHistoryCount.setText(count + "");
		
		// 0̏ꍇ̓{^\Ȃ
		if (count == 0) {
			Button historyButton = (Button) findViewById(R.id.historyButton);
			historyButton.setVisibility(View.GONE);
		}

		// twitterݒ擾
		boolean isRegistedTwitter = ConfigUtil.isRegistedTwitter(this);
		String twitterText = null;
		twitterTag = null;
		if (isRegistedTwitter) {
			twitterText = "ݒ肠";
			twitterTag = "1";
		} else {
			twitterText = "ݒȂ";
			twitterTag = "0";
		}

		TextView tvTwitterConfig = (TextView) findViewById(R.id.twitterConfig);
		tvTwitterConfig.setText(twitterText);

		// facebookݒ擾
		boolean isRegistedFacebook = ConfigUtil.isRegistedFacebook(this);
		String facebookText = null;
		facebookTag = null;
		if (isRegistedFacebook) {
			facebookText = "ݒ肠";
			facebookTag = "1";
		} else {
			facebookText = "ݒȂ";
			facebookTag = "0";
		}

		TextView tvFacebookConfig = (TextView) findViewById(R.id.facebookConfig);
		tvFacebookConfig.setText(facebookText);
	}
	
	/**
	 * NWbg^C~O`FbN̏
	 */
	private void onCreditPayCheck(String flag) {
		Preference pref = new Preference(this);
		pref.setCreditPayTiming(flag);
		pref.commit();
		
		// EBWFbgXV
		WidgetLogic logic = new WidgetLogic();
		logic.execute(this);
	}

	/**
	 * Ǘ{^NbN
	 * @param view
	 */
	public void onManageHistoryClick(View view) {
		Intent intent = new Intent(this, InputHistoryConfigActivity.class);
		startActivity(intent);
	}

	/**
	 * twitterNbN
	 * @param view
	 */
	public void onTwitterClick(View view) {
		if ("1".equals(twitterTag)) {
			// ݒ肠̏ꍇ͉Ȃ
			return;
		}
		Log.v("twitter", "TwitterActivityIntents");
		Intent intent = new Intent(this, TwitterActivity.class);
		startActivity(intent);
	}

	/**
	 * facebookNbN
	 * @param view
	 */
	public void onFacebookClick(View view) {
		if ("1".equals(facebookTag)) {
			// ݒ肠̏ꍇ͉Ȃ
			return;
		}

		Log.v("facebook", "FBAuthActivityIntents");
		Intent intent = new Intent(this, FBAuthActivity.class);
		startActivity(intent);
	}
}
