/*
 * Decompiled with CFR 0.152.
 */
package org.afree.util;

import android.graphics.Matrix;
import android.graphics.Path;
import android.graphics.PointF;
import android.graphics.RectF;
import org.afree.graphics.geom.ArcShape;
import org.afree.graphics.geom.LineShape;
import org.afree.graphics.geom.OvalShape;
import org.afree.graphics.geom.PathShape;
import org.afree.graphics.geom.Polygon;
import org.afree.graphics.geom.RectShape;
import org.afree.graphics.geom.Shape;
import org.afree.ui.RectangleAnchor;
import org.afree.util.ObjectUtilities;

public class ShapeUtilities {
    private ShapeUtilities() {
    }

    public static Shape clone(Shape shape) {
        if (shape instanceof Cloneable) {
            try {
                return (Shape)ObjectUtilities.clone(shape);
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                // empty catch block
            }
        }
        Shape result = null;
        return result;
    }

    public static boolean equal(Shape s1, Shape s2) {
        if (s1 instanceof LineShape && s2 instanceof LineShape) {
            return ShapeUtilities.equal((LineShape)s1, (LineShape)s2);
        }
        if (s1 instanceof OvalShape && s2 instanceof OvalShape) {
            return ShapeUtilities.equal((OvalShape)s1, (OvalShape)s2);
        }
        if (s1 instanceof ArcShape && s2 instanceof ArcShape) {
            return ShapeUtilities.equal((ArcShape)s1, (ArcShape)s2);
        }
        if (s1 instanceof Polygon && s2 instanceof Polygon) {
            return ShapeUtilities.equal((Polygon)s1, (Polygon)s2);
        }
        if (s1 instanceof PathShape && s2 instanceof PathShape) {
            return ShapeUtilities.equal((PathShape)s1, (PathShape)s2);
        }
        return ObjectUtilities.equal(s1, s2);
    }

    public static boolean equal(LineShape l1, LineShape l2) {
        if (l1 == null) {
            return l2 == null;
        }
        if (l2 == null) {
            return false;
        }
        if (!l1.getP1().equals(l2.getP1())) {
            return false;
        }
        return l1.getP2().equals(l2.getP2());
    }

    public static boolean equal(OvalShape e1, OvalShape e2) {
        if (e1 == null) {
            return e2 == null;
        }
        return e2 != null;
    }

    public static boolean equal(ArcShape a1, ArcShape a2) {
        if (a1 == null) {
            return a2 == null;
        }
        if (a2 == null) {
            return false;
        }
        if (a1.getAngleStart() != a2.getAngleStart()) {
            return false;
        }
        if (a1.getAngleExtent() != a2.getAngleExtent()) {
            return false;
        }
        return a1.equals(a2);
    }

    public static boolean equal(Polygon p1, Polygon p2) {
        if (p1 == null) {
            return p2 == null;
        }
        if (p2 == null) {
            return false;
        }
        return !p1.equals(p2);
    }

    public static boolean equal(PathShape p1, PathShape p2) {
        if (p1 == null) {
            return p2 == null;
        }
        return p2 != null;
    }

    public static Shape createTranslatedShape(Shape shape, double transX, double transY) {
        if (shape == null) {
            throw new IllegalArgumentException("Null 'shape' argument.");
        }
        Matrix mat = new Matrix();
        mat.postTranslate((float)transX, (float)transY);
        Path path = new Path(shape.getPath());
        path.transform(mat);
        RectF rect = new RectF();
        path.computeBounds(rect, false);
        return new PathShape(path);
    }

    public static Shape createTranslatedShape(Shape shape, RectangleAnchor anchor, double locationX, double locationY) {
        if (shape == null) {
            throw new IllegalArgumentException("Null 'shape' argument.");
        }
        if (anchor == null) {
            throw new IllegalArgumentException("Null 'anchor' argument.");
        }
        Matrix mat = new Matrix();
        mat.postTranslate((float)locationX, (float)locationY);
        Path path = new Path(shape.getPath());
        path.transform(mat);
        RectF rect = new RectF();
        path.computeBounds(rect, false);
        return new PathShape(path);
    }

    public static Shape rotateShape(Shape base, double angle, float x, float y) {
        if (base == null) {
            return null;
        }
        Matrix mat = new Matrix();
        mat.postRotate((float)Math.toDegrees(angle), x, y);
        Path path = new Path(base.getPath());
        path.transform(mat);
        RectF rect = new RectF();
        path.computeBounds(rect, false);
        return new PathShape(path);
    }

    public static PointF getPointInRectShape(double x, double y, RectShape area) {
        x = Math.max((double)area.getMinX(), Math.min(x, (double)area.getMaxX()));
        y = Math.max((double)area.getMinY(), Math.min(y, (double)area.getMaxY()));
        return new PointF((float)x, (float)y);
    }
}

