/*
 * Decompiled with CFR 0.152.
 */
package org.afree.graphics.geom;

import android.graphics.Canvas;
import android.graphics.Matrix;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.PointF;
import android.graphics.Rect;
import android.graphics.RectF;
import android.graphics.Region;
import android.graphics.RegionIterator;
import org.afree.graphics.geom.RectShape;
import org.afree.graphics.geom.Shape;

public class PathShape
implements Shape {
    private Path mPath;
    private Region mRegion;

    public PathShape() {
        this(new Path());
    }

    public PathShape(Path path) {
        this.mPath = path;
        this.update();
    }

    public PathShape(PathShape pathShape) {
        this(new Path(pathShape.getPath()));
    }

    public Path getPath() {
        return this.mPath;
    }

    public void setPath(Path path) {
        this.mPath = path;
        this.update();
    }

    public void draw(Canvas canvas, Paint paint) {
        paint.setStyle(Paint.Style.STROKE);
        canvas.drawPath(this.mPath, paint);
    }

    public void fill(Canvas canvas, Paint paint) {
        paint.setStyle(Paint.Style.FILL);
        canvas.drawPath(this.mPath, paint);
    }

    public void fillAndStroke(Canvas canvas, Paint paint) {
        paint.setStyle(Paint.Style.FILL_AND_STROKE);
        canvas.drawPath(this.mPath, paint);
    }

    public void clip(Canvas canvas) {
        canvas.clipPath(this.mPath);
        this.update();
    }

    public boolean contains(RectShape rect) {
        Region tmpRegion = new Region();
        Region targetRegion = new Region((int)rect.getX(), (int)rect.getY(), (int)(rect.getWidth() + rect.getX()), (int)(rect.getHeight() + rect.getY()));
        tmpRegion.op(this.mRegion, targetRegion, Region.Op.INTERSECT);
        return !targetRegion.op(tmpRegion, Region.Op.XOR);
    }

    public boolean contains(float x, float y) {
        return this.mRegion.contains((int)x, (int)y);
    }

    public boolean contains(float x, float y, float width, float height) {
        Region tmpRegion = new Region();
        Region targetRegion = new Region((int)x, (int)y, (int)(width + x), (int)(height + y));
        tmpRegion.op(this.mRegion, targetRegion, Region.Op.INTERSECT);
        return !targetRegion.op(tmpRegion, Region.Op.XOR);
    }

    public boolean contains(PointF point) {
        return this.mRegion.contains((int)point.x, (int)point.y);
    }

    @Deprecated
    public RectShape getBounds() {
        return new RectShape(this.mRegion.getBounds());
    }

    public void getBounds(RectShape rect) {
        rect.setRect(this.mRegion.getBounds());
    }

    public boolean intersects(float x, float y, float width, float height) {
        if (this.mRegion.isEmpty()) {
            return false;
        }
        Rect rect = new Rect();
        RegionIterator iterator = new RegionIterator(this.mRegion);
        Region region = new Region(this.mRegion);
        if (iterator.next(rect)) {
            float tmph;
            float tmpy;
            float tmpw;
            float tmpx;
            if (x < width + x) {
                tmpx = x;
                tmpw = width;
            } else {
                tmpx = width + x;
                tmpw = Math.abs(width);
            }
            if (y < height + y) {
                tmpy = y;
                tmph = height;
            } else {
                tmpy = height + y;
                tmph = Math.abs(height);
            }
            return region.op((int)tmpx, (int)tmpy, (int)(tmpx + tmpw), (int)(tmpy + tmph), Region.Op.INTERSECT);
        }
        return false;
    }

    public boolean intersects(Rect rect) {
        return this.intersects(rect.left, rect.top, rect.right - rect.left, rect.bottom - rect.top);
    }

    public boolean intersects(RectShape rect) {
        return this.intersects(rect.getX(), rect.getY(), rect.getWidth(), rect.getHeight());
    }

    public void translate(float x, float y) {
        Matrix mat = new Matrix();
        mat.postTranslate(x, y);
        this.mPath.transform(mat);
        this.update();
    }

    public void moveTo(float x, float y) {
        this.mPath.moveTo(x, y);
        this.update();
    }

    public void lineTo(float x, float y) {
        this.mPath.lineTo(x, y);
        this.update();
    }

    public void append(Shape shape) {
        this.mPath.addPath(shape.getPath());
        this.update();
    }

    public void closePath() {
        this.mPath.close();
        this.update();
    }

    public void reset() {
        this.mPath.reset();
        this.update();
    }

    public float getX() {
        return this.mRegion.getBounds().left;
    }

    public float getY() {
        return this.mRegion.getBounds().top;
    }

    public float getWidth() {
        return this.mRegion.getBounds().width();
    }

    public float getHeight() {
        return this.mRegion.getBounds().height();
    }

    private void update() {
        RectF rect = new RectF();
        this.mPath.computeBounds(rect, false);
        this.mRegion = new Region((int)rect.left, (int)rect.top, (int)rect.right, (int)rect.bottom);
        this.mRegion.setPath(this.mPath, this.mRegion);
    }

    public boolean equals(Object o) {
        if (o instanceof PathShape) {
            PathShape pathShape = (PathShape)o;
            Region region = new Region(this.mRegion);
            if (!region.op(pathShape.mRegion, Region.Op.XOR)) {
                return true;
            }
        }
        return false;
    }

    public Shape clone() {
        return new PathShape(this);
    }
}

