/*
 * Decompiled with CFR 0.152.
 */
package org.afree.chart.title;

import android.graphics.Canvas;
import android.graphics.Paint;
import java.io.Serializable;
import org.afree.chart.LegendItem;
import org.afree.chart.LegendItemCollection;
import org.afree.chart.LegendItemSource;
import org.afree.chart.block.Arrangement;
import org.afree.chart.block.Block;
import org.afree.chart.block.BlockContainer;
import org.afree.chart.block.BlockFrame;
import org.afree.chart.block.BlockResult;
import org.afree.chart.block.BorderArrangement;
import org.afree.chart.block.CenterArrangement;
import org.afree.chart.block.ColumnArrangement;
import org.afree.chart.block.EntityBlockParams;
import org.afree.chart.block.FlowArrangement;
import org.afree.chart.block.LabelBlock;
import org.afree.chart.block.RectangleConstraint;
import org.afree.chart.entity.EntityCollection;
import org.afree.chart.entity.StandardEntityCollection;
import org.afree.chart.entity.TitleEntity;
import org.afree.chart.event.TitleChangeEvent;
import org.afree.chart.title.LegendGraphic;
import org.afree.chart.title.LegendItemBlockContainer;
import org.afree.chart.title.Title;
import org.afree.graphics.PaintType;
import org.afree.graphics.PaintUtility;
import org.afree.graphics.SolidColor;
import org.afree.graphics.geom.Font;
import org.afree.graphics.geom.RectShape;
import org.afree.graphics.geom.Shape;
import org.afree.ui.RectangleAnchor;
import org.afree.ui.RectangleEdge;
import org.afree.ui.RectangleInsets;
import org.afree.ui.Size2D;

public class LegendTitle
extends Title
implements Cloneable,
Serializable {
    private static final long serialVersionUID = 2644010518533854633L;
    public static final Font DEFAULT_ITEM_FONT = new Font("SansSerif", 0, 12);
    public static final PaintType DEFAULT_ITEM_PAINT = new SolidColor(-16777216);
    private LegendItemSource[] sources;
    private transient PaintType backgroundPaintType;
    private RectangleEdge legendItemGraphicEdge;
    private RectangleAnchor legendItemGraphicAnchor;
    private RectangleAnchor legendItemGraphicLocation;
    private RectangleInsets legendItemGraphicPadding;
    private Font itemFont;
    private transient PaintType itemPaintType;
    private RectangleInsets itemLabelPadding;
    private BlockContainer items;
    private Arrangement hLayout;
    private Arrangement vLayout;
    private BlockContainer wrapper;

    public LegendTitle(LegendItemSource source) {
        this(source, new FlowArrangement(), new ColumnArrangement());
    }

    public LegendTitle(LegendItemSource source, Arrangement hLayout, Arrangement vLayout) {
        this.sources = new LegendItemSource[]{source};
        this.items = new BlockContainer(hLayout);
        this.hLayout = hLayout;
        this.vLayout = vLayout;
        this.backgroundPaintType = null;
        this.legendItemGraphicEdge = RectangleEdge.LEFT;
        this.legendItemGraphicAnchor = RectangleAnchor.CENTER;
        this.legendItemGraphicLocation = RectangleAnchor.CENTER;
        this.legendItemGraphicPadding = new RectangleInsets(2.0, 2.0, 2.0, 2.0);
        this.itemFont = DEFAULT_ITEM_FONT;
        this.itemPaintType = DEFAULT_ITEM_PAINT;
        this.itemLabelPadding = new RectangleInsets(2.0, 2.0, 2.0, 2.0);
    }

    public LegendItemSource[] getSources() {
        return this.sources;
    }

    public void setSources(LegendItemSource[] sources) {
        if (sources == null) {
            throw new IllegalArgumentException("Null 'sources' argument.");
        }
        this.sources = sources;
        this.notifyListeners(new TitleChangeEvent(this));
    }

    public PaintType getBackgroundPaintType() {
        return this.backgroundPaintType;
    }

    public void setBackgroundPaintType(PaintType paintType) {
        this.backgroundPaintType = paintType;
        this.notifyListeners(new TitleChangeEvent(this));
    }

    public RectangleEdge getLegendItemGraphicEdge() {
        return this.legendItemGraphicEdge;
    }

    public void setLegendItemGraphicEdge(RectangleEdge edge) {
        if (edge == null) {
            throw new IllegalArgumentException("Null 'edge' argument.");
        }
        this.legendItemGraphicEdge = edge;
        this.notifyListeners(new TitleChangeEvent(this));
    }

    public RectangleAnchor getLegendItemGraphicAnchor() {
        return this.legendItemGraphicAnchor;
    }

    public void setLegendItemGraphicAnchor(RectangleAnchor anchor) {
        if (anchor == null) {
            throw new IllegalArgumentException("Null 'anchor' point.");
        }
        this.legendItemGraphicAnchor = anchor;
    }

    public RectangleAnchor getLegendItemGraphicLocation() {
        return this.legendItemGraphicLocation;
    }

    public void setLegendItemGraphicLocation(RectangleAnchor anchor) {
        this.legendItemGraphicLocation = anchor;
    }

    public RectangleInsets getLegendItemGraphicPadding() {
        return this.legendItemGraphicPadding;
    }

    public void setLegendItemGraphicPadding(RectangleInsets padding) {
        if (padding == null) {
            throw new IllegalArgumentException("Null 'padding' argument.");
        }
        this.legendItemGraphicPadding = padding;
        this.notifyListeners(new TitleChangeEvent(this));
    }

    public Font getItemFont() {
        return this.itemFont;
    }

    public void setItemFont(Font font) {
        if (font == null) {
            throw new IllegalArgumentException("Null 'font' argument.");
        }
        this.itemFont = font;
        this.notifyListeners(new TitleChangeEvent(this));
    }

    public PaintType getItemPaintType() {
        return this.itemPaintType;
    }

    public void setItemPaintType(PaintType paintType) {
        if (paintType == null) {
            throw new IllegalArgumentException("Null 'paint' argument.");
        }
        this.itemPaintType = paintType;
        this.notifyListeners(new TitleChangeEvent(this));
    }

    public RectangleInsets getItemLabelPadding() {
        return this.itemLabelPadding;
    }

    public void setItemLabelPadding(RectangleInsets padding) {
        if (padding == null) {
            throw new IllegalArgumentException("Null 'padding' argument.");
        }
        this.itemLabelPadding = padding;
        this.notifyListeners(new TitleChangeEvent(this));
    }

    protected void fetchLegendItems() {
        this.items.clear();
        RectangleEdge p = this.getPosition();
        if (RectangleEdge.isTopOrBottom(p)) {
            this.items.setArrangement(this.hLayout);
        } else {
            this.items.setArrangement(this.vLayout);
        }
        int s = 0;
        while (s < this.sources.length) {
            LegendItemCollection legendItems = this.sources[s].getLegendItems();
            if (legendItems != null) {
                int i = 0;
                while (i < legendItems.getItemCount()) {
                    LegendItem item = legendItems.get(i);
                    Block block = this.createLegendItemBlock(item);
                    this.items.add(block);
                    ++i;
                }
            }
            ++s;
        }
    }

    protected Block createLegendItemBlock(LegendItem item) {
        PaintType textPaintType;
        BlockContainer result = null;
        LegendGraphic lg = new LegendGraphic(item.getShape(), item.getFillPaintType());
        lg.setShapeFilled(item.isShapeFilled());
        lg.setLine(item.getLine());
        lg.setLineStroke(item.getLineStroke());
        lg.setLinePaintType(item.getLinePaintType());
        lg.setLineVisible(item.isLineVisible());
        lg.setShapeVisible(item.isShapeVisible());
        lg.setShapeOutlineVisible(item.isShapeOutlineVisible());
        lg.setOutlinePaintType(item.getOutlinePaintType());
        lg.setOutlineStroke(item.getOutlineStroke());
        lg.setPadding(this.legendItemGraphicPadding);
        LegendItemBlockContainer legendItem = new LegendItemBlockContainer(new BorderArrangement(), item.getDataset(), item.getSeriesKey());
        lg.setShapeAnchor(this.getLegendItemGraphicAnchor());
        lg.setShapeLocation(this.getLegendItemGraphicLocation());
        legendItem.add(lg, this.legendItemGraphicEdge);
        Font textFont = item.getLabelFont();
        if (textFont == null) {
            textFont = this.itemFont;
        }
        if ((textPaintType = item.getLabelPaintType()) == null) {
            textPaintType = this.itemPaintType;
        }
        LabelBlock labelBlock = new LabelBlock(item.getLabel(), textFont, textPaintType);
        labelBlock.setPadding(this.itemLabelPadding);
        legendItem.add(labelBlock);
        legendItem.setToolTipText(item.getToolTipText());
        legendItem.setURLText(item.getURLText());
        result = new BlockContainer(new CenterArrangement());
        result.add(legendItem);
        return result;
    }

    public BlockContainer getItemContainer() {
        return this.items;
    }

    public Size2D arrange(Canvas canvas, RectangleConstraint constraint) {
        Size2D result = new Size2D();
        this.fetchLegendItems();
        if (this.items.isEmpty()) {
            return result;
        }
        BlockContainer container = this.wrapper;
        if (container == null) {
            container = this.items;
        }
        RectangleConstraint c = this.toContentConstraint(constraint);
        Size2D size = container.arrange(canvas, c);
        result.height = this.calculateTotalHeight(size.height);
        result.width = this.calculateTotalWidth(size.width);
        return result;
    }

    public void draw(Canvas canvas, RectShape area) {
        this.draw(canvas, area, null);
    }

    public Object draw(Canvas canvas, RectShape area, Object params) {
        EntityCollection ec;
        Object val;
        RectShape target = area.clone();
        RectShape hotspot = area.clone();
        StandardEntityCollection sec = null;
        if (params instanceof EntityBlockParams && ((EntityBlockParams)params).getGenerateEntities()) {
            sec = new StandardEntityCollection();
            sec.add(new TitleEntity((Shape)hotspot, this));
        }
        target = this.trimMargin(target);
        if (this.backgroundPaintType != null) {
            Paint backgroundPaint = PaintUtility.createPaint(1, this.backgroundPaintType);
            target.fill(canvas, backgroundPaint);
        }
        BlockFrame border = this.getFrame();
        border.draw(canvas, target);
        border.getInsets().trim(target);
        BlockContainer container = this.wrapper;
        if (container == null) {
            container = this.items;
        }
        if ((val = container.draw(canvas, target = this.trimPadding(target), params)) instanceof BlockResult && (ec = ((BlockResult)val).getEntityCollection()) != null && sec != null) {
            sec.addAll(ec);
            ((BlockResult)val).setEntityCollection(sec);
        }
        return val;
    }

    public BlockContainer getWrapper() {
        return this.wrapper;
    }

    public void setWrapper(BlockContainer wrapper) {
        this.wrapper = wrapper;
    }
}

