/*
 * Decompiled with CFR 0.152.
 */
package org.afree.chart.title;

import android.graphics.Canvas;
import android.graphics.Paint;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import org.afree.chart.block.BlockContainer;
import org.afree.chart.block.BorderArrangement;
import org.afree.chart.block.RectangleConstraint;
import org.afree.chart.event.TitleChangeEvent;
import org.afree.chart.title.Title;
import org.afree.graphics.PaintType;
import org.afree.graphics.PaintUtility;
import org.afree.graphics.geom.RectShape;
import org.afree.io.SerialUtilities;
import org.afree.ui.Size2D;

public class CompositeTitle
extends Title
implements Cloneable,
Serializable {
    private static final long serialVersionUID = -6770854036232562290L;
    private transient PaintType backgroundPaintType;
    private BlockContainer container;

    public CompositeTitle() {
        this(new BlockContainer(new BorderArrangement()));
    }

    public CompositeTitle(BlockContainer container) {
        if (container == null) {
            throw new IllegalArgumentException("Null 'container' argument.");
        }
        this.container = container;
        this.backgroundPaintType = null;
    }

    public PaintType getBackgroundPaintType() {
        return this.backgroundPaintType;
    }

    public void setBackgroundPaintType(PaintType paintType) {
        this.backgroundPaintType = paintType;
        this.notifyListeners(new TitleChangeEvent(this));
    }

    public BlockContainer getContainer() {
        return this.container;
    }

    public void setTitleContainer(BlockContainer container) {
        if (container == null) {
            throw new IllegalArgumentException("Null 'container' argument.");
        }
        this.container = container;
    }

    public Size2D arrange(Canvas canvas, RectangleConstraint constraint) {
        RectangleConstraint contentConstraint = this.toContentConstraint(constraint);
        Size2D contentSize = this.container.arrange(canvas, contentConstraint);
        return new Size2D(this.calculateTotalWidth(contentSize.getWidth()), this.calculateTotalHeight(contentSize.getHeight()));
    }

    public void draw(Canvas canvas, RectShape area) {
        this.draw(canvas, area, null);
    }

    public Object draw(Canvas canvas, RectShape area, Object params) {
        area = this.trimMargin(area);
        this.drawBorder(canvas, area);
        area = this.trimBorder(area);
        if (this.backgroundPaintType != null) {
            Paint paint = PaintUtility.createPaint(1, this.backgroundPaintType);
            area.fill(canvas, paint);
        }
        area = this.trimPadding(area);
        return this.container.draw(canvas, area, params);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof CompositeTitle)) {
            return false;
        }
        CompositeTitle that = (CompositeTitle)obj;
        if (!this.container.equals(that.container)) {
            return false;
        }
        if (!this.backgroundPaintType.equals(that.backgroundPaintType)) {
            return false;
        }
        return super.equals(obj);
    }

    private void writeObject(ObjectOutputStream stream) throws IOException {
        stream.defaultWriteObject();
        SerialUtilities.writePaintType(this.backgroundPaintType, stream);
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        stream.defaultReadObject();
        this.backgroundPaintType = SerialUtilities.readPaintType(stream);
    }
}

