/*
 * Decompiled with CFR 0.152.
 */
package org.afree.chart.text;

import android.graphics.Canvas;
import android.graphics.Paint;
import java.io.Serializable;
import org.afree.chart.text.TextBlock;
import org.afree.chart.text.TextBlockAnchor;
import org.afree.graphics.PaintType;
import org.afree.graphics.PaintUtility;
import org.afree.graphics.SolidColor;
import org.afree.graphics.geom.Font;
import org.afree.graphics.geom.RectShape;
import org.afree.ui.RectangleAnchor;
import org.afree.ui.RectangleInsets;
import org.afree.ui.Size2D;
import org.afree.util.ObjectUtilities;

public class TextBox
implements Serializable {
    private static final PaintType BLACK = new SolidColor(-16777216);
    private static final PaintType GRAY = new SolidColor(-7829368);
    private static final PaintType WHITE = new SolidColor(-1);
    private static final long serialVersionUID = 3360220213180203706L;
    private transient PaintType outlinePaintType = BLACK;
    private transient Float outlineStroke = Float.valueOf(1.0f);
    private RectangleInsets interiorGap = new RectangleInsets(1.0, 3.0, 1.0, 3.0);
    private transient PaintType backgroundPaint = WHITE;
    private transient PaintType shadowPaintType = GRAY;
    private double shadowXOffset = 2.0;
    private double shadowYOffset = 2.0;
    private TextBlock textBlock;

    public TextBox() {
        this((TextBlock)null);
    }

    public TextBox(String text) {
        this((TextBlock)null);
        if (text != null) {
            this.textBlock = new TextBlock();
            this.textBlock.addLine(text, new Font("SansSerif", 0, 10), BLACK);
        }
    }

    public TextBox(TextBlock block) {
        this.textBlock = block;
    }

    public PaintType getOutlinePaintType() {
        return this.outlinePaintType;
    }

    public void setOutlinePaintType(PaintType paintType) {
        this.outlinePaintType = paintType;
    }

    public Float getOutlineStroke() {
        return this.outlineStroke;
    }

    public void setOutlineStroke(Float stroke) {
        this.outlineStroke = stroke;
    }

    public RectangleInsets getInteriorGap() {
        return this.interiorGap;
    }

    public void setInteriorGap(RectangleInsets gap) {
        this.interiorGap = gap;
    }

    public PaintType getBackgroundPaintType() {
        return this.backgroundPaint;
    }

    public void setBackgroundPaintType(PaintType paintType) {
        this.backgroundPaint = paintType;
    }

    public PaintType getShadowPaintType() {
        return this.shadowPaintType;
    }

    public void setShadowPaintType(PaintType paintType) {
        this.shadowPaintType = paintType;
    }

    public double getShadowXOffset() {
        return this.shadowXOffset;
    }

    public void setShadowXOffset(double offset) {
        this.shadowXOffset = offset;
    }

    public double getShadowYOffset() {
        return this.shadowYOffset;
    }

    public void setShadowYOffset(double offset) {
        this.shadowYOffset = offset;
    }

    public TextBlock getTextBlock() {
        return this.textBlock;
    }

    public void setTextBlock(TextBlock block) {
        this.textBlock = block;
    }

    public void draw(Canvas canvas, float x, float y, RectangleAnchor anchor) {
        Paint paint;
        Size2D d1 = this.textBlock.calculateDimensions(canvas);
        double w = this.interiorGap.extendWidth(d1.getWidth());
        double h = this.interiorGap.extendHeight(d1.getHeight());
        Size2D d2 = new Size2D(w, h);
        RectShape bounds = RectangleAnchor.createRectShape(d2, x, y, anchor);
        double xx = bounds.getX();
        double yy = bounds.getY();
        if (this.shadowPaintType != null) {
            paint = PaintUtility.createPaint(1, this.shadowPaintType);
            RectShape shadow = new RectShape(xx + this.shadowXOffset, yy + this.shadowYOffset, (double)bounds.getWidth(), (double)bounds.getHeight());
            shadow.fill(canvas, paint);
        }
        if (this.backgroundPaint != null) {
            paint = PaintUtility.createPaint(1, this.backgroundPaint);
            bounds.fill(canvas, paint);
        }
        if (this.outlinePaintType != null && this.outlineStroke != null) {
            paint = PaintUtility.createPaint(this.outlinePaintType);
            bounds.draw(canvas, paint);
        }
        this.textBlock.draw(canvas, (float)(xx + this.interiorGap.calculateLeftInset(w)), (float)(yy + this.interiorGap.calculateTopInset(h)), TextBlockAnchor.TOP_LEFT);
    }

    public double getHeight(Canvas canvas) {
        Size2D d = this.textBlock.calculateDimensions(canvas);
        return this.interiorGap.extendHeight(d.getHeight());
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof TextBox)) {
            return false;
        }
        TextBox that = (TextBox)obj;
        if (!ObjectUtilities.equal(this.outlinePaintType, that.outlinePaintType)) {
            return false;
        }
        if (!ObjectUtilities.equal(this.outlineStroke, that.outlineStroke)) {
            return false;
        }
        if (!ObjectUtilities.equal(this.interiorGap, that.interiorGap)) {
            return false;
        }
        if (!ObjectUtilities.equal(this.backgroundPaint, that.backgroundPaint)) {
            return false;
        }
        if (!ObjectUtilities.equal(this.shadowPaintType, that.shadowPaintType)) {
            return false;
        }
        if (this.shadowXOffset != that.shadowXOffset) {
            return false;
        }
        if (this.shadowYOffset != that.shadowYOffset) {
            return false;
        }
        return ObjectUtilities.equal(this.textBlock, that.textBlock);
    }
}

