/*
 * Decompiled with CFR 0.152.
 */
package org.afree.chart.text;

import android.graphics.Canvas;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.afree.chart.text.TextBlockAnchor;
import org.afree.chart.text.TextLine;
import org.afree.graphics.PaintType;
import org.afree.graphics.geom.Font;
import org.afree.graphics.geom.RectShape;
import org.afree.graphics.geom.Shape;
import org.afree.ui.HorizontalAlignment;
import org.afree.ui.Size2D;
import org.afree.ui.TextAnchor;
import org.afree.util.ShapeUtilities;

public class TextBlock
implements Serializable {
    private static final long serialVersionUID = 4505528023979388425L;
    private List lines = new ArrayList();
    private HorizontalAlignment lineAlignment = HorizontalAlignment.CENTER;

    public HorizontalAlignment getLineAlignment() {
        return this.lineAlignment;
    }

    public void setLineAlignment(HorizontalAlignment alignment) {
        if (alignment == null) {
            throw new IllegalArgumentException("Null 'alignment' argument.");
        }
        this.lineAlignment = alignment;
    }

    public void addLine(String text, Font font, PaintType paintType) {
        this.addLine(new TextLine(text, font, paintType));
    }

    public void addLine(TextLine line) {
        this.lines.add(line);
    }

    public TextLine getLastLine() {
        TextLine last = null;
        int index = this.lines.size() - 1;
        if (index >= 0) {
            last = (TextLine)this.lines.get(index);
        }
        return last;
    }

    public List getLines() {
        return Collections.unmodifiableList(this.lines);
    }

    public Size2D calculateDimensions(Canvas canvas) {
        double width = 0.0;
        double height = 0.0;
        for (TextLine line : this.lines) {
            Size2D dimension = line.calculateDimensions(canvas);
            width = Math.max(width, dimension.getWidth());
            height += dimension.getHeight();
        }
        return new Size2D(width, height);
    }

    public Shape calculateBounds(Canvas canvas, float anchorX, float anchorY, TextBlockAnchor anchor, float rotateX, float rotateY, double angle) {
        Size2D d = this.calculateDimensions(canvas);
        float[] offsets = this.calculateOffsets(anchor, d.getWidth(), d.getHeight());
        RectShape bounds = new RectShape((double)(anchorX + offsets[0]), (double)(anchorY + offsets[1]), d.getWidth(), d.getHeight());
        Shape rotatedBounds = ShapeUtilities.rotateShape(bounds, angle, rotateX, rotateY);
        return rotatedBounds;
    }

    public void draw(Canvas canvas, float x, float y, TextBlockAnchor anchor) {
        this.draw(canvas, x, y, anchor, 0.0f, 0.0f, 0.0);
    }

    public void draw(Canvas canvas, float anchorX, float anchorY, TextBlockAnchor anchor, float rotateX, float rotateY, double angle) {
        Size2D d = this.calculateDimensions(canvas);
        float[] offsets = this.calculateOffsets(anchor, d.getWidth(), d.getHeight());
        Iterator iterator = this.lines.iterator();
        float yCursor = 0.0f;
        while (iterator.hasNext()) {
            TextLine line = (TextLine)iterator.next();
            Size2D dimension = line.calculateDimensions(canvas);
            float lineOffset = 0.0f;
            if (this.lineAlignment == HorizontalAlignment.CENTER) {
                lineOffset = (float)(d.getWidth() - dimension.getWidth()) / 2.0f;
            } else if (this.lineAlignment == HorizontalAlignment.RIGHT) {
                lineOffset = (float)(d.getWidth() - dimension.getWidth());
            }
            line.draw(canvas, anchorX + offsets[0] + lineOffset, anchorY + offsets[1] + yCursor, TextAnchor.TOP_LEFT, rotateX, rotateY, angle);
            yCursor += (float)dimension.getHeight();
        }
    }

    private float[] calculateOffsets(TextBlockAnchor anchor, double width, double height) {
        float[] result = new float[2];
        float xAdj = 0.0f;
        float yAdj = 0.0f;
        if (anchor == TextBlockAnchor.TOP_CENTER || anchor == TextBlockAnchor.CENTER || anchor == TextBlockAnchor.BOTTOM_CENTER) {
            xAdj = (float)(-width) / 2.0f;
        } else if (anchor == TextBlockAnchor.TOP_RIGHT || anchor == TextBlockAnchor.CENTER_RIGHT || anchor == TextBlockAnchor.BOTTOM_RIGHT) {
            xAdj = (float)(-width);
        }
        if (anchor == TextBlockAnchor.TOP_LEFT || anchor == TextBlockAnchor.TOP_CENTER || anchor == TextBlockAnchor.TOP_RIGHT) {
            yAdj = 0.0f;
        } else if (anchor == TextBlockAnchor.CENTER_LEFT || anchor == TextBlockAnchor.CENTER || anchor == TextBlockAnchor.CENTER_RIGHT) {
            yAdj = (float)(-height) / 2.0f;
        } else if (anchor == TextBlockAnchor.BOTTOM_LEFT || anchor == TextBlockAnchor.BOTTOM_CENTER || anchor == TextBlockAnchor.BOTTOM_RIGHT) {
            yAdj = (float)(-height);
        }
        result[0] = xAdj;
        result[1] = yAdj;
        return result;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (obj instanceof TextBlock) {
            TextBlock block = (TextBlock)obj;
            return this.lines.equals(block.lines);
        }
        return false;
    }
}

