/*
 * Decompiled with CFR 0.152.
 */
package org.afree.chart.renderer.xy;

import android.graphics.Canvas;
import android.graphics.Paint;
import java.io.Serializable;
import org.afree.chart.LegendItem;
import org.afree.chart.axis.ValueAxis;
import org.afree.chart.plot.CrosshairState;
import org.afree.chart.plot.PlotOrientation;
import org.afree.chart.plot.PlotRenderingInfo;
import org.afree.chart.plot.XYPlot;
import org.afree.chart.renderer.xy.AbstractXYItemRenderer;
import org.afree.chart.renderer.xy.XYItemRenderer;
import org.afree.chart.renderer.xy.XYItemRendererState;
import org.afree.data.xy.XYDataset;
import org.afree.graphics.PaintType;
import org.afree.graphics.PaintUtility;
import org.afree.graphics.geom.LineShape;
import org.afree.graphics.geom.PathShape;
import org.afree.graphics.geom.RectShape;
import org.afree.graphics.geom.Shape;
import org.afree.ui.RectangleEdge;
import org.afree.util.PublicCloneable;
import org.afree.util.ShapeUtilities;

public class SamplingXYLineRenderer
extends AbstractXYItemRenderer
implements XYItemRenderer,
Cloneable,
PublicCloneable,
Serializable {
    private static final long serialVersionUID = 2915890808842041512L;
    private transient Shape legendLine = new LineShape(-7.0, 0.0, 7.0, 0.0);

    public Shape getLegendLine() {
        return this.legendLine;
    }

    public void setLegendLine(Shape line) {
        if (line == null) {
            throw new IllegalArgumentException("Null 'line' argument.");
        }
        this.legendLine = line;
        this.fireChangeEvent();
    }

    public int getPassCount() {
        return 1;
    }

    public XYItemRendererState initialise(Canvas canvas, RectShape dataArea, XYPlot plot, XYDataset data, PlotRenderingInfo info) {
        double dpi = 72.0;
        State state = new State(info);
        state.seriesPath = new PathShape();
        state.intervalPath = new PathShape();
        state.dX = 72.0 / dpi;
        return state;
    }

    public void drawItem(Canvas canvas, XYItemRendererState state, RectShape dataArea, PlotRenderingInfo info, XYPlot plot, ValueAxis domainAxis, ValueAxis rangeAxis, XYDataset dataset, int series, int item, CrosshairState crosshairState, int pass) {
        if (!this.getItemVisible(series, item)) {
            return;
        }
        RectangleEdge xAxisLocation = plot.getDomainAxisEdge();
        RectangleEdge yAxisLocation = plot.getRangeAxisEdge();
        double x1 = dataset.getXValue(series, item);
        double y1 = dataset.getYValue(series, item);
        double transX1 = domainAxis.valueToJava2D(x1, dataArea, xAxisLocation);
        double transY1 = rangeAxis.valueToJava2D(y1, dataArea, yAxisLocation);
        State s = (State)state;
        if (!Double.isNaN(transX1) && !Double.isNaN(transY1)) {
            float x = (float)transX1;
            float y = (float)transY1;
            PlotOrientation orientation = plot.getOrientation();
            if (orientation == PlotOrientation.HORIZONTAL) {
                x = (float)transY1;
                y = (float)transX1;
            }
            if (s.lastPointGood) {
                if (Math.abs((double)x - s.lastX) > s.dX) {
                    s.seriesPath.lineTo(x, y);
                    if (s.lowY < s.highY) {
                        s.intervalPath.moveTo((float)s.lastX, (float)s.lowY);
                        s.intervalPath.lineTo((float)s.lastX, (float)s.highY);
                    }
                    s.lastX = x;
                    s.openY = y;
                    s.highY = y;
                    s.lowY = y;
                    s.closeY = y;
                } else {
                    s.highY = Math.max(s.highY, (double)y);
                    s.lowY = Math.min(s.lowY, (double)y);
                    s.closeY = y;
                }
            } else {
                s.seriesPath.moveTo(x, y);
                s.lastX = x;
                s.openY = y;
                s.highY = y;
                s.lowY = y;
                s.closeY = y;
            }
            s.lastPointGood = true;
        } else {
            s.lastPointGood = false;
        }
        if (item == s.getLastItemIndex()) {
            Paint paint = PaintUtility.createPaint(1, this.getItemPaintType(series, item), this.getItemStroke(series, item).floatValue(), this.getItemEffect(series, item));
            s.seriesPath.draw(canvas, paint);
            s.intervalPath.draw(canvas, paint);
        }
    }

    public LegendItem getLegendItem(int datasetIndex, int series) {
        XYPlot plot = this.getPlot();
        if (plot == null) {
            return null;
        }
        LegendItem result = null;
        XYDataset dataset = plot.getDataset(datasetIndex);
        if (dataset != null && this.getItemVisible(series, 0)) {
            String label = this.getLegendItemLabelGenerator().generateLabel(dataset, series);
            result = new LegendItem(label);
            result.setLabelFont(this.lookupLegendTextFont(series));
            PaintType labelPaintType = this.lookupLegendTextPaintType(series);
            if (labelPaintType != null) {
                result.setLabelPaintType(labelPaintType);
            }
            result.setSeriesKey(dataset.getSeriesKey(series));
            result.setSeriesIndex(series);
            result.setDataset(dataset);
            result.setDatasetIndex(datasetIndex);
        }
        return result;
    }

    public Object clone() throws CloneNotSupportedException {
        SamplingXYLineRenderer clone = (SamplingXYLineRenderer)super.clone();
        if (this.legendLine != null) {
            clone.legendLine = ShapeUtilities.clone(this.legendLine);
        }
        return clone;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof SamplingXYLineRenderer)) {
            return false;
        }
        if (!super.equals(obj)) {
            return false;
        }
        SamplingXYLineRenderer that = (SamplingXYLineRenderer)obj;
        return ShapeUtilities.equal(this.legendLine, that.legendLine);
    }

    public static class State
    extends XYItemRendererState {
        PathShape seriesPath;
        PathShape intervalPath;
        double dX = 1.0;
        double lastX;
        double openY = 0.0;
        double highY = 0.0;
        double lowY = 0.0;
        double closeY = 0.0;
        boolean lastPointGood;

        public State(PlotRenderingInfo info) {
            super(info);
        }

        public void startSeriesPass(XYDataset dataset, int series, int firstItem, int lastItem, int pass, int passCount) {
            this.seriesPath.reset();
            this.lastPointGood = false;
            super.startSeriesPass(dataset, series, firstItem, lastItem, pass, passCount);
        }
    }
}

