/*
 * Decompiled with CFR 0.152.
 */
package org.afree.chart.renderer.xy;

import android.graphics.Canvas;
import android.graphics.Paint;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import org.afree.chart.axis.ValueAxis;
import org.afree.chart.entity.EntityCollection;
import org.afree.chart.plot.CrosshairState;
import org.afree.chart.plot.PlotOrientation;
import org.afree.chart.plot.PlotRenderingInfo;
import org.afree.chart.plot.XYPlot;
import org.afree.chart.renderer.xy.AbstractXYItemRenderer;
import org.afree.chart.renderer.xy.XYItemRenderer;
import org.afree.chart.renderer.xy.XYItemRendererState;
import org.afree.data.Range;
import org.afree.data.xy.IntervalXYDataset;
import org.afree.data.xy.OHLCDataset;
import org.afree.data.xy.XYDataset;
import org.afree.graphics.PaintType;
import org.afree.graphics.PaintUtility;
import org.afree.graphics.SolidColor;
import org.afree.graphics.geom.LineShape;
import org.afree.graphics.geom.RectShape;
import org.afree.io.SerialUtilities;
import org.afree.ui.RectangleEdge;

public class CandlestickRenderer
extends AbstractXYItemRenderer
implements XYItemRenderer,
Cloneable,
Serializable {
    private static final long serialVersionUID = 50390395841817121L;
    public static final int WIDTHMETHOD_AVERAGE = 0;
    public static final int WIDTHMETHOD_SMALLEST = 1;
    public static final int WIDTHMETHOD_INTERVALDATA = 2;
    private int autoWidthMethod = 0;
    private double autoWidthFactor = 0.6428571428571429;
    private double autoWidthGap = 0.0;
    private double candleWidth;
    private double maxCandleWidthInMilliseconds = 7.2E7;
    private double maxCandleWidth;
    private transient PaintType upPaintType;
    private transient PaintType downPaintType;
    private boolean drawVolume;
    private transient PaintType volumePaintType;
    private transient double maxVolume;
    private boolean useOutlinePaint;
    private Paint mWorkPaintVolume = new Paint(0);
    private Paint mWorkPaint = new Paint(0);
    private RectShape mWorkRectShape = new RectShape();
    private LineShape mWorkLineShape = new LineShape();

    public CandlestickRenderer() {
        this(-1.0);
    }

    public CandlestickRenderer(double candleWidth) {
        this(candleWidth, true);
    }

    public CandlestickRenderer(double candleWidth, boolean drawVolume) {
        this.candleWidth = candleWidth;
        this.drawVolume = drawVolume;
        this.volumePaintType = new SolidColor(-7829368);
        this.upPaintType = new SolidColor(-16711936);
        this.downPaintType = new SolidColor(-65536);
        this.useOutlinePaint = false;
    }

    public double getCandleWidth() {
        return this.candleWidth;
    }

    public void setCandleWidth(double width) {
        if (width != this.candleWidth) {
            this.candleWidth = width;
            this.fireChangeEvent();
        }
    }

    public double getMaxCandleWidthInMilliseconds() {
        return this.maxCandleWidthInMilliseconds;
    }

    public void setMaxCandleWidthInMilliseconds(double millis) {
        this.maxCandleWidthInMilliseconds = millis;
        this.fireChangeEvent();
    }

    public int getAutoWidthMethod() {
        return this.autoWidthMethod;
    }

    public void setAutoWidthMethod(int autoWidthMethod) {
        if (this.autoWidthMethod != autoWidthMethod) {
            this.autoWidthMethod = autoWidthMethod;
            this.fireChangeEvent();
        }
    }

    public double getAutoWidthFactor() {
        return this.autoWidthFactor;
    }

    public void setAutoWidthFactor(double autoWidthFactor) {
        if (this.autoWidthFactor != autoWidthFactor) {
            this.autoWidthFactor = autoWidthFactor;
            this.fireChangeEvent();
        }
    }

    public double getAutoWidthGap() {
        return this.autoWidthGap;
    }

    public void setAutoWidthGap(double autoWidthGap) {
        if (this.autoWidthGap != autoWidthGap) {
            this.autoWidthGap = autoWidthGap;
            this.fireChangeEvent();
        }
    }

    public PaintType getUpPaintType() {
        return this.upPaintType;
    }

    public void setUpPaintType(PaintType paintType) {
        this.upPaintType = paintType;
        this.fireChangeEvent();
    }

    public PaintType getDownPaintType() {
        return this.downPaintType;
    }

    public void setDownPaintType(PaintType paintType) {
        this.downPaintType = paintType;
        this.fireChangeEvent();
    }

    public boolean getDrawVolume() {
        return this.drawVolume;
    }

    public void setDrawVolume(boolean flag) {
        if (this.drawVolume != flag) {
            this.drawVolume = flag;
            this.fireChangeEvent();
        }
    }

    public PaintType getVolumePaintType() {
        return this.volumePaintType;
    }

    public void setVolumePaintType(PaintType paintType) {
        if (paintType == null) {
            throw new IllegalArgumentException("Null 'paint' argument.");
        }
        this.volumePaintType = paintType;
        this.fireChangeEvent();
    }

    public boolean getUseOutlinePaint() {
        return this.useOutlinePaint;
    }

    public void setUseOutlinePaint(boolean use) {
        if (this.useOutlinePaint != use) {
            this.useOutlinePaint = use;
            this.fireChangeEvent();
        }
    }

    public Range findRangeBounds(XYDataset dataset) {
        return this.findRangeBounds(dataset, true);
    }

    public XYItemRendererState initialise(Canvas canvas, RectShape dataArea, XYPlot plot, XYDataset dataset, PlotRenderingInfo info) {
        ValueAxis axis = plot.getDomainAxis();
        double x1 = axis.getLowerBound();
        double x2 = x1 + this.maxCandleWidthInMilliseconds;
        RectangleEdge edge = plot.getDomainAxisEdge();
        double xx1 = axis.valueToJava2D(x1, dataArea, edge);
        double xx2 = axis.valueToJava2D(x2, dataArea, edge);
        this.maxCandleWidth = Math.abs(xx2 - xx1);
        if (this.drawVolume) {
            OHLCDataset highLowDataset = (OHLCDataset)dataset;
            this.maxVolume = 0.0;
            int series = 0;
            while (series < highLowDataset.getSeriesCount()) {
                int item = 0;
                while (item < highLowDataset.getItemCount(series)) {
                    double volume = highLowDataset.getVolumeValue(series, item);
                    if (volume > this.maxVolume) {
                        this.maxVolume = volume;
                    }
                    ++item;
                }
                ++series;
            }
        }
        return new XYItemRendererState(info);
    }

    public void drawItem(Canvas canvas, XYItemRendererState state, RectShape dataArea, PlotRenderingInfo info, XYPlot plot, ValueAxis domainAxis, ValueAxis rangeAxis, XYDataset dataset, int series, int item, CrosshairState crosshairState, int pass) {
        double stickWidth;
        double volumeWidth;
        boolean horiz;
        PlotOrientation orientation = plot.getOrientation();
        if (orientation == PlotOrientation.HORIZONTAL) {
            horiz = true;
        } else if (orientation == PlotOrientation.VERTICAL) {
            horiz = false;
        } else {
            return;
        }
        EntityCollection entities = null;
        if (info != null) {
            entities = info.getOwner().getEntityCollection();
        }
        OHLCDataset highLowData = (OHLCDataset)dataset;
        double x = highLowData.getXValue(series, item);
        double yHigh = highLowData.getHighValue(series, item);
        double yLow = highLowData.getLowValue(series, item);
        double yOpen = highLowData.getOpenValue(series, item);
        double yClose = highLowData.getCloseValue(series, item);
        RectangleEdge domainEdge = plot.getDomainAxisEdge();
        double xx = domainAxis.valueToJava2D(x, dataArea, domainEdge);
        RectangleEdge edge = plot.getRangeAxisEdge();
        double yyHigh = rangeAxis.valueToJava2D(yHigh, dataArea, edge);
        double yyLow = rangeAxis.valueToJava2D(yLow, dataArea, edge);
        double yyOpen = rangeAxis.valueToJava2D(yOpen, dataArea, edge);
        double yyClose = rangeAxis.valueToJava2D(yClose, dataArea, edge);
        if (this.candleWidth > 0.0) {
            volumeWidth = this.candleWidth;
            stickWidth = this.candleWidth;
        } else {
            double xxWidth = 0.0;
            switch (this.autoWidthMethod) {
                case 0: {
                    int itemCount = highLowData.getItemCount(series);
                    if (horiz) {
                        xxWidth = dataArea.getHeight() / (float)itemCount;
                        break;
                    }
                    xxWidth = dataArea.getWidth() / (float)itemCount;
                    break;
                }
                case 1: {
                    int itemCount = highLowData.getItemCount(series);
                    double lastPos = -1.0;
                    xxWidth = dataArea.getWidth();
                    int i = 0;
                    while (i < itemCount) {
                        double pos = domainAxis.valueToJava2D(highLowData.getXValue(series, i), dataArea, domainEdge);
                        if (lastPos != -1.0) {
                            xxWidth = Math.min(xxWidth, Math.abs(pos - lastPos));
                        }
                        lastPos = pos;
                        ++i;
                    }
                    break;
                }
                case 2: {
                    IntervalXYDataset intervalXYData = (IntervalXYDataset)dataset;
                    double startPos = domainAxis.valueToJava2D(intervalXYData.getStartXValue(series, item), dataArea, plot.getDomainAxisEdge());
                    double endPos = domainAxis.valueToJava2D(intervalXYData.getEndXValue(series, item), dataArea, plot.getDomainAxisEdge());
                    xxWidth = Math.abs(endPos - startPos);
                }
            }
            xxWidth -= 2.0 * this.autoWidthGap;
            xxWidth *= this.autoWidthFactor;
            xxWidth = Math.min(xxWidth, this.maxCandleWidth);
            volumeWidth = Math.max(Math.min(1.0, this.maxCandleWidth), xxWidth);
            stickWidth = Math.max(Math.min(3.0, this.maxCandleWidth), xxWidth);
        }
        PaintType itemPaintType = this.getItemPaintType(series, item);
        PaintType outlinePaintType = null;
        if (this.useOutlinePaint) {
            outlinePaintType = this.getItemOutlinePaintType(series, item);
        }
        if (this.drawVolume) {
            double max;
            double min;
            int volume = (int)highLowData.getVolumeValue(series, item);
            double volumeHeight = (double)volume / this.maxVolume;
            if (horiz) {
                min = dataArea.getMinX();
                max = dataArea.getMaxX();
            } else {
                min = dataArea.getMinY();
                max = dataArea.getMaxY();
            }
            double zzVolume = volumeHeight * (max - min);
            Paint paint = this.mWorkPaintVolume;
            PaintUtility.updatePaint(paint, this.getVolumePaintType());
            paint.setAlpha((int)((float)paint.getAlpha() * 0.3f));
            paint.setStrokeWidth(this.getItemStroke(series, item).floatValue());
            paint.setPathEffect(this.getItemEffect(series, item));
            if (horiz) {
                this.mWorkRectShape.setRect(min, xx - volumeWidth * 0.5, zzVolume, volumeWidth);
            } else {
                this.mWorkRectShape.setRect(xx - volumeWidth * 0.5, max - zzVolume, volumeWidth, zzVolume);
            }
            this.mWorkRectShape.fill(canvas, paint);
        }
        Paint paint = this.mWorkPaint;
        if (this.useOutlinePaint) {
            PaintUtility.updatePaint(paint, outlinePaintType);
        } else {
            PaintUtility.updatePaint(paint, itemPaintType);
        }
        double yyMaxOpenClose = Math.max(yyOpen, yyClose);
        double yyMinOpenClose = Math.min(yyOpen, yyClose);
        double maxOpenClose = Math.max(yOpen, yClose);
        double minOpenClose = Math.min(yOpen, yClose);
        if (yHigh > maxOpenClose) {
            if (horiz) {
                this.mWorkLineShape.setLine(yyHigh, xx, yyMaxOpenClose, xx);
            } else {
                this.mWorkLineShape.setLine(xx, yyHigh, xx, yyMaxOpenClose);
            }
            this.mWorkLineShape.draw(canvas, paint);
        }
        if (yLow < minOpenClose) {
            if (horiz) {
                this.mWorkLineShape.setLine(yyLow, xx, yyMinOpenClose, xx);
            } else {
                this.mWorkLineShape.setLine(xx, yyLow, xx, yyMinOpenClose);
            }
            this.mWorkLineShape.draw(canvas, paint);
        }
        RectShape body = this.mWorkRectShape;
        RectShape hotspot = null;
        double length = Math.abs(yyHigh - yyLow);
        double base = Math.min(yyHigh, yyLow);
        if (horiz) {
            body.setRect(yyMinOpenClose, xx - stickWidth * 0.5, yyMaxOpenClose - yyMinOpenClose, stickWidth);
            hotspot = new RectShape(base, xx - stickWidth * 0.5, length, stickWidth);
        } else {
            body.setRect(xx - stickWidth * 0.5, yyMinOpenClose, stickWidth, yyMaxOpenClose - yyMinOpenClose);
            hotspot = new RectShape(xx - stickWidth * 0.5, base, stickWidth, length);
        }
        if (yClose > yOpen) {
            if (this.upPaintType != null) {
                PaintUtility.updatePaint(paint, this.upPaintType);
            } else {
                PaintUtility.updatePaint(paint, itemPaintType);
            }
            body.fill(canvas, paint);
        } else {
            if (this.downPaintType != null) {
                PaintUtility.updatePaint(paint, this.downPaintType);
            } else {
                PaintUtility.updatePaint(paint, itemPaintType);
            }
            body.fill(canvas, paint);
        }
        if (this.useOutlinePaint) {
            PaintUtility.updatePaint(paint, outlinePaintType);
        } else {
            PaintUtility.updatePaint(paint, itemPaintType);
        }
        body.draw(canvas, paint);
        if (entities != null) {
            this.addEntity(entities, hotspot, dataset, series, item, 0.0, 0.0);
        }
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof CandlestickRenderer)) {
            return false;
        }
        CandlestickRenderer that = (CandlestickRenderer)obj;
        if (this.candleWidth != that.candleWidth) {
            return false;
        }
        if (this.drawVolume != that.drawVolume) {
            return false;
        }
        if (this.maxCandleWidthInMilliseconds != that.maxCandleWidthInMilliseconds) {
            return false;
        }
        if (this.autoWidthMethod != that.autoWidthMethod) {
            return false;
        }
        if (this.autoWidthFactor != that.autoWidthFactor) {
            return false;
        }
        if (this.autoWidthGap != that.autoWidthGap) {
            return false;
        }
        if (this.useOutlinePaint != that.useOutlinePaint) {
            return false;
        }
        return super.equals(obj);
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    private void writeObject(ObjectOutputStream stream) throws IOException {
        stream.defaultWriteObject();
        SerialUtilities.writePaintType(this.upPaintType, stream);
        SerialUtilities.writePaintType(this.downPaintType, stream);
        SerialUtilities.writePaintType(this.volumePaintType, stream);
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        stream.defaultReadObject();
        this.upPaintType = SerialUtilities.readPaintType(stream);
        this.downPaintType = SerialUtilities.readPaintType(stream);
        this.volumePaintType = SerialUtilities.readPaintType(stream);
    }
}

