/*
 * Decompiled with CFR 0.152.
 */
package org.afree.chart.renderer;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.afree.chart.renderer.PaintScale;
import org.afree.graphics.PaintType;
import org.afree.graphics.SolidColor;
import org.afree.io.SerialUtilities;
import org.afree.util.PaintTypeUtilities;
import org.afree.util.PublicCloneable;

public class LookupPaintScale
implements PaintScale,
PublicCloneable,
Serializable {
    static final long serialVersionUID = -5239384246251042006L;
    private double lowerBound;
    private double upperBound;
    private transient PaintType defaultPaintType;
    private List lookupTable;
    private static PaintType paintLightGray = new SolidColor(-3355444);

    public LookupPaintScale() {
        this(0.0, 1.0, paintLightGray);
    }

    public LookupPaintScale(double lowerBound, double upperBound, PaintType defaultPaintType) {
        if (lowerBound >= upperBound) {
            throw new IllegalArgumentException("Requires lowerBound < upperBound.");
        }
        if (defaultPaintType == null) {
            throw new IllegalArgumentException("Null 'paint' argument.");
        }
        this.lowerBound = lowerBound;
        this.upperBound = upperBound;
        this.defaultPaintType = defaultPaintType;
        this.lookupTable = new ArrayList();
    }

    public PaintType getDefaultPaintType() {
        return this.defaultPaintType;
    }

    public double getLowerBound() {
        return this.lowerBound;
    }

    public double getUpperBound() {
        return this.upperBound;
    }

    public void add(double value, PaintType paintType) {
        PaintItem item = new PaintItem(value, paintType);
        int index = Collections.binarySearch(this.lookupTable, item);
        if (index >= 0) {
            this.lookupTable.set(index, item);
        } else {
            this.lookupTable.add(-(index + 1), item);
        }
    }

    public PaintType getPaintType(double value) {
        if (value < this.lowerBound) {
            return this.defaultPaintType;
        }
        if (value > this.upperBound) {
            return this.defaultPaintType;
        }
        int count = this.lookupTable.size();
        if (count == 0) {
            return this.defaultPaintType;
        }
        PaintItem item = (PaintItem)this.lookupTable.get(0);
        if (value < item.value) {
            return this.defaultPaintType;
        }
        int low = 0;
        int high = this.lookupTable.size() - 1;
        while (high - low > 1) {
            int current = (low + high) / 2;
            item = (PaintItem)this.lookupTable.get(current);
            if (value >= item.value) {
                low = current;
                continue;
            }
            high = current;
        }
        if (high > low) {
            item = (PaintItem)this.lookupTable.get(high);
            if (value < item.value) {
                item = (PaintItem)this.lookupTable.get(low);
            }
        }
        return item != null ? item.paintType : this.defaultPaintType;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof LookupPaintScale)) {
            return false;
        }
        LookupPaintScale that = (LookupPaintScale)obj;
        if (this.lowerBound != that.lowerBound) {
            return false;
        }
        if (this.upperBound != that.upperBound) {
            return false;
        }
        if (!PaintTypeUtilities.equal(this.defaultPaintType, that.defaultPaintType)) {
            return false;
        }
        return this.lookupTable.equals(that.lookupTable);
    }

    public Object clone() throws CloneNotSupportedException {
        LookupPaintScale clone = (LookupPaintScale)super.clone();
        clone.lookupTable = new ArrayList(this.lookupTable);
        return clone;
    }

    private void writeObject(ObjectOutputStream stream) throws IOException {
        stream.defaultWriteObject();
        SerialUtilities.writePaintType(this.defaultPaintType, stream);
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        stream.defaultReadObject();
        this.defaultPaintType = SerialUtilities.readPaintType(stream);
    }

    static class PaintItem
    implements Comparable,
    Serializable {
        static final long serialVersionUID = 698920578512361570L;
        double value;
        transient PaintType paintType;

        public PaintItem(double value, PaintType paintType) {
            this.value = value;
            this.paintType = paintType;
        }

        public int compareTo(Object obj) {
            PaintItem that = (PaintItem)obj;
            double d1 = this.value;
            double d2 = that.value;
            if (d1 > d2) {
                return 1;
            }
            if (d1 < d2) {
                return -1;
            }
            return 0;
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (!(obj instanceof PaintItem)) {
                return false;
            }
            PaintItem that = (PaintItem)obj;
            if (this.value != that.value) {
                return false;
            }
            return PaintTypeUtilities.equal(this.paintType, that.paintType);
        }

        private void writeObject(ObjectOutputStream stream) throws IOException {
            stream.defaultWriteObject();
            SerialUtilities.writePaintType(this.paintType, stream);
        }

        private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
            stream.defaultReadObject();
            this.paintType = SerialUtilities.readPaintType(stream);
        }
    }
}

