/*
 * Decompiled with CFR 0.152.
 */
package org.afree.chart.plot;

import java.io.Serializable;
import org.afree.chart.event.MarkerChangeEvent;
import org.afree.chart.plot.Marker;
import org.afree.ui.GradientShaderFactory;
import org.afree.ui.LengthAdjustmentType;

public class IntervalMarker
extends Marker
implements Cloneable,
Serializable {
    private static final long serialVersionUID = -1762344775267627916L;
    private double startValue;
    private double endValue;
    private GradientShaderFactory gradientShaderFactory;

    public IntervalMarker(double start, double end) {
        this(start, end, -7829368, 0.5f, -7829368, 0.5f, 200);
    }

    public IntervalMarker(double start, double end, int paint) {
        this(start, end, paint, 0.5f, paint, 0.5f, 200);
    }

    public IntervalMarker(double start, double end, int paint, float stroke, int outlinePaint, float outlineStroke, int alpha) {
        super(paint, stroke, outlinePaint, outlineStroke, alpha);
        this.startValue = start;
        this.endValue = end;
        this.gradientShaderFactory = null;
        this.setLabelOffsetType(LengthAdjustmentType.CONTRACT);
    }

    public double getStartValue() {
        return this.startValue;
    }

    public void setStartValue(double value) {
        this.startValue = value;
        this.notifyListeners(new MarkerChangeEvent(this));
    }

    public double getEndValue() {
        return this.endValue;
    }

    public void setEndValue(double value) {
        this.endValue = value;
        this.notifyListeners(new MarkerChangeEvent(this));
    }

    public GradientShaderFactory getGradientShaderFactory() {
        return this.gradientShaderFactory;
    }

    public void setGradientPaintTransformer(GradientShaderFactory gradientShaderFactory) {
        this.gradientShaderFactory = gradientShaderFactory;
        this.notifyListeners(new MarkerChangeEvent(this));
    }
}

