/*
 * Decompiled with CFR 0.152.
 */
package org.afree.chart.plot;

import android.graphics.Canvas;
import android.graphics.PointF;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.afree.chart.LegendItemCollection;
import org.afree.chart.axis.AxisSpace;
import org.afree.chart.axis.AxisState;
import org.afree.chart.axis.NumberAxis;
import org.afree.chart.axis.ValueAxis;
import org.afree.chart.event.PlotChangeEvent;
import org.afree.chart.event.PlotChangeListener;
import org.afree.chart.plot.Movable;
import org.afree.chart.plot.Plot;
import org.afree.chart.plot.PlotOrientation;
import org.afree.chart.plot.PlotRenderingInfo;
import org.afree.chart.plot.PlotState;
import org.afree.chart.plot.XYPlot;
import org.afree.chart.renderer.xy.XYItemRenderer;
import org.afree.data.Range;
import org.afree.graphics.geom.RectShape;
import org.afree.ui.RectangleEdge;
import org.afree.ui.RectangleInsets;

public class CombinedRangeXYPlot
extends XYPlot
implements PlotChangeListener {
    private static final long serialVersionUID = -5177814085082031168L;
    private List subplots = new ArrayList();
    private double gap = 5.0;
    private transient RectShape[] subplotAreas;

    public CombinedRangeXYPlot() {
        this(new NumberAxis());
    }

    public CombinedRangeXYPlot(ValueAxis rangeAxis) {
        super(null, null, rangeAxis, null);
    }

    public double getGap() {
        return this.gap;
    }

    public void setGap(double gap) {
        this.gap = gap;
    }

    public void add(XYPlot subplot) {
        this.add(subplot, 1);
    }

    public void add(XYPlot subplot, int weight) {
        if (weight <= 0) {
            String msg = "The 'weight' must be positive.";
            throw new IllegalArgumentException(msg);
        }
        subplot.setParent(this);
        subplot.setWeight(weight);
        subplot.setInsets(new RectangleInsets(0.0, 0.0, 0.0, 0.0));
        subplot.setRangeAxis(null);
        subplot.addChangeListener(this);
        this.subplots.add(subplot);
        this.configureRangeAxes();
        this.fireChangeEvent();
    }

    public void remove(XYPlot subplot) {
        if (subplot == null) {
            throw new IllegalArgumentException(" Null 'subplot' argument.");
        }
        int position = -1;
        int size = this.subplots.size();
        int i = 0;
        while (position == -1 && i < size) {
            if (this.subplots.get(i) == subplot) {
                position = i;
            }
            ++i;
        }
        if (position != -1) {
            this.subplots.remove(position);
            subplot.setParent(null);
            subplot.removeChangeListener(this);
            this.configureRangeAxes();
            this.fireChangeEvent();
        }
    }

    public List getSubplots() {
        if (this.subplots != null) {
            return Collections.unmodifiableList(this.subplots);
        }
        return Collections.EMPTY_LIST;
    }

    protected AxisSpace calculateAxisSpace(Canvas canvas, RectShape plotArea) {
        AxisSpace space = new AxisSpace();
        PlotOrientation orientation = this.getOrientation();
        AxisSpace fixed = this.getFixedRangeAxisSpace();
        if (fixed != null) {
            if (orientation == PlotOrientation.VERTICAL) {
                space.setLeft(fixed.getLeft());
                space.setRight(fixed.getRight());
            } else if (orientation == PlotOrientation.HORIZONTAL) {
                space.setTop(fixed.getTop());
                space.setBottom(fixed.getBottom());
            }
        } else {
            ValueAxis valueAxis = this.getRangeAxis();
            RectangleEdge valueEdge = Plot.resolveRangeAxisLocation(this.getRangeAxisLocation(), orientation);
            if (valueAxis != null) {
                space = valueAxis.reserveSpace(canvas, this, plotArea, valueEdge, space);
            }
        }
        RectShape adjustedPlotArea = space.shrink(plotArea, null);
        int n = this.subplots.size();
        int totalWeight = 0;
        int i = 0;
        while (i < n) {
            XYPlot sub = (XYPlot)this.subplots.get(i);
            totalWeight += sub.getWeight();
            ++i;
        }
        this.subplotAreas = new RectShape[n];
        double x = adjustedPlotArea.getX();
        double y = adjustedPlotArea.getY();
        double usableSize = 0.0;
        if (orientation == PlotOrientation.VERTICAL) {
            usableSize = (double)adjustedPlotArea.getWidth() - this.gap * (double)(n - 1);
        } else if (orientation == PlotOrientation.HORIZONTAL) {
            usableSize = (double)adjustedPlotArea.getHeight() - this.gap * (double)(n - 1);
        }
        int i2 = 0;
        while (i2 < n) {
            XYPlot plot = (XYPlot)this.subplots.get(i2);
            if (orientation == PlotOrientation.VERTICAL) {
                double w = usableSize * (double)plot.getWeight() / (double)totalWeight;
                this.subplotAreas[i2] = new RectShape(x, y, w, (double)adjustedPlotArea.getHeight());
                x = x + w + this.gap;
            } else if (orientation == PlotOrientation.HORIZONTAL) {
                double h = usableSize * (double)plot.getWeight() / (double)totalWeight;
                this.subplotAreas[i2] = new RectShape(x, y, (double)adjustedPlotArea.getWidth(), h);
                y = y + h + this.gap;
            }
            AxisSpace subSpace = plot.calculateDomainAxisSpace(canvas, this.subplotAreas[i2], null);
            space.ensureAtLeast(subSpace);
            ++i2;
        }
        return space;
    }

    public void draw(Canvas canvas, RectShape area, PointF anchor, PlotState parentState, PlotRenderingInfo info) {
        if (info != null) {
            info.setPlotArea(area);
        }
        RectangleInsets insets = this.getInsets();
        insets.trim(area);
        AxisSpace space = this.calculateAxisSpace(canvas, area);
        RectShape dataArea = space.shrink(area, null);
        this.setFixedDomainAxisSpaceForSubplots(space);
        ValueAxis axis = this.getRangeAxis();
        RectangleEdge edge = this.getRangeAxisEdge();
        double cursor = RectangleEdge.coordinate(dataArea, edge);
        AxisState axisState = axis.draw(canvas, cursor, area, dataArea, edge, info);
        if (parentState == null) {
            parentState = new PlotState();
        }
        parentState.getSharedAxisStates().put(axis, axisState);
        int i = 0;
        while (i < this.subplots.size()) {
            XYPlot plot = (XYPlot)this.subplots.get(i);
            PlotRenderingInfo subplotInfo = null;
            if (info != null) {
                subplotInfo = new PlotRenderingInfo(info.getOwner());
                info.addSubplotInfo(subplotInfo);
            }
            plot.draw(canvas, this.subplotAreas[i], anchor, parentState, subplotInfo);
            ++i;
        }
        if (info != null) {
            info.setDataArea(dataArea);
        }
    }

    public LegendItemCollection getLegendItems() {
        LegendItemCollection result = this.getFixedLegendItems();
        if (result == null) {
            result = new LegendItemCollection();
            if (this.subplots != null) {
                for (XYPlot plot : this.subplots) {
                    LegendItemCollection more = plot.getLegendItems();
                    result.addAll(more);
                }
            }
        }
        return result;
    }

    public void zoomDomainAxes(double factor, PlotRenderingInfo info, PointF source) {
        this.zoomDomainAxes(factor, info, source, false);
    }

    public void zoomDomainAxes(double factor, PlotRenderingInfo info, PointF source, boolean useAnchor) {
        XYPlot subplot2 = this.findSubplot(info, source);
        if (subplot2 != null) {
            subplot2.zoomDomainAxes(factor, info, source, useAnchor);
        } else {
            for (XYPlot subplot2 : this.getSubplots()) {
                subplot2.zoomDomainAxes(factor, info, source, useAnchor);
            }
        }
    }

    public void zoomDomainAxes(double lowerPercent, double upperPercent, PlotRenderingInfo info, PointF source) {
        XYPlot subplot2 = this.findSubplot(info, source);
        if (subplot2 != null) {
            subplot2.zoomDomainAxes(lowerPercent, upperPercent, info, source);
        } else {
            for (XYPlot subplot2 : this.getSubplots()) {
                subplot2.zoomDomainAxes(lowerPercent, upperPercent, info, source);
            }
        }
    }

    public XYPlot findSubplot(PlotRenderingInfo info, PointF source) {
        if (info == null) {
            throw new IllegalArgumentException("Null 'info' argument.");
        }
        if (source == null) {
            throw new IllegalArgumentException("Null 'source' argument.");
        }
        XYPlot result = null;
        int subplotIndex = info.getSubplotIndex(source);
        if (subplotIndex >= 0) {
            result = (XYPlot)this.subplots.get(subplotIndex);
        }
        return result;
    }

    public void setRenderer(XYItemRenderer renderer) {
        super.setRenderer(renderer);
        for (XYPlot plot : this.subplots) {
            plot.setRenderer(renderer);
        }
    }

    public void setOrientation(PlotOrientation orientation) {
        super.setOrientation(orientation);
        for (XYPlot plot : this.subplots) {
            plot.setOrientation(orientation);
        }
    }

    public Range getDataRange(ValueAxis axis) {
        Range result = null;
        if (this.subplots != null) {
            for (XYPlot subplot : this.subplots) {
                result = Range.combine(result, subplot.getDataRange(axis));
            }
        }
        return result;
    }

    protected void setFixedDomainAxisSpaceForSubplots(AxisSpace space) {
        for (XYPlot plot : this.subplots) {
            plot.setFixedDomainAxisSpace(space, false);
        }
    }

    public void handleClick(int x, int y, PlotRenderingInfo info) {
        RectShape dataArea = info.getDataArea();
        if (dataArea.contains(x, y)) {
            int i = 0;
            while (i < this.subplots.size()) {
                XYPlot subplot = (XYPlot)this.subplots.get(i);
                PlotRenderingInfo subplotInfo = info.getSubplotInfo(i);
                subplot.handleClick(x, y, subplotInfo);
                ++i;
            }
        }
    }

    public void moveDomainAxes(double movePercent, PlotRenderingInfo info, PointF source) {
        XYPlot p = this.findSubplot(info, source);
        if (p instanceof Movable) {
            int i = 0;
            while (i < p.getDomainAxisCount()) {
                ValueAxis domainAxis = p.getDomainAxis(i);
                if (domainAxis != null) {
                    domainAxis.moveRange(movePercent);
                }
                ++i;
            }
        }
    }

    public void moveRangeAxes(double movePercent, PlotRenderingInfo info, PointF source) {
        XYPlot p = this.findSubplot(info, source);
        if (p instanceof Movable) {
            int i = 0;
            while (i < p.getRangeAxisCount()) {
                ValueAxis rangeAxis = p.getRangeAxis(i);
                if (rangeAxis != null) {
                    rangeAxis.moveRange(movePercent);
                }
                ++i;
            }
        }
    }

    public void plotChanged(PlotChangeEvent event) {
        this.notifyListeners(event);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof CombinedRangeXYPlot)) {
            return false;
        }
        CombinedRangeXYPlot that = (CombinedRangeXYPlot)obj;
        if (this.gap != that.gap) {
            return false;
        }
        return super.equals(obj);
    }
}

