/*
 * Decompiled with CFR 0.152.
 */
package org.afree.chart.plot;

import android.graphics.Canvas;
import android.graphics.PointF;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.afree.chart.LegendItemCollection;
import org.afree.chart.axis.AxisSpace;
import org.afree.chart.axis.AxisState;
import org.afree.chart.axis.CategoryAxis;
import org.afree.chart.axis.ValueAxis;
import org.afree.chart.event.PlotChangeEvent;
import org.afree.chart.event.PlotChangeListener;
import org.afree.chart.plot.CategoryPlot;
import org.afree.chart.plot.Movable;
import org.afree.chart.plot.Plot;
import org.afree.chart.plot.PlotOrientation;
import org.afree.chart.plot.PlotRenderingInfo;
import org.afree.chart.plot.PlotState;
import org.afree.data.Range;
import org.afree.graphics.geom.RectShape;
import org.afree.ui.RectangleEdge;
import org.afree.ui.RectangleInsets;

public class CombinedDomainCategoryPlot
extends CategoryPlot
implements PlotChangeListener {
    private static final long serialVersionUID = 8207194522653701572L;
    private List subplots = new ArrayList();
    private double gap = 5.0;
    private transient RectShape[] subplotAreas;

    public CombinedDomainCategoryPlot() {
        this(new CategoryAxis());
    }

    public CombinedDomainCategoryPlot(CategoryAxis domainAxis) {
        super(null, domainAxis, null, null);
    }

    public double getGap() {
        return this.gap;
    }

    public void setGap(double gap) {
        this.gap = gap;
        this.fireChangeEvent();
    }

    public void add(CategoryPlot subplot) {
        this.add(subplot, 1);
    }

    public void add(CategoryPlot subplot, int weight) {
        if (subplot == null) {
            throw new IllegalArgumentException("Null 'subplot' argument.");
        }
        if (weight < 1) {
            throw new IllegalArgumentException("Require weight >= 1.");
        }
        subplot.setParent(this);
        subplot.setWeight(weight);
        subplot.setInsets(new RectangleInsets(0.0, 0.0, 0.0, 0.0));
        subplot.setDomainAxis(null);
        subplot.setOrientation(this.getOrientation());
        subplot.addChangeListener(this);
        this.subplots.add(subplot);
        CategoryAxis axis = this.getDomainAxis();
        if (axis != null) {
            axis.configure();
        }
        this.fireChangeEvent();
    }

    public void remove(CategoryPlot subplot) {
        if (subplot == null) {
            throw new IllegalArgumentException("Null 'subplot' argument.");
        }
        int position = -1;
        int size = this.subplots.size();
        int i = 0;
        while (position == -1 && i < size) {
            if (this.subplots.get(i) == subplot) {
                position = i;
            }
            ++i;
        }
        if (position != -1) {
            this.subplots.remove(position);
            subplot.setParent(null);
            subplot.removeChangeListener(this);
            CategoryAxis domain = this.getDomainAxis();
            if (domain != null) {
                domain.configure();
            }
            this.fireChangeEvent();
        }
    }

    public List getSubplots() {
        if (this.subplots != null) {
            return Collections.unmodifiableList(this.subplots);
        }
        return Collections.EMPTY_LIST;
    }

    public CategoryPlot findSubplot(PlotRenderingInfo info, PointF source) {
        if (info == null) {
            throw new IllegalArgumentException("Null 'info' argument.");
        }
        if (source == null) {
            throw new IllegalArgumentException("Null 'source' argument.");
        }
        CategoryPlot result = null;
        int subplotIndex = info.getSubplotIndex(source);
        if (subplotIndex >= 0) {
            result = (CategoryPlot)this.subplots.get(subplotIndex);
        }
        return result;
    }

    public void zoomRangeAxes(double factor, PlotRenderingInfo info, PointF source) {
        this.zoomRangeAxes(factor, info, source, false);
    }

    public void zoomRangeAxes(double factor, PlotRenderingInfo info, PointF source, boolean useAnchor) {
        CategoryPlot subplot2 = this.findSubplot(info, source);
        if (subplot2 != null) {
            subplot2.zoomRangeAxes(factor, info, source, useAnchor);
        } else {
            for (CategoryPlot subplot2 : this.getSubplots()) {
                subplot2.zoomRangeAxes(factor, info, source, useAnchor);
            }
        }
    }

    public void zoomRangeAxes(double lowerPercent, double upperPercent, PlotRenderingInfo info, PointF source) {
        CategoryPlot subplot2 = this.findSubplot(info, source);
        if (subplot2 != null) {
            subplot2.zoomRangeAxes(lowerPercent, upperPercent, info, source);
        } else {
            for (CategoryPlot subplot2 : this.getSubplots()) {
                subplot2.zoomRangeAxes(lowerPercent, upperPercent, info, source);
            }
        }
    }

    public void moveRangeAxes(double movePercent, PlotRenderingInfo info, PointF source) {
        CategoryPlot p = this.findSubplot(info, source);
        if (p instanceof Movable) {
            int i = 0;
            while (i < p.getRangeAxisCount()) {
                ValueAxis rangeAxis = p.getRangeAxis(i);
                if (rangeAxis != null) {
                    rangeAxis.moveRange(movePercent);
                }
                ++i;
            }
        }
    }

    protected AxisSpace calculateAxisSpace(Canvas canvas, RectShape plotArea) {
        AxisSpace space = new AxisSpace();
        PlotOrientation orientation = this.getOrientation();
        AxisSpace fixed = this.getFixedDomainAxisSpace();
        if (fixed != null) {
            if (orientation == PlotOrientation.HORIZONTAL) {
                space.setLeft(fixed.getLeft());
                space.setRight(fixed.getRight());
            } else if (orientation == PlotOrientation.VERTICAL) {
                space.setTop(fixed.getTop());
                space.setBottom(fixed.getBottom());
            }
        } else {
            CategoryAxis categoryAxis = this.getDomainAxis();
            RectangleEdge categoryEdge = Plot.resolveDomainAxisLocation(this.getDomainAxisLocation(), orientation);
            if (categoryAxis != null) {
                space = categoryAxis.reserveSpace(canvas, this, plotArea, categoryEdge, space);
            } else if (this.getDrawSharedDomainAxis()) {
                space = this.getDomainAxis().reserveSpace(canvas, this, plotArea, categoryEdge, space);
            }
        }
        RectShape adjustedPlotArea = space.shrink(plotArea, null);
        int n = this.subplots.size();
        int totalWeight = 0;
        int i = 0;
        while (i < n) {
            CategoryPlot sub = (CategoryPlot)this.subplots.get(i);
            totalWeight += sub.getWeight();
            ++i;
        }
        this.subplotAreas = new RectShape[n];
        double x = adjustedPlotArea.getX();
        double y = adjustedPlotArea.getY();
        double usableSize = 0.0;
        if (orientation == PlotOrientation.HORIZONTAL) {
            usableSize = (double)adjustedPlotArea.getWidth() - this.gap * (double)(n - 1);
        } else if (orientation == PlotOrientation.VERTICAL) {
            usableSize = (double)adjustedPlotArea.getHeight() - this.gap * (double)(n - 1);
        }
        int i2 = 0;
        while (i2 < n) {
            CategoryPlot plot = (CategoryPlot)this.subplots.get(i2);
            if (orientation == PlotOrientation.HORIZONTAL) {
                double w = usableSize * (double)plot.getWeight() / (double)totalWeight;
                this.subplotAreas[i2] = new RectShape(x, y, w, (double)adjustedPlotArea.getHeight());
                x = x + w + this.gap;
            } else if (orientation == PlotOrientation.VERTICAL) {
                double h = usableSize * (double)plot.getWeight() / (double)totalWeight;
                this.subplotAreas[i2] = new RectShape(x, y, (double)adjustedPlotArea.getWidth(), h);
                y = y + h + this.gap;
            }
            AxisSpace subSpace = plot.calculateRangeAxisSpace(canvas, this.subplotAreas[i2], null);
            space.ensureAtLeast(subSpace);
            ++i2;
        }
        return space;
    }

    public void draw(Canvas canvas, RectShape area, PointF anchor, PlotState parentState, PlotRenderingInfo info) {
        if (info != null) {
            info.setPlotArea(area);
        }
        RectangleInsets insets = this.getInsets();
        area.setRect((double)area.getX() + insets.getLeft(), (double)area.getY() + insets.getTop(), (double)area.getWidth() - insets.getLeft() - insets.getRight(), (double)area.getHeight() - insets.getTop() - insets.getBottom());
        this.setFixedRangeAxisSpaceForSubplots(null);
        AxisSpace space = this.calculateAxisSpace(canvas, area);
        RectShape dataArea = space.shrink(area, null);
        this.setFixedRangeAxisSpaceForSubplots(space);
        CategoryAxis axis = this.getDomainAxis();
        RectangleEdge domainEdge = this.getDomainAxisEdge();
        double cursor = RectangleEdge.coordinate(dataArea, domainEdge);
        AxisState axisState = axis.draw(canvas, cursor, area, dataArea, domainEdge, info);
        if (parentState == null) {
            parentState = new PlotState();
        }
        parentState.getSharedAxisStates().put(axis, axisState);
        int i = 0;
        while (i < this.subplots.size()) {
            CategoryPlot plot = (CategoryPlot)this.subplots.get(i);
            PlotRenderingInfo subplotInfo = null;
            if (info != null) {
                subplotInfo = new PlotRenderingInfo(info.getOwner());
                info.addSubplotInfo(subplotInfo);
            }
            PointF subAnchor = null;
            if (anchor != null && this.subplotAreas[i].contains(anchor)) {
                subAnchor = anchor;
            }
            plot.draw(canvas, this.subplotAreas[i], subAnchor, parentState, subplotInfo);
            ++i;
        }
        if (info != null) {
            info.setDataArea(dataArea);
        }
    }

    protected void setFixedRangeAxisSpaceForSubplots(AxisSpace space) {
        for (CategoryPlot plot : this.subplots) {
            plot.setFixedRangeAxisSpace(space, false);
        }
    }

    public void setOrientation(PlotOrientation orientation) {
        super.setOrientation(orientation);
        for (CategoryPlot plot : this.subplots) {
            plot.setOrientation(orientation);
        }
    }

    public Range getDataRange(ValueAxis axis) {
        return super.getDataRange(axis);
    }

    public LegendItemCollection getLegendItems() {
        LegendItemCollection result = this.getFixedLegendItems();
        if (result == null) {
            result = new LegendItemCollection();
            if (this.subplots != null) {
                for (CategoryPlot plot : this.subplots) {
                    LegendItemCollection more = plot.getLegendItems();
                    result.addAll(more);
                }
            }
        }
        return result;
    }

    public List getCategories() {
        ArrayList<Comparable> result = new ArrayList<Comparable>();
        if (this.subplots != null) {
            for (CategoryPlot plot : this.subplots) {
                List more = plot.getCategories();
                for (Comparable category : more) {
                    if (result.contains(category)) continue;
                    result.add(category);
                }
            }
        }
        return Collections.unmodifiableList(result);
    }

    public List getCategoriesForAxis(CategoryAxis axis) {
        return this.getCategories();
    }

    public void handleClick(int x, int y, PlotRenderingInfo info) {
        RectShape dataArea = info.getDataArea();
        if (dataArea.contains(x, y)) {
            int i = 0;
            while (i < this.subplots.size()) {
                CategoryPlot subplot = (CategoryPlot)this.subplots.get(i);
                PlotRenderingInfo subplotInfo = info.getSubplotInfo(i);
                subplot.handleClick(x, y, subplotInfo);
                ++i;
            }
        }
    }

    public void plotChanged(PlotChangeEvent event) {
        this.notifyListeners(event);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof CombinedDomainCategoryPlot)) {
            return false;
        }
        CombinedDomainCategoryPlot that = (CombinedDomainCategoryPlot)obj;
        if (this.gap != that.gap) {
            return false;
        }
        return super.equals(obj);
    }
}

