/*
 * Decompiled with CFR 0.152.
 */
package org.afree.chart.plot;

import android.graphics.Canvas;
import android.graphics.DashPathEffect;
import android.graphics.Paint;
import android.graphics.PathEffect;
import android.graphics.PointF;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.afree.chart.LegendItem;
import org.afree.chart.LegendItemCollection;
import org.afree.chart.annotations.CategoryAnnotation;
import org.afree.chart.axis.Axis;
import org.afree.chart.axis.AxisCollection;
import org.afree.chart.axis.AxisLocation;
import org.afree.chart.axis.AxisSpace;
import org.afree.chart.axis.AxisState;
import org.afree.chart.axis.CategoryAnchor;
import org.afree.chart.axis.CategoryAxis;
import org.afree.chart.axis.TickType;
import org.afree.chart.axis.ValueAxis;
import org.afree.chart.axis.ValueTick;
import org.afree.chart.event.ChartChangeEventType;
import org.afree.chart.event.PlotChangeEvent;
import org.afree.chart.event.RendererChangeEvent;
import org.afree.chart.event.RendererChangeListener;
import org.afree.chart.plot.CategoryCrosshairState;
import org.afree.chart.plot.CategoryMarker;
import org.afree.chart.plot.DatasetRenderingOrder;
import org.afree.chart.plot.Marker;
import org.afree.chart.plot.Movable;
import org.afree.chart.plot.Pannable;
import org.afree.chart.plot.Plot;
import org.afree.chart.plot.PlotOrientation;
import org.afree.chart.plot.PlotRenderingInfo;
import org.afree.chart.plot.PlotState;
import org.afree.chart.plot.ValueAxisPlot;
import org.afree.chart.plot.Zoomable;
import org.afree.chart.renderer.category.AbstractCategoryItemRenderer;
import org.afree.chart.renderer.category.CategoryItemRenderer;
import org.afree.chart.renderer.category.CategoryItemRendererState;
import org.afree.data.Range;
import org.afree.data.category.CategoryDataset;
import org.afree.data.general.DatasetChangeEvent;
import org.afree.data.general.DatasetUtilities;
import org.afree.graphics.PaintType;
import org.afree.graphics.PaintUtility;
import org.afree.graphics.SolidColor;
import org.afree.graphics.geom.Font;
import org.afree.graphics.geom.LineShape;
import org.afree.graphics.geom.RectShape;
import org.afree.ui.Layer;
import org.afree.ui.RectangleEdge;
import org.afree.ui.RectangleInsets;
import org.afree.util.ObjectList;
import org.afree.util.ShapeUtilities;
import org.afree.util.SortOrder;

public class CategoryPlot
extends Plot
implements ValueAxisPlot,
Pannable,
Zoomable,
RendererChangeListener,
Movable,
Cloneable,
Serializable {
    private static final long serialVersionUID = -3537691700434728188L;
    public static final boolean DEFAULT_DOMAIN_GRIDLINES_VISIBLE = false;
    public static final boolean DEFAULT_RANGE_GRIDLINES_VISIBLE = true;
    public static final float DEFAULT_GRIDLINE_STROKE = 1.0f;
    public static final PaintType DEFAULT_GRIDLINE_PAINT_TYPE = new SolidColor(-3355444);
    public static final PathEffect DEFAULT_GRIDLINE_EFFECT = new DashPathEffect(new float[]{3.0f, 2.0f}, 0.0f);
    public static final Font DEFAULT_VALUE_LABEL_FONT = new Font("SansSerif", 0, 10);
    public static final boolean DEFAULT_CROSSHAIR_VISIBLE = false;
    public static final float DEFAULT_CROSSHAIR_STROKE = 1.0f;
    public static final PaintType DEFAULT_CROSSHAIR_PAINT_TYPE = new SolidColor(-16776961);
    public static final PathEffect DEFAULT_CROSSHAIR_EFFECT = new DashPathEffect(new float[]{3.0f, 2.0f}, 0.0f);
    private PlotOrientation orientation;
    private RectangleInsets axisOffset;
    private ObjectList domainAxes;
    private ObjectList domainAxisLocations;
    private boolean drawSharedDomainAxis;
    private ObjectList rangeAxes;
    private ObjectList rangeAxisLocations;
    private ObjectList datasets;
    private TreeMap datasetToDomainAxesMap;
    private TreeMap datasetToRangeAxesMap;
    private ObjectList renderers;
    private DatasetRenderingOrder renderingOrder = DatasetRenderingOrder.REVERSE;
    private SortOrder columnRenderingOrder = SortOrder.ASCENDING;
    private SortOrder rowRenderingOrder = SortOrder.ASCENDING;
    private boolean domainGridlinesVisible;
    private CategoryAnchor domainGridlinePosition;
    private transient float domainGridlineStroke;
    private transient PaintType domainGridlinePaintType;
    private transient PathEffect domainGridlineEffect;
    private boolean rangeZeroBaselineVisible;
    private transient float rangeZeroBaselineStroke;
    private transient PaintType rangeZeroBaselinePaintType;
    private transient PathEffect rangeZeroBaselineEffect;
    private boolean rangeGridlinesVisible;
    private transient float rangeGridlineStroke;
    private transient PaintType rangeGridlinePaintType;
    private transient PathEffect rangeGridlineEffect;
    private boolean rangeMinorGridlinesVisible;
    private transient float rangeMinorGridlineStroke;
    private transient PathEffect rangeMinorGridlineEffect;
    private transient PaintType rangeMinorGridlinePaintType;
    private double anchorValue;
    private int crosshairDatasetIndex;
    private boolean domainCrosshairVisible;
    private Comparable domainCrosshairRowKey;
    private Comparable domainCrosshairColumnKey;
    private transient float domainCrosshairStroke;
    private transient PaintType domainCrosshairPaintType;
    private transient PathEffect domainCrosshairEffect;
    private boolean rangeCrosshairVisible;
    private double rangeCrosshairValue;
    private transient float rangeCrosshairStroke;
    private transient PaintType rangeCrosshairPaintType;
    private transient PathEffect rangeCrosshairEffect;
    private boolean rangeCrosshairLockedOnData = true;
    private Map foregroundDomainMarkers;
    private Map backgroundDomainMarkers;
    private Map foregroundRangeMarkers;
    private Map backgroundRangeMarkers;
    private List annotations;
    private int weight;
    private AxisSpace fixedDomainAxisSpace;
    private AxisSpace fixedRangeAxisSpace;
    private LegendItemCollection fixedLegendItems;
    private boolean rangePannable;

    public CategoryPlot() {
        this(null, null, null, null);
    }

    public CategoryPlot(CategoryDataset dataset, CategoryAxis domainAxis, ValueAxis rangeAxis, CategoryItemRenderer renderer) {
        this.orientation = PlotOrientation.VERTICAL;
        this.domainAxes = new ObjectList();
        this.domainAxisLocations = new ObjectList();
        this.rangeAxes = new ObjectList();
        this.rangeAxisLocations = new ObjectList();
        this.datasetToDomainAxesMap = new TreeMap();
        this.datasetToRangeAxesMap = new TreeMap();
        this.renderers = new ObjectList();
        this.datasets = new ObjectList();
        this.datasets.set(0, dataset);
        if (dataset != null) {
            dataset.addChangeListener(this);
        }
        this.axisOffset = RectangleInsets.ZERO_INSETS;
        this.setDomainAxisLocation(AxisLocation.BOTTOM_OR_LEFT, false);
        this.setRangeAxisLocation(AxisLocation.TOP_OR_LEFT, false);
        this.renderers.set(0, renderer);
        if (renderer != null) {
            renderer.setPlot(this);
            renderer.addChangeListener(this);
        }
        this.domainAxes.set(0, domainAxis);
        this.mapDatasetToDomainAxis(0, 0);
        if (domainAxis != null) {
            domainAxis.setPlot(this);
            domainAxis.addChangeListener(this);
        }
        this.drawSharedDomainAxis = false;
        this.rangeAxes.set(0, rangeAxis);
        this.mapDatasetToRangeAxis(0, 0);
        if (rangeAxis != null) {
            rangeAxis.setPlot(this);
            rangeAxis.addChangeListener(this);
        }
        this.configureDomainAxes();
        this.configureRangeAxes();
        this.domainGridlinesVisible = false;
        this.domainGridlinePosition = CategoryAnchor.MIDDLE;
        this.domainGridlineStroke = 1.0f;
        this.domainGridlinePaintType = DEFAULT_GRIDLINE_PAINT_TYPE;
        this.domainGridlineEffect = DEFAULT_GRIDLINE_EFFECT;
        this.rangeZeroBaselineVisible = false;
        this.rangeZeroBaselinePaintType = new SolidColor(-16777216);
        this.rangeZeroBaselinePaintType = null;
        this.rangeZeroBaselineStroke = 0.5f;
        this.rangeGridlinesVisible = true;
        this.rangeGridlineStroke = 1.0f;
        this.rangeGridlinePaintType = DEFAULT_GRIDLINE_PAINT_TYPE;
        this.rangeGridlineEffect = DEFAULT_GRIDLINE_EFFECT;
        this.rangeMinorGridlinesVisible = false;
        this.rangeMinorGridlineStroke = 1.0f;
        this.rangeMinorGridlineEffect = DEFAULT_GRIDLINE_EFFECT;
        this.rangeMinorGridlinePaintType = new SolidColor(-1);
        this.foregroundDomainMarkers = new HashMap();
        this.backgroundDomainMarkers = new HashMap();
        this.foregroundRangeMarkers = new HashMap();
        this.backgroundRangeMarkers = new HashMap();
        this.anchorValue = 0.0;
        this.domainCrosshairVisible = false;
        this.domainCrosshairStroke = 1.0f;
        this.domainCrosshairPaintType = DEFAULT_CROSSHAIR_PAINT_TYPE;
        this.domainCrosshairEffect = DEFAULT_CROSSHAIR_EFFECT;
        this.rangeCrosshairVisible = false;
        this.rangeCrosshairValue = 0.0;
        this.rangeCrosshairStroke = 1.0f;
        this.rangeCrosshairPaintType = DEFAULT_CROSSHAIR_PAINT_TYPE;
        this.rangeCrosshairEffect = DEFAULT_CROSSHAIR_EFFECT;
        this.annotations = new ArrayList();
        this.rangePannable = false;
    }

    public String getPlotType() {
        return "Category_Plot";
    }

    public PlotOrientation getOrientation() {
        return this.orientation;
    }

    public void setOrientation(PlotOrientation orientation) {
        if (orientation == null) {
            throw new IllegalArgumentException("Null 'orientation' argument.");
        }
        this.orientation = orientation;
        this.fireChangeEvent();
    }

    public RectangleInsets getAxisOffset() {
        return this.axisOffset;
    }

    public void setAxisOffset(RectangleInsets offset) {
        if (offset == null) {
            throw new IllegalArgumentException("Null 'offset' argument.");
        }
        this.axisOffset = offset;
        this.fireChangeEvent();
    }

    public CategoryAxis getDomainAxis() {
        return this.getDomainAxis(0);
    }

    public CategoryAxis getDomainAxis(int index) {
        Plot parent;
        CategoryAxis result = null;
        if (index < this.domainAxes.size()) {
            result = (CategoryAxis)this.domainAxes.get(index);
        }
        if (result == null && (parent = this.getParent()) instanceof CategoryPlot) {
            CategoryPlot cp = (CategoryPlot)parent;
            result = cp.getDomainAxis(index);
        }
        return result;
    }

    public void setDomainAxis(CategoryAxis axis) {
        this.setDomainAxis(0, axis);
    }

    public void setDomainAxis(int index, CategoryAxis axis) {
        this.setDomainAxis(index, axis, true);
    }

    public void setDomainAxis(int index, CategoryAxis axis, boolean notify) {
        CategoryAxis existing = (CategoryAxis)this.domainAxes.get(index);
        if (existing != null) {
            existing.removeChangeListener(this);
        }
        if (axis != null) {
            axis.setPlot(this);
        }
        this.domainAxes.set(index, axis);
        if (axis != null) {
            axis.configure();
            axis.addChangeListener(this);
        }
        if (notify) {
            this.fireChangeEvent();
        }
    }

    public void setDomainAxes(CategoryAxis[] axes) {
        int i = 0;
        while (i < axes.length) {
            this.setDomainAxis(i, axes[i], false);
            ++i;
        }
        this.fireChangeEvent();
    }

    public int getDomainAxisIndex(CategoryAxis axis) {
        if (axis == null) {
            throw new IllegalArgumentException("Null 'axis' argument.");
        }
        return this.domainAxes.indexOf(axis);
    }

    public AxisLocation getDomainAxisLocation() {
        return this.getDomainAxisLocation(0);
    }

    public AxisLocation getDomainAxisLocation(int index) {
        AxisLocation result = null;
        if (index < this.domainAxisLocations.size()) {
            result = (AxisLocation)this.domainAxisLocations.get(index);
        }
        if (result == null) {
            result = AxisLocation.getOpposite(this.getDomainAxisLocation(0));
        }
        return result;
    }

    public void setDomainAxisLocation(AxisLocation location) {
        this.setDomainAxisLocation(0, location, true);
    }

    public void setDomainAxisLocation(AxisLocation location, boolean notify) {
        this.setDomainAxisLocation(0, location, notify);
    }

    public void setDomainAxisLocation(int index, AxisLocation location) {
        this.setDomainAxisLocation(index, location, true);
    }

    public void setDomainAxisLocation(int index, AxisLocation location, boolean notify) {
        if (index == 0 && location == null) {
            throw new IllegalArgumentException("Null 'location' for index 0 not permitted.");
        }
        this.domainAxisLocations.set(index, location);
        if (notify) {
            this.fireChangeEvent();
        }
    }

    public RectangleEdge getDomainAxisEdge() {
        return this.getDomainAxisEdge(0);
    }

    public RectangleEdge getDomainAxisEdge(int index) {
        RectangleEdge result = null;
        AxisLocation location = this.getDomainAxisLocation(index);
        result = location != null ? Plot.resolveDomainAxisLocation(location, this.orientation) : RectangleEdge.opposite(this.getDomainAxisEdge(0));
        return result;
    }

    public int getDomainAxisCount() {
        return this.domainAxes.size();
    }

    public void clearDomainAxes() {
        int i = 0;
        while (i < this.domainAxes.size()) {
            CategoryAxis axis = (CategoryAxis)this.domainAxes.get(i);
            if (axis != null) {
                axis.removeChangeListener(this);
            }
            ++i;
        }
        this.domainAxes.clear();
        this.fireChangeEvent();
    }

    public void configureDomainAxes() {
        int i = 0;
        while (i < this.domainAxes.size()) {
            CategoryAxis axis = (CategoryAxis)this.domainAxes.get(i);
            if (axis != null) {
                axis.configure();
            }
            ++i;
        }
    }

    public ValueAxis getRangeAxis() {
        return this.getRangeAxis(0);
    }

    public ValueAxis getRangeAxis(int index) {
        Plot parent;
        ValueAxis result = null;
        if (index < this.rangeAxes.size()) {
            result = (ValueAxis)this.rangeAxes.get(index);
        }
        if (result == null && (parent = this.getParent()) instanceof CategoryPlot) {
            CategoryPlot cp = (CategoryPlot)parent;
            result = cp.getRangeAxis(index);
        }
        return result;
    }

    public void setRangeAxis(ValueAxis axis) {
        this.setRangeAxis(0, axis);
    }

    public void setRangeAxis(int index, ValueAxis axis) {
        this.setRangeAxis(index, axis, true);
    }

    public void setRangeAxis(int index, ValueAxis axis, boolean notify) {
        ValueAxis existing = (ValueAxis)this.rangeAxes.get(index);
        if (existing != null) {
            existing.removeChangeListener(this);
        }
        if (axis != null) {
            axis.setPlot(this);
        }
        this.rangeAxes.set(index, axis);
        if (axis != null) {
            axis.configure();
            axis.addChangeListener(this);
        }
        if (notify) {
            this.fireChangeEvent();
        }
    }

    public void setRangeAxes(ValueAxis[] axes) {
        int i = 0;
        while (i < axes.length) {
            this.setRangeAxis(i, axes[i], false);
            ++i;
        }
        this.fireChangeEvent();
    }

    public int getRangeAxisIndex(ValueAxis axis) {
        Plot parent;
        if (axis == null) {
            throw new IllegalArgumentException("Null 'axis' argument.");
        }
        int result = this.rangeAxes.indexOf(axis);
        if (result < 0 && (parent = this.getParent()) instanceof CategoryPlot) {
            CategoryPlot p = (CategoryPlot)parent;
            result = p.getRangeAxisIndex(axis);
        }
        return result;
    }

    public AxisLocation getRangeAxisLocation() {
        return this.getRangeAxisLocation(0);
    }

    public AxisLocation getRangeAxisLocation(int index) {
        AxisLocation result = null;
        if (index < this.rangeAxisLocations.size()) {
            result = (AxisLocation)this.rangeAxisLocations.get(index);
        }
        if (result == null) {
            result = AxisLocation.getOpposite(this.getRangeAxisLocation(0));
        }
        return result;
    }

    public void setRangeAxisLocation(AxisLocation location) {
        this.setRangeAxisLocation(location, true);
    }

    public void setRangeAxisLocation(AxisLocation location, boolean notify) {
        this.setRangeAxisLocation(0, location, notify);
    }

    public void setRangeAxisLocation(int index, AxisLocation location) {
        this.setRangeAxisLocation(index, location, true);
    }

    public void setRangeAxisLocation(int index, AxisLocation location, boolean notify) {
        if (index == 0 && location == null) {
            throw new IllegalArgumentException("Null 'location' for index 0 not permitted.");
        }
        this.rangeAxisLocations.set(index, location);
        if (notify) {
            this.fireChangeEvent();
        }
    }

    public RectangleEdge getRangeAxisEdge() {
        return this.getRangeAxisEdge(0);
    }

    public RectangleEdge getRangeAxisEdge(int index) {
        AxisLocation location = this.getRangeAxisLocation(index);
        RectangleEdge result = Plot.resolveRangeAxisLocation(location, this.orientation);
        if (result == null) {
            result = RectangleEdge.opposite(this.getRangeAxisEdge(0));
        }
        return result;
    }

    public int getRangeAxisCount() {
        return this.rangeAxes.size();
    }

    public void clearRangeAxes() {
        int i = 0;
        while (i < this.rangeAxes.size()) {
            ValueAxis axis = (ValueAxis)this.rangeAxes.get(i);
            if (axis != null) {
                axis.removeChangeListener(this);
            }
            ++i;
        }
        this.rangeAxes.clear();
        this.fireChangeEvent();
    }

    public void configureRangeAxes() {
        int i = 0;
        while (i < this.rangeAxes.size()) {
            ValueAxis axis = (ValueAxis)this.rangeAxes.get(i);
            if (axis != null) {
                axis.configure();
            }
            ++i;
        }
    }

    public CategoryDataset getDataset() {
        return this.getDataset(0);
    }

    public CategoryDataset getDataset(int index) {
        CategoryDataset result = null;
        if (this.datasets.size() > index) {
            result = (CategoryDataset)this.datasets.get(index);
        }
        return result;
    }

    public void setDataset(CategoryDataset dataset) {
        this.setDataset(0, dataset);
    }

    public void setDataset(int index, CategoryDataset dataset) {
        CategoryDataset existing = (CategoryDataset)this.datasets.get(index);
        if (existing != null) {
            existing.removeChangeListener(this);
        }
        this.datasets.set(index, dataset);
        if (dataset != null) {
            dataset.addChangeListener(this);
        }
        DatasetChangeEvent event = new DatasetChangeEvent(this, dataset);
        this.datasetChanged(event);
    }

    public int getDatasetCount() {
        return this.datasets.size();
    }

    public int indexOf(CategoryDataset dataset) {
        int result = -1;
        int i = 0;
        while (i < this.datasets.size()) {
            if (dataset == this.datasets.get(i)) {
                result = i;
                break;
            }
            ++i;
        }
        return result;
    }

    public void mapDatasetToDomainAxis(int index, int axisIndex) {
        ArrayList<Integer> axisIndices = new ArrayList<Integer>(1);
        axisIndices.add(new Integer(axisIndex));
        this.mapDatasetToDomainAxes(index, axisIndices);
    }

    public void mapDatasetToDomainAxes(int index, List axisIndices) {
        if (index < 0) {
            throw new IllegalArgumentException("Requires 'index' >= 0.");
        }
        this.checkAxisIndices(axisIndices);
        Integer key = new Integer(index);
        this.datasetToDomainAxesMap.put(key, new ArrayList(axisIndices));
    }

    private void checkAxisIndices(List indices) {
        if (indices == null) {
            return;
        }
        int count = indices.size();
        if (count == 0) {
            throw new IllegalArgumentException("Empty list not permitted.");
        }
        HashSet set = new HashSet();
        int i = 0;
        while (i < count) {
            Object item = indices.get(i);
            if (!(item instanceof Integer)) {
                throw new IllegalArgumentException("Indices must be Integer instances.");
            }
            if (set.contains(item)) {
                throw new IllegalArgumentException("Indices must be unique.");
            }
            set.add(item);
            ++i;
        }
    }

    public CategoryAxis getDomainAxisForDataset(int index) {
        if (index < 0) {
            throw new IllegalArgumentException("Negative 'index'.");
        }
        CategoryAxis axis = null;
        List axisIndices = (List)this.datasetToDomainAxesMap.get(new Integer(index));
        if (axisIndices != null) {
            Integer axisIndex = (Integer)axisIndices.get(0);
            axis = this.getDomainAxis(axisIndex);
        } else {
            axis = this.getDomainAxis(0);
        }
        return axis;
    }

    public void mapDatasetToRangeAxis(int index, int axisIndex) {
        ArrayList<Integer> axisIndices = new ArrayList<Integer>(1);
        axisIndices.add(new Integer(axisIndex));
        this.mapDatasetToRangeAxes(index, axisIndices);
    }

    public void mapDatasetToRangeAxes(int index, List axisIndices) {
        if (index < 0) {
            throw new IllegalArgumentException("Requires 'index' >= 0.");
        }
        this.checkAxisIndices(axisIndices);
        Integer key = new Integer(index);
        this.datasetToRangeAxesMap.put(key, new ArrayList(axisIndices));
    }

    public ValueAxis getRangeAxisForDataset(int index) {
        if (index < 0) {
            throw new IllegalArgumentException("Negative 'index'.");
        }
        ValueAxis axis = null;
        List axisIndices = (List)this.datasetToRangeAxesMap.get(new Integer(index));
        if (axisIndices != null) {
            Integer axisIndex = (Integer)axisIndices.get(0);
            axis = this.getRangeAxis(axisIndex);
        } else {
            axis = this.getRangeAxis(0);
        }
        return axis;
    }

    public int getRendererCount() {
        return this.renderers.size();
    }

    public CategoryItemRenderer getRenderer() {
        return this.getRenderer(0);
    }

    public CategoryItemRenderer getRenderer(int index) {
        CategoryItemRenderer result = null;
        if (this.renderers.size() > index) {
            result = (CategoryItemRenderer)this.renderers.get(index);
        }
        return result;
    }

    public void setRenderer(CategoryItemRenderer renderer) {
        this.setRenderer(0, renderer, true);
    }

    public void setRenderer(CategoryItemRenderer renderer, boolean notify) {
        this.setRenderer(0, renderer, notify);
    }

    public void setRenderer(int index, CategoryItemRenderer renderer) {
        this.setRenderer(index, renderer, true);
    }

    public void setRenderer(int index, CategoryItemRenderer renderer, boolean notify) {
        CategoryItemRenderer existing = (CategoryItemRenderer)this.renderers.get(index);
        if (existing != null) {
            existing.removeChangeListener(this);
        }
        this.renderers.set(index, renderer);
        if (renderer != null) {
            renderer.setPlot(this);
            renderer.addChangeListener(this);
        }
        this.configureDomainAxes();
        this.configureRangeAxes();
        if (notify) {
            this.fireChangeEvent();
        }
    }

    public void setRenderers(CategoryItemRenderer[] renderers) {
        int i = 0;
        while (i < renderers.length) {
            this.setRenderer(i, renderers[i], false);
            ++i;
        }
        this.fireChangeEvent();
    }

    public CategoryItemRenderer getRendererForDataset(CategoryDataset dataset) {
        CategoryItemRenderer result = null;
        int i = 0;
        while (i < this.datasets.size()) {
            if (this.datasets.get(i) == dataset) {
                result = (CategoryItemRenderer)this.renderers.get(i);
                break;
            }
            ++i;
        }
        return result;
    }

    public int getIndexOf(CategoryItemRenderer renderer) {
        return this.renderers.indexOf(renderer);
    }

    public DatasetRenderingOrder getDatasetRenderingOrder() {
        return this.renderingOrder;
    }

    public void setDatasetRenderingOrder(DatasetRenderingOrder order) {
        if (order == null) {
            throw new IllegalArgumentException("Null 'order' argument.");
        }
        this.renderingOrder = order;
        this.fireChangeEvent();
    }

    public SortOrder getColumnRenderingOrder() {
        return this.columnRenderingOrder;
    }

    public void setColumnRenderingOrder(SortOrder order) {
        if (order == null) {
            throw new IllegalArgumentException("Null 'order' argument.");
        }
        this.columnRenderingOrder = order;
        this.fireChangeEvent();
    }

    public SortOrder getRowRenderingOrder() {
        return this.rowRenderingOrder;
    }

    public void setRowRenderingOrder(SortOrder order) {
        if (order == null) {
            throw new IllegalArgumentException("Null 'order' argument.");
        }
        this.rowRenderingOrder = order;
        this.fireChangeEvent();
    }

    public boolean isDomainGridlinesVisible() {
        return this.domainGridlinesVisible;
    }

    public void setDomainGridlinesVisible(boolean visible) {
        if (this.domainGridlinesVisible != visible) {
            this.domainGridlinesVisible = visible;
            this.fireChangeEvent();
        }
    }

    public CategoryAnchor getDomainGridlinePosition() {
        return this.domainGridlinePosition;
    }

    public void setDomainGridlinePosition(CategoryAnchor position) {
        if (position == null) {
            throw new IllegalArgumentException("Null 'position' argument.");
        }
        this.domainGridlinePosition = position;
        this.fireChangeEvent();
    }

    public float getDomainGridlineStroke() {
        return this.domainGridlineStroke;
    }

    public void setDomainGridlineStroke(float stroke) {
        this.domainGridlineStroke = stroke;
        this.fireChangeEvent();
    }

    public PaintType getDomainGridlinePaintType() {
        return this.domainGridlinePaintType;
    }

    public void setDomainGridlinePaintType(PaintType paintType) {
        if (paintType == null) {
            throw new IllegalArgumentException("Null 'paintType' argument.");
        }
        this.domainGridlinePaintType = paintType;
        this.fireChangeEvent();
    }

    public PathEffect getDomainGridlineEffect() {
        return this.domainGridlineEffect;
    }

    public void setDomainGridlineEffect(PathEffect effect) {
        this.domainGridlineEffect = effect;
        this.notifyListeners(new PlotChangeEvent(this));
    }

    public boolean isRangeZeroBaselineVisible() {
        return this.rangeZeroBaselineVisible;
    }

    public void setRangeZeroBaselineVisible(boolean visible) {
        this.rangeZeroBaselineVisible = visible;
        this.fireChangeEvent();
    }

    public float getRangeZeroBaselineStroke() {
        return this.rangeZeroBaselineStroke;
    }

    public void setRangeZeroBaselineStroke(float stroke) {
        this.rangeZeroBaselineStroke = stroke;
        this.fireChangeEvent();
    }

    public PaintType getRangeZeroBaselinePaintType() {
        return this.rangeZeroBaselinePaintType;
    }

    public void setRangeZeroBaselinePaintType(PaintType paintType) {
        if (paintType == null) {
            throw new IllegalArgumentException("Null 'paint' argument.");
        }
        this.rangeZeroBaselinePaintType = paintType;
        this.fireChangeEvent();
    }

    public boolean isRangeGridlinesVisible() {
        return this.rangeGridlinesVisible;
    }

    public void setRangeGridlinesVisible(boolean visible) {
        if (this.rangeGridlinesVisible != visible) {
            this.rangeGridlinesVisible = visible;
            this.fireChangeEvent();
        }
    }

    public float getRangeGridlineStroke() {
        return this.rangeGridlineStroke;
    }

    public void setRangeGridlineStroke(float stroke) {
        this.rangeGridlineStroke = stroke;
        this.fireChangeEvent();
    }

    public PaintType getRangeGridlinePaintType() {
        return this.rangeGridlinePaintType;
    }

    public void setRangeGridlinePaintType(PaintType paintType) {
        if (paintType == null) {
            throw new IllegalArgumentException("Null 'paint' argument.");
        }
        this.rangeGridlinePaintType = paintType;
        this.fireChangeEvent();
    }

    public PathEffect getRangeGridlineEffect() {
        return this.rangeGridlineEffect;
    }

    public void setRangeGridlineEffect(PathEffect effect) {
        this.rangeGridlineEffect = effect;
        this.notifyListeners(new PlotChangeEvent(this));
    }

    public boolean isRangeMinorGridlinesVisible() {
        return this.rangeMinorGridlinesVisible;
    }

    public void setRangeMinorGridlinesVisible(boolean visible) {
        if (this.rangeMinorGridlinesVisible != visible) {
            this.rangeMinorGridlinesVisible = visible;
            this.fireChangeEvent();
        }
    }

    public float getRangeMinorGridlineStroke() {
        return this.rangeMinorGridlineStroke;
    }

    public void setRangeMinorGridlineStroke(float stroke) {
        this.rangeMinorGridlineStroke = stroke;
        this.fireChangeEvent();
    }

    public PathEffect getRangeMinorGridlineEffect() {
        return this.rangeMinorGridlineEffect;
    }

    public void setRangeMinorGridlineEffect(PathEffect effect) {
        this.rangeMinorGridlineEffect = effect;
        this.notifyListeners(new PlotChangeEvent(this));
    }

    public PaintType getRangeMinorGridlinePaintType() {
        return this.rangeMinorGridlinePaintType;
    }

    public void setRangeMinorGridlinePaintType(PaintType paintType) {
        if (paintType == null) {
            throw new IllegalArgumentException("Null 'paint' argument.");
        }
        this.rangeMinorGridlinePaintType = paintType;
        this.fireChangeEvent();
    }

    public LegendItemCollection getFixedLegendItems() {
        return this.fixedLegendItems;
    }

    public void setFixedLegendItems(LegendItemCollection items) {
        this.fixedLegendItems = items;
        this.fireChangeEvent();
    }

    public LegendItemCollection getLegendItems() {
        LegendItemCollection result = this.fixedLegendItems;
        if (result == null) {
            result = new LegendItemCollection();
            int count = this.datasets.size();
            int datasetIndex = 0;
            while (datasetIndex < count) {
                CategoryItemRenderer renderer;
                CategoryDataset dataset = this.getDataset(datasetIndex);
                if (dataset != null && (renderer = this.getRenderer(datasetIndex)) != null) {
                    int seriesCount = dataset.getRowCount();
                    int i = 0;
                    while (i < seriesCount) {
                        LegendItem item = renderer.getLegendItem(datasetIndex, i);
                        if (item != null) {
                            result.add(item);
                        }
                        ++i;
                    }
                }
                ++datasetIndex;
            }
        }
        return result;
    }

    public void handleClick(int x, int y, PlotRenderingInfo info) {
        RectShape dataArea = info.getDataArea();
        if (dataArea.contains(x, y)) {
            double java2D = 0.0;
            if (this.orientation == PlotOrientation.HORIZONTAL) {
                java2D = x;
            } else if (this.orientation == PlotOrientation.VERTICAL) {
                java2D = y;
            }
            RectangleEdge edge = Plot.resolveRangeAxisLocation(this.getRangeAxisLocation(), this.orientation);
            double value = this.getRangeAxis().java2DToValue(java2D, info.getDataArea(), edge);
            this.setAnchorValue(value);
            this.setRangeCrosshairValue(value);
        }
    }

    public void zoom(double percent) {
        if (percent > 0.0) {
            double range = this.getRangeAxis().getRange().getLength();
            double scaledRange = range * percent;
            this.getRangeAxis().setRange(this.anchorValue - scaledRange / 2.0, this.anchorValue + scaledRange / 2.0);
        } else {
            this.getRangeAxis().setAutoRange(true);
        }
    }

    public void datasetChanged(DatasetChangeEvent event) {
        int count = this.rangeAxes.size();
        int axisIndex = 0;
        while (axisIndex < count) {
            ValueAxis yAxis = this.getRangeAxis(axisIndex);
            if (yAxis != null) {
                yAxis.configure();
            }
            ++axisIndex;
        }
        if (this.getParent() != null) {
            this.getParent().datasetChanged(event);
        } else {
            PlotChangeEvent e = new PlotChangeEvent(this);
            e.setType(ChartChangeEventType.DATASET_UPDATED);
            this.notifyListeners(e);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void rendererChanged(RendererChangeEvent event) {
        Plot parent = this.getParent();
        if (parent != null) {
            if (!(parent instanceof RendererChangeListener)) throw new RuntimeException("The renderer has changed and I don't know what to do!");
            RendererChangeListener rcl = (RendererChangeListener)((Object)parent);
            rcl.rendererChanged(event);
            return;
        } else {
            this.configureRangeAxes();
            PlotChangeEvent e = new PlotChangeEvent(this);
            this.notifyListeners(e);
        }
    }

    public void addDomainMarker(CategoryMarker marker) {
        this.addDomainMarker(marker, Layer.FOREGROUND);
    }

    public void addDomainMarker(CategoryMarker marker, Layer layer) {
        this.addDomainMarker(0, marker, layer);
    }

    public void addDomainMarker(int index, CategoryMarker marker, Layer layer) {
        this.addDomainMarker(index, marker, layer, true);
    }

    public void addDomainMarker(int index, CategoryMarker marker, Layer layer, boolean notify) {
        if (marker == null) {
            throw new IllegalArgumentException("Null 'marker' not permitted.");
        }
        if (layer == null) {
            throw new IllegalArgumentException("Null 'layer' not permitted.");
        }
        if (layer == Layer.FOREGROUND) {
            ArrayList<CategoryMarker> markers = (ArrayList<CategoryMarker>)this.foregroundDomainMarkers.get(new Integer(index));
            if (markers == null) {
                markers = new ArrayList<CategoryMarker>();
                this.foregroundDomainMarkers.put(new Integer(index), markers);
            }
            markers.add(marker);
        } else if (layer == Layer.BACKGROUND) {
            ArrayList<CategoryMarker> markers = (ArrayList<CategoryMarker>)this.backgroundDomainMarkers.get(new Integer(index));
            if (markers == null) {
                markers = new ArrayList<CategoryMarker>();
                this.backgroundDomainMarkers.put(new Integer(index), markers);
            }
            markers.add(marker);
        }
        marker.addChangeListener(this);
        if (notify) {
            this.fireChangeEvent();
        }
    }

    public void clearDomainMarkers() {
        Set keys;
        if (this.backgroundDomainMarkers != null) {
            keys = this.backgroundDomainMarkers.keySet();
            for (Integer key : keys) {
                this.clearDomainMarkers(key);
            }
            this.backgroundDomainMarkers.clear();
        }
        if (this.foregroundDomainMarkers != null) {
            keys = this.foregroundDomainMarkers.keySet();
            for (Integer key : keys) {
                this.clearDomainMarkers(key);
            }
            this.foregroundDomainMarkers.clear();
        }
        this.fireChangeEvent();
    }

    public Collection getDomainMarkers(Layer layer) {
        return this.getDomainMarkers(0, layer);
    }

    public Collection getDomainMarkers(int index, Layer layer) {
        Collection result = null;
        Integer key = new Integer(index);
        if (layer == Layer.FOREGROUND) {
            result = (Collection)this.foregroundDomainMarkers.get(key);
        } else if (layer == Layer.BACKGROUND) {
            result = (Collection)this.backgroundDomainMarkers.get(key);
        }
        if (result != null) {
            result = Collections.unmodifiableCollection(result);
        }
        return result;
    }

    public void clearDomainMarkers(int index) {
        Collection markers;
        Integer key = new Integer(index);
        if (this.backgroundDomainMarkers != null && (markers = (Collection)this.backgroundDomainMarkers.get(key)) != null) {
            for (Marker m : markers) {
                m.removeChangeListener(this);
            }
            markers.clear();
        }
        if (this.foregroundDomainMarkers != null && (markers = (Collection)this.foregroundDomainMarkers.get(key)) != null) {
            for (Marker m : markers) {
                m.removeChangeListener(this);
            }
            markers.clear();
        }
        this.fireChangeEvent();
    }

    public boolean removeDomainMarker(Marker marker) {
        return this.removeDomainMarker(marker, Layer.FOREGROUND);
    }

    public boolean removeDomainMarker(Marker marker, Layer layer) {
        return this.removeDomainMarker(0, marker, layer);
    }

    public boolean removeDomainMarker(int index, Marker marker, Layer layer) {
        return this.removeDomainMarker(index, marker, layer, true);
    }

    public boolean removeDomainMarker(int index, Marker marker, Layer layer, boolean notify) {
        ArrayList markers = layer == Layer.FOREGROUND ? (ArrayList)this.foregroundDomainMarkers.get(new Integer(index)) : (ArrayList)this.backgroundDomainMarkers.get(new Integer(index));
        if (markers == null) {
            return false;
        }
        boolean removed = markers.remove(marker);
        if (removed && notify) {
            this.fireChangeEvent();
        }
        return removed;
    }

    public void addRangeMarker(Marker marker) {
        this.addRangeMarker(marker, Layer.FOREGROUND);
    }

    public void addRangeMarker(Marker marker, Layer layer) {
        this.addRangeMarker(0, marker, layer);
    }

    public void addRangeMarker(int index, Marker marker, Layer layer) {
        this.addRangeMarker(index, marker, layer, true);
    }

    public void addRangeMarker(int index, Marker marker, Layer layer, boolean notify) {
        if (layer == Layer.FOREGROUND) {
            ArrayList<Marker> markers = (ArrayList<Marker>)this.foregroundRangeMarkers.get(new Integer(index));
            if (markers == null) {
                markers = new ArrayList<Marker>();
                this.foregroundRangeMarkers.put(new Integer(index), markers);
            }
            markers.add(marker);
        } else if (layer == Layer.BACKGROUND) {
            ArrayList<Marker> markers = (ArrayList<Marker>)this.backgroundRangeMarkers.get(new Integer(index));
            if (markers == null) {
                markers = new ArrayList<Marker>();
                this.backgroundRangeMarkers.put(new Integer(index), markers);
            }
            markers.add(marker);
        }
        marker.addChangeListener(this);
        if (notify) {
            this.fireChangeEvent();
        }
    }

    public void clearRangeMarkers() {
        Set keys;
        if (this.backgroundRangeMarkers != null) {
            keys = this.backgroundRangeMarkers.keySet();
            for (Integer key : keys) {
                this.clearRangeMarkers(key);
            }
            this.backgroundRangeMarkers.clear();
        }
        if (this.foregroundRangeMarkers != null) {
            keys = this.foregroundRangeMarkers.keySet();
            for (Integer key : keys) {
                this.clearRangeMarkers(key);
            }
            this.foregroundRangeMarkers.clear();
        }
        this.fireChangeEvent();
    }

    public Collection getRangeMarkers(Layer layer) {
        return this.getRangeMarkers(0, layer);
    }

    public Collection getRangeMarkers(int index, Layer layer) {
        Collection result = null;
        Integer key = new Integer(index);
        if (layer == Layer.FOREGROUND) {
            result = (Collection)this.foregroundRangeMarkers.get(key);
        } else if (layer == Layer.BACKGROUND) {
            result = (Collection)this.backgroundRangeMarkers.get(key);
        }
        if (result != null) {
            result = Collections.unmodifiableCollection(result);
        }
        return result;
    }

    public void clearRangeMarkers(int index) {
        Collection markers;
        Integer key = new Integer(index);
        if (this.backgroundRangeMarkers != null && (markers = (Collection)this.backgroundRangeMarkers.get(key)) != null) {
            for (Marker m : markers) {
                m.removeChangeListener(this);
            }
            markers.clear();
        }
        if (this.foregroundRangeMarkers != null && (markers = (Collection)this.foregroundRangeMarkers.get(key)) != null) {
            for (Marker m : markers) {
                m.removeChangeListener(this);
            }
            markers.clear();
        }
        this.fireChangeEvent();
    }

    public boolean removeRangeMarker(Marker marker) {
        return this.removeRangeMarker(marker, Layer.FOREGROUND);
    }

    public boolean removeRangeMarker(Marker marker, Layer layer) {
        return this.removeRangeMarker(0, marker, layer);
    }

    public boolean removeRangeMarker(int index, Marker marker, Layer layer) {
        return this.removeRangeMarker(index, marker, layer, true);
    }

    public boolean removeRangeMarker(int index, Marker marker, Layer layer, boolean notify) {
        if (marker == null) {
            throw new IllegalArgumentException("Null 'marker' argument.");
        }
        ArrayList markers = layer == Layer.FOREGROUND ? (ArrayList)this.foregroundRangeMarkers.get(new Integer(index)) : (ArrayList)this.backgroundRangeMarkers.get(new Integer(index));
        if (markers == null) {
            return false;
        }
        boolean removed = markers.remove(marker);
        if (removed && notify) {
            this.fireChangeEvent();
        }
        return removed;
    }

    public boolean isDomainCrosshairVisible() {
        return this.domainCrosshairVisible;
    }

    public void setDomainCrosshairVisible(boolean flag) {
        if (this.domainCrosshairVisible != flag) {
            this.domainCrosshairVisible = flag;
            this.fireChangeEvent();
        }
    }

    public Comparable getDomainCrosshairRowKey() {
        return this.domainCrosshairRowKey;
    }

    public void setDomainCrosshairRowKey(Comparable key) {
        this.setDomainCrosshairRowKey(key, true);
    }

    public void setDomainCrosshairRowKey(Comparable key, boolean notify) {
        this.domainCrosshairRowKey = key;
        if (notify) {
            this.fireChangeEvent();
        }
    }

    public Comparable getDomainCrosshairColumnKey() {
        return this.domainCrosshairColumnKey;
    }

    public void setDomainCrosshairColumnKey(Comparable key) {
        this.setDomainCrosshairColumnKey(key, true);
    }

    public void setDomainCrosshairColumnKey(Comparable key, boolean notify) {
        this.domainCrosshairColumnKey = key;
        if (notify) {
            this.fireChangeEvent();
        }
    }

    public int getCrosshairDatasetIndex() {
        return this.crosshairDatasetIndex;
    }

    public void setCrosshairDatasetIndex(int index) {
        this.setCrosshairDatasetIndex(index, true);
    }

    public void setCrosshairDatasetIndex(int index, boolean notify) {
        this.crosshairDatasetIndex = index;
        if (notify) {
            this.fireChangeEvent();
        }
    }

    public PaintType getDomainCrosshairPaintType() {
        return this.domainCrosshairPaintType;
    }

    public void setDomainCrosshairPaintType(PaintType paintType) {
        if (paintType == null) {
            throw new IllegalArgumentException("Null 'paint' argument.");
        }
        this.domainCrosshairPaintType = paintType;
        this.fireChangeEvent();
    }

    public PathEffect getDomainCrosshairEffect() {
        return this.domainCrosshairEffect;
    }

    public void setDomainCrosshairEffect(PathEffect effect) {
        this.domainCrosshairEffect = effect;
        this.notifyListeners(new PlotChangeEvent(this));
    }

    public float getDomainCrosshairStroke() {
        return this.domainCrosshairStroke;
    }

    public void setDomainCrosshairStroke(float stroke) {
        this.domainCrosshairStroke = stroke;
    }

    public boolean isRangeCrosshairVisible() {
        return this.rangeCrosshairVisible;
    }

    public void setRangeCrosshairVisible(boolean flag) {
        if (this.rangeCrosshairVisible != flag) {
            this.rangeCrosshairVisible = flag;
            this.fireChangeEvent();
        }
    }

    public boolean isRangeCrosshairLockedOnData() {
        return this.rangeCrosshairLockedOnData;
    }

    public void setRangeCrosshairLockedOnData(boolean flag) {
        if (this.rangeCrosshairLockedOnData != flag) {
            this.rangeCrosshairLockedOnData = flag;
            this.fireChangeEvent();
        }
    }

    public double getRangeCrosshairValue() {
        return this.rangeCrosshairValue;
    }

    public void setRangeCrosshairValue(double value) {
        this.setRangeCrosshairValue(value, true);
    }

    public void setRangeCrosshairValue(double value, boolean notify) {
        this.rangeCrosshairValue = value;
        if (this.isRangeCrosshairVisible() && notify) {
            this.fireChangeEvent();
        }
    }

    public float getRangeCrosshairStroke() {
        return this.rangeCrosshairStroke;
    }

    public void setRangeCrosshairStroke(float stroke) {
        this.rangeCrosshairStroke = stroke;
        this.fireChangeEvent();
    }

    public PaintType getRangeCrosshairPaintType() {
        return this.rangeCrosshairPaintType;
    }

    public void setRangeCrosshairPaintType(PaintType paintType) {
        if (paintType == null) {
            throw new IllegalArgumentException("Null 'paint' argument.");
        }
        this.rangeCrosshairPaintType = paintType;
        this.fireChangeEvent();
    }

    public PathEffect getRangeCrosshairEffect() {
        return this.rangeCrosshairEffect;
    }

    public void setRangeCrosshairEffect(PathEffect effect) {
        this.rangeCrosshairEffect = effect;
        this.notifyListeners(new PlotChangeEvent(this));
    }

    public List getAnnotations() {
        return this.annotations;
    }

    public void addAnnotation(CategoryAnnotation annotation) {
        this.addAnnotation(annotation, true);
    }

    public void addAnnotation(CategoryAnnotation annotation, boolean notify) {
        if (annotation == null) {
            throw new IllegalArgumentException("Null 'annotation' argument.");
        }
        this.annotations.add(annotation);
        if (notify) {
            this.fireChangeEvent();
        }
    }

    public boolean removeAnnotation(CategoryAnnotation annotation) {
        return this.removeAnnotation(annotation, true);
    }

    public boolean removeAnnotation(CategoryAnnotation annotation, boolean notify) {
        if (annotation == null) {
            throw new IllegalArgumentException("Null 'annotation' argument.");
        }
        boolean removed = this.annotations.remove(annotation);
        if (removed && notify) {
            this.fireChangeEvent();
        }
        return removed;
    }

    public void clearAnnotations() {
        this.annotations.clear();
        this.fireChangeEvent();
    }

    protected AxisSpace calculateDomainAxisSpace(Canvas canvas, RectShape plotArea, AxisSpace space) {
        block6: {
            block4: {
                block5: {
                    if (space == null) {
                        space = new AxisSpace();
                    }
                    if (this.fixedDomainAxisSpace == null) break block4;
                    if (this.orientation != PlotOrientation.HORIZONTAL) break block5;
                    space.ensureAtLeast(this.fixedDomainAxisSpace.getLeft(), RectangleEdge.LEFT);
                    space.ensureAtLeast(this.fixedDomainAxisSpace.getRight(), RectangleEdge.RIGHT);
                    break block6;
                }
                if (this.orientation != PlotOrientation.VERTICAL) break block6;
                space.ensureAtLeast(this.fixedDomainAxisSpace.getTop(), RectangleEdge.TOP);
                space.ensureAtLeast(this.fixedDomainAxisSpace.getBottom(), RectangleEdge.BOTTOM);
                break block6;
            }
            RectangleEdge domainEdge = Plot.resolveDomainAxisLocation(this.getDomainAxisLocation(), this.orientation);
            if (this.drawSharedDomainAxis) {
                space = this.getDomainAxis().reserveSpace(canvas, this, plotArea, domainEdge, space);
            }
            int i = 0;
            while (i < this.domainAxes.size()) {
                Axis xAxis = (Axis)this.domainAxes.get(i);
                if (xAxis != null) {
                    RectangleEdge edge = this.getDomainAxisEdge(i);
                    space = xAxis.reserveSpace(canvas, this, plotArea, edge, space);
                }
                ++i;
            }
        }
        return space;
    }

    protected AxisSpace calculateRangeAxisSpace(Canvas canvas, RectShape plotArea, AxisSpace space) {
        block5: {
            block3: {
                block4: {
                    if (space == null) {
                        space = new AxisSpace();
                    }
                    if (this.fixedRangeAxisSpace == null) break block3;
                    if (this.orientation != PlotOrientation.HORIZONTAL) break block4;
                    space.ensureAtLeast(this.fixedRangeAxisSpace.getTop(), RectangleEdge.TOP);
                    space.ensureAtLeast(this.fixedRangeAxisSpace.getBottom(), RectangleEdge.BOTTOM);
                    break block5;
                }
                if (this.orientation != PlotOrientation.VERTICAL) break block5;
                space.ensureAtLeast(this.fixedRangeAxisSpace.getLeft(), RectangleEdge.LEFT);
                space.ensureAtLeast(this.fixedRangeAxisSpace.getRight(), RectangleEdge.RIGHT);
                break block5;
            }
            int i = 0;
            while (i < this.rangeAxes.size()) {
                Axis yAxis = (Axis)this.rangeAxes.get(i);
                if (yAxis != null) {
                    RectangleEdge edge = this.getRangeAxisEdge(i);
                    space = yAxis.reserveSpace(canvas, this, plotArea, edge, space);
                }
                ++i;
            }
        }
        return space;
    }

    protected AxisSpace calculateAxisSpace(Canvas canvas, RectShape plotArea) {
        AxisSpace space = new AxisSpace();
        space = this.calculateRangeAxisSpace(canvas, plotArea, space);
        space = this.calculateDomainAxisSpace(canvas, plotArea, space);
        return space;
    }

    public void draw(Canvas canvas, RectShape area, PointF anchor, PlotState parentState, PlotRenderingInfo state) {
        int i;
        ValueAxis rangeAxis;
        boolean b2;
        boolean b1 = area.getWidth() <= 10.0f;
        boolean bl = b2 = area.getHeight() <= 10.0f;
        if (b1 || b2) {
            return;
        }
        if (state == null) {
            state = new PlotRenderingInfo(null);
        }
        state.setPlotArea(area);
        RectangleInsets insets = this.getInsets();
        insets.trim(area);
        AxisSpace space = this.calculateAxisSpace(canvas, area);
        RectShape dataArea = space.shrink(area, null);
        this.axisOffset.trim(dataArea);
        state.setDataArea(dataArea);
        this.createAndAddEntity(dataArea.clone(), state, null, null);
        if (this.getRenderer() != null) {
            this.getRenderer().drawBackground(canvas, this, dataArea);
        } else {
            this.drawBackground(canvas, dataArea);
        }
        Map axisStateMap = this.drawAxes(canvas, area, dataArea, state);
        if (anchor != null && !dataArea.contains(anchor)) {
            anchor = ShapeUtilities.getPointInRectShape(anchor.x, anchor.y, dataArea);
        }
        CategoryCrosshairState crosshairState = new CategoryCrosshairState();
        crosshairState.setCrosshairDistance(Double.POSITIVE_INFINITY);
        crosshairState.setAnchor(anchor);
        crosshairState.setAnchorX(Double.NaN);
        crosshairState.setAnchorY(Double.NaN);
        if (anchor != null && (rangeAxis = this.getRangeAxis()) != null) {
            double y = this.getOrientation() == PlotOrientation.VERTICAL ? rangeAxis.java2DToValue(anchor.y, dataArea, this.getRangeAxisEdge()) : rangeAxis.java2DToValue(anchor.x, dataArea, this.getRangeAxisEdge());
            crosshairState.setAnchorY(y);
        }
        crosshairState.setRowKey(this.getDomainCrosshairRowKey());
        crosshairState.setColumnKey(this.getDomainCrosshairColumnKey());
        crosshairState.setCrosshairY(this.getRangeCrosshairValue());
        canvas.save();
        canvas.clipRect(dataArea.getMinX(), dataArea.getMaxY(), dataArea.getMaxX(), dataArea.getMinY());
        this.drawDomainGridlines(canvas, dataArea);
        AxisState rangeAxisState = (AxisState)axisStateMap.get(this.getRangeAxis());
        if (rangeAxisState == null && parentState != null) {
            rangeAxisState = (AxisState)parentState.getSharedAxisStates().get(this.getRangeAxis());
        }
        if (rangeAxisState != null) {
            this.drawRangeGridlines(canvas, dataArea, rangeAxisState.getTicks());
            this.drawZeroRangeBaseline(canvas, dataArea);
        }
        int i2 = 0;
        while (i2 < this.renderers.size()) {
            this.drawDomainMarkers(canvas, dataArea, i2, Layer.BACKGROUND);
            ++i2;
        }
        i2 = 0;
        while (i2 < this.renderers.size()) {
            this.drawRangeMarkers(canvas, dataArea, i2, Layer.BACKGROUND);
            ++i2;
        }
        boolean foundData = false;
        DatasetRenderingOrder order = this.getDatasetRenderingOrder();
        if (order == DatasetRenderingOrder.FORWARD) {
            i = 0;
            while (i < this.datasets.size()) {
                foundData = this.render(canvas, dataArea, i, state, crosshairState) || foundData;
                ++i;
            }
        } else {
            i = this.datasets.size() - 1;
            while (i >= 0) {
                foundData = this.render(canvas, dataArea, i, state, crosshairState) || foundData;
                --i;
            }
        }
        i = 0;
        while (i < this.renderers.size()) {
            this.drawDomainMarkers(canvas, dataArea, i, Layer.FOREGROUND);
            ++i;
        }
        i = 0;
        while (i < this.renderers.size()) {
            this.drawRangeMarkers(canvas, dataArea, i, Layer.FOREGROUND);
            ++i;
        }
        this.drawAnnotations(canvas, dataArea);
        canvas.restore();
        if (!foundData) {
            this.drawNoDataMessage(canvas, dataArea);
        }
        int datasetIndex = crosshairState.getDatasetIndex();
        this.setCrosshairDatasetIndex(datasetIndex, false);
        Comparable rowKey = crosshairState.getRowKey();
        Comparable columnKey = crosshairState.getColumnKey();
        this.setDomainCrosshairRowKey(rowKey, false);
        this.setDomainCrosshairColumnKey(columnKey, false);
        if (this.isDomainCrosshairVisible() && columnKey != null) {
            this.drawDomainCrosshair(canvas, dataArea, this.orientation, datasetIndex, rowKey, columnKey, this.getDomainCrosshairStroke(), this.getDomainCrosshairPaintType(), this.getDomainCrosshairEffect());
        }
        ValueAxis yAxis = this.getRangeAxisForDataset(datasetIndex);
        RectangleEdge yAxisEdge = this.getRangeAxisEdge();
        if (!this.rangeCrosshairLockedOnData && anchor != null) {
            double yy = this.getOrientation() == PlotOrientation.VERTICAL ? yAxis.java2DToValue(anchor.y, dataArea, yAxisEdge) : yAxis.java2DToValue(anchor.x, dataArea, yAxisEdge);
            crosshairState.setCrosshairY(yy);
        }
        this.setRangeCrosshairValue(crosshairState.getCrosshairY(), false);
        if (this.isRangeCrosshairVisible()) {
            double y = this.getRangeCrosshairValue();
            this.drawRangeCrosshair(canvas, dataArea, this.getOrientation(), y, yAxis, this.getRangeCrosshairStroke(), this.getRangeCrosshairPaintType(), this.getRangeCrosshairEffect());
        }
        if (this.isOutlineVisible()) {
            if (this.getRenderer() != null) {
                this.getRenderer().drawOutline(canvas, this, dataArea);
            } else {
                this.drawOutline(canvas, dataArea);
            }
        }
    }

    public void drawBackground(Canvas canvas, RectShape area) {
        this.fillBackground(canvas, area, this.orientation);
    }

    protected Map drawAxes(Canvas canvas, RectShape plotArea, RectShape dataArea, PlotRenderingInfo plotState) {
        AxisState axisState;
        AxisCollection axisCollection = new AxisCollection();
        int index = 0;
        while (index < this.domainAxes.size()) {
            CategoryAxis xAxis = (CategoryAxis)this.domainAxes.get(index);
            if (xAxis != null) {
                axisCollection.add(xAxis, this.getDomainAxisEdge(index));
            }
            ++index;
        }
        index = 0;
        while (index < this.rangeAxes.size()) {
            ValueAxis yAxis = (ValueAxis)this.rangeAxes.get(index);
            if (yAxis != null) {
                axisCollection.add(yAxis, this.getRangeAxisEdge(index));
            }
            ++index;
        }
        HashMap<Axis, AxisState> axisStateMap = new HashMap<Axis, AxisState>();
        double cursor = (double)dataArea.getMinY() - this.axisOffset.calculateTopOutset(dataArea.getHeight());
        for (Axis axis : axisCollection.getAxesAtTop()) {
            if (axis == null) continue;
            axisState = axis.draw(canvas, cursor, plotArea, dataArea, RectangleEdge.TOP, plotState);
            cursor = axisState.getCursor();
            axisStateMap.put(axis, axisState);
        }
        cursor = (double)dataArea.getMaxY() + this.axisOffset.calculateBottomOutset(dataArea.getHeight());
        for (Axis axis : axisCollection.getAxesAtBottom()) {
            if (axis == null) continue;
            axisState = axis.draw(canvas, cursor, plotArea, dataArea, RectangleEdge.BOTTOM, plotState);
            cursor = axisState.getCursor();
            axisStateMap.put(axis, axisState);
        }
        cursor = (double)dataArea.getMinX() - this.axisOffset.calculateLeftOutset(dataArea.getWidth());
        for (Axis axis : axisCollection.getAxesAtLeft()) {
            if (axis == null) continue;
            axisState = axis.draw(canvas, cursor, plotArea, dataArea, RectangleEdge.LEFT, plotState);
            cursor = axisState.getCursor();
            axisStateMap.put(axis, axisState);
        }
        cursor = (double)dataArea.getMaxX() + this.axisOffset.calculateRightOutset(dataArea.getWidth());
        for (Axis axis : axisCollection.getAxesAtRight()) {
            if (axis == null) continue;
            axisState = axis.draw(canvas, cursor, plotArea, dataArea, RectangleEdge.RIGHT, plotState);
            cursor = axisState.getCursor();
            axisStateMap.put(axis, axisState);
        }
        return axisStateMap;
    }

    public boolean render(Canvas canvas, RectShape dataArea, int index, PlotRenderingInfo info, CategoryCrosshairState crosshairState) {
        boolean hasData;
        boolean foundData = false;
        CategoryDataset currentDataset = this.getDataset(index);
        CategoryItemRenderer renderer = this.getRenderer(index);
        CategoryAxis domainAxis = this.getDomainAxisForDataset(index);
        ValueAxis rangeAxis = this.getRangeAxisForDataset(index);
        boolean bl = hasData = !DatasetUtilities.isEmptyOrNull(currentDataset);
        if (hasData && renderer != null) {
            foundData = true;
            CategoryItemRendererState state = renderer.initialise(canvas, dataArea, this, index, info);
            state.setCrosshairState(crosshairState);
            int columnCount = currentDataset.getColumnCount();
            int rowCount = currentDataset.getRowCount();
            int passCount = renderer.getPassCount();
            int pass = 0;
            while (pass < passCount) {
                int row;
                int column;
                if (this.columnRenderingOrder == SortOrder.ASCENDING) {
                    column = 0;
                    while (column < columnCount) {
                        if (this.rowRenderingOrder == SortOrder.ASCENDING) {
                            row = 0;
                            while (row < rowCount) {
                                renderer.drawItem(canvas, state, dataArea, this, domainAxis, rangeAxis, currentDataset, row, column, pass);
                                ++row;
                            }
                        } else {
                            row = rowCount - 1;
                            while (row >= 0) {
                                renderer.drawItem(canvas, state, dataArea, this, domainAxis, rangeAxis, currentDataset, row, column, pass);
                                --row;
                            }
                        }
                        ++column;
                    }
                } else {
                    column = columnCount - 1;
                    while (column >= 0) {
                        if (this.rowRenderingOrder == SortOrder.ASCENDING) {
                            row = 0;
                            while (row < rowCount) {
                                renderer.drawItem(canvas, state, dataArea, this, domainAxis, rangeAxis, currentDataset, row, column, pass);
                                ++row;
                            }
                        } else {
                            row = rowCount - 1;
                            while (row >= 0) {
                                renderer.drawItem(canvas, state, dataArea, this, domainAxis, rangeAxis, currentDataset, row, column, pass);
                                --row;
                            }
                        }
                        --column;
                    }
                }
                ++pass;
            }
        }
        return foundData;
    }

    protected void drawDomainGridlines(Canvas canvas, RectShape dataArea) {
        if (!this.isDomainGridlinesVisible()) {
            return;
        }
        CategoryAnchor anchor = this.getDomainGridlinePosition();
        RectangleEdge domainAxisEdge = this.getDomainAxisEdge();
        CategoryDataset dataset = this.getDataset();
        if (dataset == null) {
            return;
        }
        CategoryAxis axis = this.getDomainAxis();
        if (axis != null) {
            int columnCount = dataset.getColumnCount();
            int c = 0;
            while (c < columnCount) {
                double xx = axis.getCategoryJava2DCoordinate(anchor, c, columnCount, dataArea, domainAxisEdge);
                CategoryItemRenderer renderer1 = this.getRenderer();
                if (renderer1 != null) {
                    renderer1.drawDomainGridline(canvas, this, dataArea, xx);
                }
                ++c;
            }
        }
    }

    protected void drawRangeGridlines(Canvas canvas, RectShape dataArea, List ticks) {
        if (!this.isRangeGridlinesVisible() && !this.isRangeMinorGridlinesVisible()) {
            return;
        }
        ValueAxis axis = this.getRangeAxis();
        if (axis == null) {
            return;
        }
        CategoryItemRenderer r = this.getRenderer();
        if (r == null) {
            return;
        }
        float gridStroke = 0.0f;
        PaintType gridPaintType = null;
        PathEffect gridEffect = null;
        boolean paintLine = false;
        Iterator iterator = ticks.iterator();
        while (iterator.hasNext()) {
            paintLine = false;
            ValueTick tick = (ValueTick)iterator.next();
            if (tick.getTickType() == TickType.MINOR && this.isRangeMinorGridlinesVisible()) {
                gridStroke = this.getRangeMinorGridlineStroke();
                gridPaintType = this.getRangeMinorGridlinePaintType();
                gridEffect = this.getRangeMinorGridlineEffect();
                paintLine = true;
            } else if (tick.getTickType() == TickType.MAJOR && this.isRangeGridlinesVisible()) {
                gridStroke = this.getRangeGridlineStroke();
                gridPaintType = this.getRangeGridlinePaintType();
                gridEffect = this.getRangeGridlineEffect();
                paintLine = true;
            }
            if (tick.getValue() == 0.0 && this.isRangeZeroBaselineVisible() || !paintLine) continue;
            if (r instanceof AbstractCategoryItemRenderer) {
                AbstractCategoryItemRenderer aci = (AbstractCategoryItemRenderer)r;
                aci.drawRangeLine(canvas, this, axis, dataArea, tick.getValue(), gridPaintType, Float.valueOf(gridStroke), gridEffect);
                continue;
            }
            r.drawRangeGridline(canvas, this, axis, dataArea, tick.getValue());
        }
    }

    protected void drawZeroRangeBaseline(Canvas canvas, RectShape area) {
        if (!this.isRangeZeroBaselineVisible()) {
            return;
        }
        CategoryItemRenderer r = this.getRenderer();
        if (r instanceof AbstractCategoryItemRenderer) {
            AbstractCategoryItemRenderer aci = (AbstractCategoryItemRenderer)r;
            aci.drawRangeLine(canvas, this, this.getRangeAxis(), area, 0.0, this.rangeZeroBaselinePaintType, Float.valueOf(this.rangeZeroBaselineStroke), this.rangeZeroBaselineEffect);
        } else {
            r.drawRangeGridline(canvas, this, this.getRangeAxis(), area, 0.0);
        }
    }

    protected void drawAnnotations(Canvas canvas, RectShape dataArea) {
        if (this.getAnnotations() != null) {
            for (CategoryAnnotation annotation : this.getAnnotations()) {
                annotation.draw(canvas, this, dataArea, this.getDomainAxis(), this.getRangeAxis());
            }
        }
    }

    protected void drawDomainMarkers(Canvas canvas, RectShape dataArea, int index, Layer layer) {
        CategoryItemRenderer r = this.getRenderer(index);
        if (r == null) {
            return;
        }
        Collection markers = this.getDomainMarkers(index, layer);
        CategoryAxis axis = this.getDomainAxisForDataset(index);
        if (markers != null && axis != null) {
            for (CategoryMarker marker : markers) {
                r.drawDomainMarker(canvas, this, axis, marker, dataArea);
            }
        }
    }

    protected void drawRangeMarkers(Canvas canvas, RectShape dataArea, int index, Layer layer) {
        CategoryItemRenderer r = this.getRenderer(index);
        if (r == null) {
            return;
        }
        Collection markers = this.getRangeMarkers(index, layer);
        ValueAxis axis = this.getRangeAxisForDataset(index);
        if (markers != null && axis != null) {
            for (Marker marker : markers) {
                r.drawRangeMarker(canvas, this, axis, marker, dataArea);
            }
        }
    }

    protected void drawRangeLine(Canvas canvas, RectShape dataArea, double value, float stroke, Paint paint) {
        double java2D = this.getRangeAxis().valueToJava2D(value, dataArea, this.getRangeAxisEdge());
        LineShape line = null;
        if (this.orientation == PlotOrientation.HORIZONTAL) {
            line = new LineShape(java2D, (double)dataArea.getMinY(), java2D, (double)dataArea.getMaxY());
        } else if (this.orientation == PlotOrientation.VERTICAL) {
            line = new LineShape((double)dataArea.getMinX(), java2D, (double)dataArea.getMaxX(), java2D);
        }
        paint.setStrokeWidth(stroke);
        canvas.drawLine(line.getX1(), line.getY1(), line.getX2(), line.getY2(), paint);
    }

    protected void drawDomainCrosshair(Canvas canvas, RectShape dataArea, PlotOrientation orientation, int datasetIndex, Comparable rowKey, Comparable columnKey, float stroke, PaintType paintType, PathEffect effect) {
        CategoryDataset dataset = this.getDataset(datasetIndex);
        CategoryAxis axis = this.getDomainAxisForDataset(datasetIndex);
        CategoryItemRenderer renderer = this.getRenderer(datasetIndex);
        LineShape line = null;
        if (orientation == PlotOrientation.VERTICAL) {
            double xx = renderer.getItemMiddle(rowKey, columnKey, dataset, axis, dataArea, RectangleEdge.BOTTOM);
            line = new LineShape(xx, (double)dataArea.getMinY(), xx, (double)dataArea.getMaxY());
        } else {
            double yy = renderer.getItemMiddle(rowKey, columnKey, dataset, axis, dataArea, RectangleEdge.LEFT);
            line = new LineShape((double)dataArea.getMinX(), yy, (double)dataArea.getMaxX(), yy);
        }
        Paint paint = PaintUtility.createPaint(paintType, stroke, effect);
        canvas.drawLine(line.getX1(), line.getY1(), line.getX2(), line.getY2(), paint);
    }

    protected void drawRangeCrosshair(Canvas canvas, RectShape dataArea, PlotOrientation orientation, double value, ValueAxis axis, float stroke, PaintType paintType, PathEffect effect) {
        if (!axis.getRange().contains(value)) {
            return;
        }
        LineShape line = null;
        if (orientation == PlotOrientation.HORIZONTAL) {
            double xx = axis.valueToJava2D(value, dataArea, RectangleEdge.BOTTOM);
            line = new LineShape(xx, (double)dataArea.getMinY(), xx, (double)dataArea.getMaxY());
        } else {
            double yy = axis.valueToJava2D(value, dataArea, RectangleEdge.LEFT);
            line = new LineShape((double)dataArea.getMinX(), yy, (double)dataArea.getMaxX(), yy);
        }
        Paint paint = PaintUtility.createPaint(paintType, stroke, effect);
        canvas.drawLine(line.getX1(), line.getY1(), line.getX2(), line.getY2(), paint);
    }

    public Range getDataRange(ValueAxis axis) {
        Range result = null;
        ArrayList mappedDatasets = new ArrayList();
        int rangeIndex = this.rangeAxes.indexOf(axis);
        if (rangeIndex >= 0) {
            mappedDatasets.addAll(this.datasetsMappedToRangeAxis(rangeIndex));
        } else if (axis == this.getRangeAxis()) {
            mappedDatasets.addAll(this.datasetsMappedToRangeAxis(0));
        }
        for (CategoryDataset d : mappedDatasets) {
            CategoryItemRenderer r = this.getRendererForDataset(d);
            if (r == null) continue;
            result = Range.combine(result, r.findRangeBounds(d));
        }
        return result;
    }

    private List datasetsMappedToDomainAxis(int axisIndex) {
        Integer key = new Integer(axisIndex);
        ArrayList<CategoryDataset> result = new ArrayList<CategoryDataset>();
        int i = 0;
        while (i < this.datasets.size()) {
            List mappedAxes = (List)this.datasetToDomainAxesMap.get(new Integer(i));
            CategoryDataset dataset = (CategoryDataset)this.datasets.get(i);
            if (mappedAxes == null) {
                if (key.equals(ZERO) && dataset != null) {
                    result.add(dataset);
                }
            } else if (mappedAxes.contains(key) && dataset != null) {
                result.add(dataset);
            }
            ++i;
        }
        return result;
    }

    private List datasetsMappedToRangeAxis(int index) {
        Integer key = new Integer(index);
        ArrayList<Object> result = new ArrayList<Object>();
        int i = 0;
        while (i < this.datasets.size()) {
            List mappedAxes = (List)this.datasetToRangeAxesMap.get(new Integer(i));
            if (mappedAxes == null) {
                if (key.equals(ZERO)) {
                    result.add(this.datasets.get(i));
                }
            } else if (mappedAxes.contains(key)) {
                result.add(this.datasets.get(i));
            }
            ++i;
        }
        return result;
    }

    public int getWeight() {
        return this.weight;
    }

    public void setWeight(int weight) {
        this.weight = weight;
        this.fireChangeEvent();
    }

    public AxisSpace getFixedDomainAxisSpace() {
        return this.fixedDomainAxisSpace;
    }

    public void setFixedDomainAxisSpace(AxisSpace space) {
        this.setFixedDomainAxisSpace(space, true);
    }

    public void setFixedDomainAxisSpace(AxisSpace space, boolean notify) {
        this.fixedDomainAxisSpace = space;
        if (notify) {
            this.fireChangeEvent();
        }
    }

    public AxisSpace getFixedRangeAxisSpace() {
        return this.fixedRangeAxisSpace;
    }

    public void setFixedRangeAxisSpace(AxisSpace space) {
        this.setFixedRangeAxisSpace(space, true);
    }

    public void setFixedRangeAxisSpace(AxisSpace space, boolean notify) {
        this.fixedRangeAxisSpace = space;
        if (notify) {
            this.fireChangeEvent();
        }
    }

    public List getCategories() {
        List result = null;
        if (this.getDataset() != null) {
            result = Collections.unmodifiableList(this.getDataset().getColumnKeys());
        }
        return result;
    }

    public List getCategoriesForAxis(CategoryAxis axis) {
        ArrayList<Comparable> result = new ArrayList<Comparable>();
        int axisIndex = this.domainAxes.indexOf(axis);
        List datasets = this.datasetsMappedToDomainAxis(axisIndex);
        for (CategoryDataset dataset : datasets) {
            int i = 0;
            while (i < dataset.getColumnCount()) {
                Comparable category = dataset.getColumnKey(i);
                if (!result.contains(category)) {
                    result.add(category);
                }
                ++i;
            }
        }
        return result;
    }

    public boolean getDrawSharedDomainAxis() {
        return this.drawSharedDomainAxis;
    }

    public void setDrawSharedDomainAxis(boolean draw) {
        this.drawSharedDomainAxis = draw;
        this.fireChangeEvent();
    }

    public boolean isDomainPannable() {
        return false;
    }

    public boolean isRangePannable() {
        return this.rangePannable;
    }

    public void setRangePannable(boolean pannable) {
        this.rangePannable = pannable;
    }

    public void panDomainAxes(double percent, PlotRenderingInfo info, PointF source) {
    }

    public void panRangeAxes(double percent, PlotRenderingInfo info, PointF source) {
        if (!this.isRangePannable()) {
            return;
        }
        int rangeAxisCount = this.getRangeAxisCount();
        int i = 0;
        while (i < rangeAxisCount) {
            ValueAxis axis = this.getRangeAxis(i);
            if (axis != null) {
                double length = axis.getRange().getLength();
                double adj = percent * length;
                if (axis.isInverted()) {
                    adj = -adj;
                }
                axis.setRange(axis.getLowerBound() + adj, axis.getUpperBound() + adj);
            }
            ++i;
        }
    }

    public boolean isDomainZoomable() {
        return false;
    }

    public boolean isRangeZoomable() {
        return true;
    }

    public void zoomDomainAxes(double factor, PlotRenderingInfo state, PointF source) {
    }

    public void zoomDomainAxes(double lowerPercent, double upperPercent, PlotRenderingInfo state, PointF source) {
    }

    public void zoomDomainAxes(double factor, PlotRenderingInfo info, PointF source, boolean useAnchor) {
    }

    public void zoomRangeAxes(double factor, PlotRenderingInfo state, PointF source) {
        this.zoomRangeAxes(factor, state, source, false);
    }

    public void zoomRangeAxes(double factor, PlotRenderingInfo info, PointF source, boolean useAnchor) {
        int i = 0;
        while (i < this.rangeAxes.size()) {
            ValueAxis rangeAxis = (ValueAxis)this.rangeAxes.get(i);
            if (rangeAxis != null) {
                if (useAnchor) {
                    double sourceY = source.y;
                    if (this.orientation == PlotOrientation.HORIZONTAL) {
                        sourceY = source.x;
                    }
                    double anchorY = rangeAxis.java2DToValue(sourceY, info.getDataArea(), this.getRangeAxisEdge());
                    rangeAxis.resizeRange2(factor, anchorY);
                } else {
                    rangeAxis.resizeRange(factor);
                }
            }
            ++i;
        }
    }

    public void zoomRangeAxes(double lowerPercent, double upperPercent, PlotRenderingInfo state, PointF source) {
        int i = 0;
        while (i < this.rangeAxes.size()) {
            ValueAxis rangeAxis = (ValueAxis)this.rangeAxes.get(i);
            if (rangeAxis != null) {
                rangeAxis.zoomRange(lowerPercent, upperPercent);
            }
            ++i;
        }
    }

    public double getAnchorValue() {
        return this.anchorValue;
    }

    public void setAnchorValue(double value) {
        this.setAnchorValue(value, true);
    }

    public void setAnchorValue(double value, boolean notify) {
        this.anchorValue = value;
        if (notify) {
            this.fireChangeEvent();
        }
    }

    public boolean isDomainMovable() {
        return false;
    }

    public boolean isRangeMovable() {
        return true;
    }

    public void moveDomainAxes(double movePercent, PlotRenderingInfo info, PointF source) {
    }

    public void moveRangeAxes(double movePercent, PlotRenderingInfo info, PointF source) {
        int i = 0;
        while (i < this.rangeAxes.size()) {
            ValueAxis rangeAxis = (ValueAxis)this.rangeAxes.get(i);
            if (rangeAxis != null) {
                rangeAxis.moveRange(movePercent);
            }
            ++i;
        }
    }
}

