/*
 * Decompiled with CFR 0.152.
 */
package org.afree.chart.axis;

import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.PointF;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.afree.chart.axis.Axis;
import org.afree.chart.axis.AxisSpace;
import org.afree.chart.axis.AxisState;
import org.afree.chart.axis.CategoryAnchor;
import org.afree.chart.axis.CategoryLabelPosition;
import org.afree.chart.axis.CategoryLabelPositions;
import org.afree.chart.axis.CategoryLabelWidthType;
import org.afree.chart.axis.CategoryTick;
import org.afree.chart.entity.CategoryLabelEntity;
import org.afree.chart.entity.EntityCollection;
import org.afree.chart.event.AxisChangeEvent;
import org.afree.chart.plot.CategoryPlot;
import org.afree.chart.plot.Plot;
import org.afree.chart.plot.PlotRenderingInfo;
import org.afree.chart.text.G2TextMeasurer;
import org.afree.chart.text.TextBlock;
import org.afree.chart.text.TextUtilities;
import org.afree.data.category.CategoryDataset;
import org.afree.graphics.PaintType;
import org.afree.graphics.PaintUtility;
import org.afree.graphics.geom.Font;
import org.afree.graphics.geom.LineShape;
import org.afree.graphics.geom.RectShape;
import org.afree.graphics.geom.Shape;
import org.afree.ui.RectangleAnchor;
import org.afree.ui.RectangleEdge;
import org.afree.ui.RectangleInsets;
import org.afree.ui.Size2D;
import org.afree.util.ShapeUtilities;

public class CategoryAxis
extends Axis
implements Cloneable,
Serializable {
    private static final long serialVersionUID = 5886554608114265863L;
    public static final double DEFAULT_AXIS_MARGIN = 0.05;
    public static final double DEFAULT_CATEGORY_MARGIN = 0.2;
    private double lowerMargin = 0.05;
    private double upperMargin = 0.05;
    private double categoryMargin = 0.2;
    private int maximumCategoryLabelLines = 1;
    private float maximumCategoryLabelWidthRatio = 0.0f;
    private int categoryLabelPositionOffset = 4;
    private CategoryLabelPositions categoryLabelPositions = CategoryLabelPositions.STANDARD;
    private Map tickLabelFontMap = new HashMap();
    private transient Map tickLabelPaintTypeMap = new HashMap();
    private Map categoryLabelToolTips = new HashMap();

    public CategoryAxis() {
        this(null);
    }

    public CategoryAxis(String label) {
        super(label);
    }

    public double getLowerMargin() {
        return this.lowerMargin;
    }

    public void setLowerMargin(double margin) {
        this.lowerMargin = margin;
        this.notifyListeners(new AxisChangeEvent(this));
    }

    public double getUpperMargin() {
        return this.upperMargin;
    }

    public void setUpperMargin(double margin) {
        this.upperMargin = margin;
        this.notifyListeners(new AxisChangeEvent(this));
    }

    public double getCategoryMargin() {
        return this.categoryMargin;
    }

    public void setCategoryMargin(double margin) {
        this.categoryMargin = margin;
        this.notifyListeners(new AxisChangeEvent(this));
    }

    public int getMaximumCategoryLabelLines() {
        return this.maximumCategoryLabelLines;
    }

    public void setMaximumCategoryLabelLines(int lines) {
        this.maximumCategoryLabelLines = lines;
        this.notifyListeners(new AxisChangeEvent(this));
    }

    public float getMaximumCategoryLabelWidthRatio() {
        return this.maximumCategoryLabelWidthRatio;
    }

    public void setMaximumCategoryLabelWidthRatio(float ratio) {
        this.maximumCategoryLabelWidthRatio = ratio;
        this.notifyListeners(new AxisChangeEvent(this));
    }

    public int getCategoryLabelPositionOffset() {
        return this.categoryLabelPositionOffset;
    }

    public void setCategoryLabelPositionOffset(int offset) {
        this.categoryLabelPositionOffset = offset;
        this.notifyListeners(new AxisChangeEvent(this));
    }

    public CategoryLabelPositions getCategoryLabelPositions() {
        return this.categoryLabelPositions;
    }

    public void setCategoryLabelPositions(CategoryLabelPositions positions) {
        if (positions == null) {
            throw new IllegalArgumentException("Null 'positions' argument.");
        }
        this.categoryLabelPositions = positions;
        this.notifyListeners(new AxisChangeEvent(this));
    }

    public Font getTickLabelFont(Comparable category) {
        if (category == null) {
            throw new IllegalArgumentException("Null 'category' argument.");
        }
        Font result = (Font)this.tickLabelFontMap.get(category);
        if (result == null) {
            result = this.getTickLabelFont();
        }
        return result;
    }

    public void setTickLabelFont(Comparable category, Font font) {
        if (category == null) {
            throw new IllegalArgumentException("Null 'category' argument.");
        }
        if (font == null) {
            this.tickLabelFontMap.remove(category);
        } else {
            this.tickLabelFontMap.put(category, font);
        }
        this.notifyListeners(new AxisChangeEvent(this));
    }

    public PaintType getTickLabelPaintType(Comparable category) {
        if (category == null) {
            throw new IllegalArgumentException("Null 'category' argument.");
        }
        PaintType result = (PaintType)this.tickLabelPaintTypeMap.get(category);
        if (result == null) {
            result = this.getTickLabelPaintType();
        }
        return result;
    }

    public void setTickLabelPaintType(Comparable category, PaintType paintType) {
        if (category == null) {
            throw new IllegalArgumentException("Null 'category' argument.");
        }
        if (paintType == null) {
            this.tickLabelPaintTypeMap.remove(category);
        } else {
            this.tickLabelPaintTypeMap.put(category, paintType);
        }
        this.notifyListeners(new AxisChangeEvent(this));
    }

    public void addCategoryLabelToolTip(Comparable category, String tooltip) {
        if (category == null) {
            throw new IllegalArgumentException("Null 'category' argument.");
        }
        this.categoryLabelToolTips.put(category, tooltip);
        this.notifyListeners(new AxisChangeEvent(this));
    }

    public String getCategoryLabelToolTip(Comparable category) {
        if (category == null) {
            throw new IllegalArgumentException("Null 'category' argument.");
        }
        return (String)this.categoryLabelToolTips.get(category);
    }

    public void removeCategoryLabelToolTip(Comparable category) {
        if (category == null) {
            throw new IllegalArgumentException("Null 'category' argument.");
        }
        this.categoryLabelToolTips.remove(category);
        this.notifyListeners(new AxisChangeEvent(this));
    }

    public void clearCategoryLabelToolTips() {
        this.categoryLabelToolTips.clear();
        this.notifyListeners(new AxisChangeEvent(this));
    }

    public double getCategoryJava2DCoordinate(CategoryAnchor anchor, int category, int categoryCount, RectShape area, RectangleEdge edge) {
        double result = 0.0;
        if (anchor == CategoryAnchor.START) {
            result = this.getCategoryStart(category, categoryCount, area, edge);
        } else if (anchor == CategoryAnchor.MIDDLE) {
            result = this.getCategoryMiddle(category, categoryCount, area, edge);
        } else if (anchor == CategoryAnchor.END) {
            result = this.getCategoryEnd(category, categoryCount, area, edge);
        }
        return result;
    }

    public double getCategoryStart(int category, int categoryCount, RectShape area, RectangleEdge edge) {
        double result = 0.0;
        if (edge == RectangleEdge.TOP || edge == RectangleEdge.BOTTOM) {
            result = (double)area.getX() + (double)area.getWidth() * this.getLowerMargin();
        } else if (edge == RectangleEdge.LEFT || edge == RectangleEdge.RIGHT) {
            result = (double)area.getMinY() + (double)area.getHeight() * this.getLowerMargin();
        }
        double categorySize = this.calculateCategorySize(categoryCount, area, edge);
        double categoryGapWidth = this.calculateCategoryGapSize(categoryCount, area, edge);
        return result += (double)category * (categorySize + categoryGapWidth);
    }

    public double getCategoryMiddle(int category, int categoryCount, RectShape area, RectangleEdge edge) {
        if (category < 0 || category >= categoryCount) {
            throw new IllegalArgumentException("Invalid category index: " + category);
        }
        return this.getCategoryStart(category, categoryCount, area, edge) + this.calculateCategorySize(categoryCount, area, edge) / 2.0;
    }

    public double getCategoryEnd(int category, int categoryCount, RectShape area, RectangleEdge edge) {
        return this.getCategoryStart(category, categoryCount, area, edge) + this.calculateCategorySize(categoryCount, area, edge);
    }

    public double getCategoryMiddle(Comparable category, List categories, RectShape area, RectangleEdge edge) {
        if (categories == null) {
            throw new IllegalArgumentException("Null 'categories' argument.");
        }
        int categoryIndex = categories.indexOf(category);
        int categoryCount = categories.size();
        return this.getCategoryMiddle(categoryIndex, categoryCount, area, edge);
    }

    public double getCategorySeriesMiddle(Comparable category, Comparable seriesKey, CategoryDataset dataset, double itemMargin, RectShape area, RectangleEdge edge) {
        int categoryIndex = dataset.getColumnIndex(category);
        int categoryCount = dataset.getColumnCount();
        int seriesIndex = dataset.getRowIndex(seriesKey);
        int seriesCount = dataset.getRowCount();
        double start = this.getCategoryStart(categoryIndex, categoryCount, area, edge);
        double end = this.getCategoryEnd(categoryIndex, categoryCount, area, edge);
        double width = end - start;
        if (seriesCount == 1) {
            return start + width / 2.0;
        }
        double gap = width * itemMargin / (double)(seriesCount - 1);
        double ww = width * (1.0 - itemMargin) / (double)seriesCount;
        return start + (double)seriesIndex * (ww + gap) + ww / 2.0;
    }

    public double getCategorySeriesMiddle(int categoryIndex, int categoryCount, int seriesIndex, int seriesCount, double itemMargin, RectShape area, RectangleEdge edge) {
        double start = this.getCategoryStart(categoryIndex, categoryCount, area, edge);
        double end = this.getCategoryEnd(categoryIndex, categoryCount, area, edge);
        double width = end - start;
        if (seriesCount == 1) {
            return start + width / 2.0;
        }
        double gap = width * itemMargin / (double)(seriesCount - 1);
        double ww = width * (1.0 - itemMargin) / (double)seriesCount;
        return start + (double)seriesIndex * (ww + gap) + ww / 2.0;
    }

    protected double calculateCategorySize(int categoryCount, RectShape area, RectangleEdge edge) {
        double result = 0.0;
        double available = 0.0;
        if (edge == RectangleEdge.TOP || edge == RectangleEdge.BOTTOM) {
            available = area.getWidth();
        } else if (edge == RectangleEdge.LEFT || edge == RectangleEdge.RIGHT) {
            available = area.getHeight();
        }
        if (categoryCount > 1) {
            result = available * (1.0 - this.getLowerMargin() - this.getUpperMargin() - this.getCategoryMargin());
            result /= (double)categoryCount;
        } else {
            result = available * (1.0 - this.getLowerMargin() - this.getUpperMargin());
        }
        return result;
    }

    protected double calculateCategoryGapSize(int categoryCount, RectShape area, RectangleEdge edge) {
        double result = 0.0;
        double available = 0.0;
        if (edge == RectangleEdge.TOP || edge == RectangleEdge.BOTTOM) {
            available = area.getWidth();
        } else if (edge == RectangleEdge.LEFT || edge == RectangleEdge.RIGHT) {
            available = area.getHeight();
        }
        if (categoryCount > 1) {
            result = available * this.getCategoryMargin() / (double)(categoryCount - 1);
        }
        return result;
    }

    public AxisSpace reserveSpace(Canvas canvas, Plot plot, RectShape plotArea, RectangleEdge edge, AxisSpace space) {
        if (space == null) {
            space = new AxisSpace();
        }
        if (!this.isVisible()) {
            return space;
        }
        double tickLabelHeight = 0.0;
        double tickLabelWidth = 0.0;
        if (this.isTickLabelsVisible()) {
            AxisState state = new AxisState();
            this.refreshTicks(canvas, state, plotArea, edge);
            if (edge == RectangleEdge.TOP) {
                tickLabelHeight = state.getMax();
            } else if (edge == RectangleEdge.BOTTOM) {
                tickLabelHeight = state.getMax();
            } else if (edge == RectangleEdge.LEFT) {
                tickLabelWidth = state.getMax();
            } else if (edge == RectangleEdge.RIGHT) {
                tickLabelWidth = state.getMax();
            }
        }
        RectShape labelEnclosure = this.getLabelEnclosure(canvas, edge);
        double labelHeight = 0.0;
        double labelWidth = 0.0;
        if (RectangleEdge.isTopOrBottom(edge)) {
            labelHeight = labelEnclosure.getHeight();
            space.add(labelHeight + tickLabelHeight + (double)this.categoryLabelPositionOffset, edge);
        } else if (RectangleEdge.isLeftOrRight(edge)) {
            labelWidth = labelEnclosure.getWidth();
            space.add(labelWidth + tickLabelWidth + (double)this.categoryLabelPositionOffset, edge);
        }
        return space;
    }

    public void configure() {
    }

    public AxisState draw(Canvas canvas, double cursor, RectShape plotArea, RectShape dataArea, RectangleEdge edge, PlotRenderingInfo plotState) {
        if (!this.isVisible()) {
            return new AxisState(cursor);
        }
        if (this.isAxisLineVisible()) {
            this.drawAxisLine(canvas, cursor, dataArea, edge);
        }
        AxisState state = new AxisState(cursor);
        if (this.isTickMarksVisible()) {
            this.drawTickMarks(canvas, cursor, dataArea, edge, state);
        }
        state = this.drawCategoryLabels(canvas, plotArea, dataArea, edge, state, plotState);
        state = this.drawLabel(this.getLabel(), canvas, plotArea, dataArea, edge, state);
        this.createAndAddEntity(cursor, state, dataArea, edge, plotState);
        return state;
    }

    protected AxisState drawCategoryLabels(Canvas canvas, RectShape plotArea, RectShape dataArea, RectangleEdge edge, AxisState state, PlotRenderingInfo plotState) {
        if (state == null) {
            throw new IllegalArgumentException("Null 'state' argument.");
        }
        if (this.isTickLabelsVisible()) {
            List ticks = this.refreshTicks(canvas, state, plotArea, edge);
            state.setTicks(ticks);
            int categoryIndex = 0;
            for (CategoryTick tick : ticks) {
                EntityCollection entities;
                CategoryLabelPosition position = this.categoryLabelPositions.getLabelPosition(edge);
                double x0 = 0.0;
                double x1 = 0.0;
                double y0 = 0.0;
                double y1 = 0.0;
                if (edge == RectangleEdge.TOP) {
                    x0 = this.getCategoryStart(categoryIndex, ticks.size(), dataArea, edge);
                    x1 = this.getCategoryEnd(categoryIndex, ticks.size(), dataArea, edge);
                    y1 = state.getCursor() - (double)this.categoryLabelPositionOffset;
                    y0 = y1 - state.getMax();
                } else if (edge == RectangleEdge.BOTTOM) {
                    x0 = this.getCategoryStart(categoryIndex, ticks.size(), dataArea, edge);
                    x1 = this.getCategoryEnd(categoryIndex, ticks.size(), dataArea, edge);
                    y0 = state.getCursor() + (double)this.categoryLabelPositionOffset;
                    y1 = y0 + state.getMax();
                } else if (edge == RectangleEdge.LEFT) {
                    y0 = this.getCategoryStart(categoryIndex, ticks.size(), dataArea, edge);
                    y1 = this.getCategoryEnd(categoryIndex, ticks.size(), dataArea, edge);
                    x1 = state.getCursor() - (double)this.categoryLabelPositionOffset - 6.0;
                    x0 = x1 - state.getMax() - 6.0;
                } else if (edge == RectangleEdge.RIGHT) {
                    y0 = this.getCategoryStart(categoryIndex, ticks.size(), dataArea, edge);
                    y1 = this.getCategoryEnd(categoryIndex, ticks.size(), dataArea, edge);
                    x0 = state.getCursor() + (double)this.categoryLabelPositionOffset;
                    x1 = x0 - state.getMax();
                }
                RectShape area = new RectShape(x0, y0, x1 - x0, y1 - y0);
                PointF anchorPoint = RectangleAnchor.coordinates(area, position.getCategoryAnchor());
                TextBlock block = tick.getLabel();
                block.draw(canvas, anchorPoint.x, anchorPoint.y, position.getLabelAnchor(), anchorPoint.x, anchorPoint.y, position.getAngle());
                Shape bounds = block.calculateBounds(canvas, anchorPoint.x, anchorPoint.y, position.getLabelAnchor(), anchorPoint.x, anchorPoint.y, position.getAngle());
                if (plotState != null && plotState.getOwner() != null && (entities = plotState.getOwner().getEntityCollection()) != null) {
                    String tooltip = this.getCategoryLabelToolTip(tick.getCategory());
                    entities.add(new CategoryLabelEntity(tick.getCategory(), bounds, tooltip, null));
                }
                ++categoryIndex;
            }
            if (edge.equals(RectangleEdge.TOP)) {
                double h = state.getMax() + (double)this.categoryLabelPositionOffset;
                state.cursorUp(h);
            } else if (edge.equals(RectangleEdge.BOTTOM)) {
                double h = state.getMax() + (double)this.categoryLabelPositionOffset;
                state.cursorDown(h);
            } else if (edge == RectangleEdge.LEFT) {
                double w = state.getMax() + (double)this.categoryLabelPositionOffset;
                state.cursorLeft(w);
            } else if (edge == RectangleEdge.RIGHT) {
                double w = state.getMax() + (double)this.categoryLabelPositionOffset;
                state.cursorRight(w);
            }
        }
        return state;
    }

    public List refreshTicks(Canvas canvas, AxisState state, RectShape dataArea, RectangleEdge edge) {
        ArrayList<CategoryTick> ticks = new ArrayList<CategoryTick>();
        if ((double)dataArea.getHeight() <= 0.0 || (double)dataArea.getWidth() < 0.0) {
            return ticks;
        }
        CategoryPlot plot = (CategoryPlot)this.getPlot();
        List categories = plot.getCategoriesForAxis(this);
        double max = 0.0;
        if (categories != null) {
            CategoryLabelPosition position = this.categoryLabelPositions.getLabelPosition(edge);
            float r = this.maximumCategoryLabelWidthRatio;
            if ((double)r <= 0.0) {
                r = position.getWidthRatio();
            }
            float l = 0.0f;
            l = position.getWidthType() == CategoryLabelWidthType.CATEGORY ? (float)this.calculateCategorySize(categories.size(), dataArea, edge) : (RectangleEdge.isLeftOrRight(edge) ? dataArea.getWidth() : dataArea.getHeight());
            int categoryIndex = 0;
            for (Comparable category : categories) {
                TextBlock label = this.createLabel(category, l * r, edge, canvas);
                if (edge == RectangleEdge.TOP || edge == RectangleEdge.BOTTOM) {
                    max = Math.max(max, this.calculateTextBlockHeight(label, position, canvas));
                } else if (edge == RectangleEdge.LEFT || edge == RectangleEdge.RIGHT) {
                    max = Math.max(max, this.calculateTextBlockWidth(label, position, canvas));
                }
                CategoryTick tick = new CategoryTick(category, label, position.getLabelAnchor(), position.getRotationAnchor(), position.getAngle());
                ticks.add(tick);
                ++categoryIndex;
            }
        }
        state.setMax(max);
        return ticks;
    }

    public void drawTickMarks(Canvas canvas, double cursor, RectShape dataArea, RectangleEdge edge, AxisState state) {
        Plot p = this.getPlot();
        if (p == null) {
            return;
        }
        CategoryPlot plot = (CategoryPlot)p;
        double il = this.getTickMarkInsideLength();
        double ol = this.getTickMarkOutsideLength();
        LineShape line = new LineShape();
        List categories = plot.getCategoriesForAxis(this);
        Paint tickMark = PaintUtility.createPaint(1, this.getTickMarkPaintType(), this.getTickMarkStroke(), this.getTickMarkEffect());
        if (edge.equals(RectangleEdge.TOP)) {
            for (Comparable key : categories) {
                double x = this.getCategoryMiddle(key, categories, dataArea, edge);
                line.setLine(x, cursor, x, cursor + il);
                canvas.drawLine(line.getX1(), line.getY1(), line.getX2(), line.getY2(), tickMark);
                line.setLine(x, cursor, x, cursor - ol);
                canvas.drawLine(line.getX1(), line.getY1(), line.getX2(), line.getY2(), tickMark);
            }
            state.cursorUp(ol);
        } else if (edge.equals(RectangleEdge.BOTTOM)) {
            for (Comparable key : categories) {
                double x = this.getCategoryMiddle(key, categories, dataArea, edge);
                line.setLine(x, cursor, x, cursor - il);
                canvas.drawLine(line.getX1(), line.getY1(), line.getX2(), line.getY2(), tickMark);
                line.setLine(x, cursor, x, cursor + ol);
                canvas.drawLine(line.getX1(), line.getY1(), line.getX2(), line.getY2(), tickMark);
            }
            state.cursorDown(ol);
        } else if (edge.equals(RectangleEdge.LEFT)) {
            for (Comparable key : categories) {
                double y = this.getCategoryMiddle(key, categories, dataArea, edge);
                line.setLine(cursor, y, cursor + il, y);
                canvas.drawLine(line.getX1(), line.getY1(), line.getX2(), line.getY2(), tickMark);
                line.setLine(cursor, y, cursor - ol, y);
                canvas.drawLine(line.getX1(), line.getY1(), line.getX2(), line.getY2(), tickMark);
            }
            state.cursorLeft(ol);
        } else if (edge.equals(RectangleEdge.RIGHT)) {
            for (Comparable key : categories) {
                double y = this.getCategoryMiddle(key, categories, dataArea, edge);
                line.setLine(cursor, y, cursor - il, y);
                canvas.drawLine(line.getX1(), line.getY1(), line.getX2(), line.getY2(), tickMark);
                line.setLine(cursor, y, cursor + ol, y);
                canvas.drawLine(line.getX1(), line.getY1(), line.getX2(), line.getY2(), tickMark);
            }
            state.cursorRight(ol);
        }
    }

    protected TextBlock createLabel(Comparable category, float width, RectangleEdge edge, Canvas canvas) {
        Paint paint = PaintUtility.createPaint(1, this.getLabelPaintType(), this.getLabelFont());
        TextBlock label = TextUtilities.createTextBlock(category.toString(), this.getTickLabelFont(category), this.getTickLabelPaintType(category), width, this.maximumCategoryLabelLines, new G2TextMeasurer(paint));
        return label;
    }

    protected double calculateTextBlockWidth(TextBlock block, CategoryLabelPosition position, Canvas canvas) {
        RectangleInsets insets = this.getTickLabelInsets();
        Size2D size = block.calculateDimensions(canvas);
        RectShape box = new RectShape(0.0, 0.0, size.getWidth(), size.getHeight());
        Shape rotatedBox = ShapeUtilities.rotateShape(box, position.getAngle(), 0.0f, 0.0f);
        RectShape rectShape = new RectShape();
        rotatedBox.getBounds(rectShape);
        double w = (double)rectShape.getWidth() + insets.getLeft() + insets.getRight();
        return w;
    }

    protected double calculateTextBlockHeight(TextBlock block, CategoryLabelPosition position, Canvas canvas) {
        RectangleInsets insets = this.getTickLabelInsets();
        Size2D size = block.calculateDimensions(canvas);
        RectShape box = new RectShape(0.0, 0.0, size.getWidth(), size.getHeight());
        Shape rotatedBox = ShapeUtilities.rotateShape(box, position.getAngle(), 0.0f, 0.0f);
        RectShape rectShape = new RectShape();
        rotatedBox.getBounds(rectShape);
        double h = (double)rectShape.getHeight() + insets.getTop() + insets.getBottom();
        return h;
    }

    public Object clone() throws CloneNotSupportedException {
        CategoryAxis clone = (CategoryAxis)super.clone();
        clone.tickLabelFontMap = new HashMap(this.tickLabelFontMap);
        clone.tickLabelPaintTypeMap = new HashMap(this.tickLabelPaintTypeMap);
        clone.categoryLabelToolTips = new HashMap(this.categoryLabelToolTips);
        return clone;
    }
}

