/*
 * Decompiled with CFR 0.152.
 */
package twitter4j;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import twitter4j.Query;
import twitter4j.QueryResult;
import twitter4j.Tweet;
import twitter4j.TweetJSONImpl;
import twitter4j.TwitterException;
import twitter4j.conf.Configuration;
import twitter4j.internal.http.HttpResponse;
import twitter4j.internal.json.DataObjectFactoryUtil;
import twitter4j.internal.util.ParseUtil;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class QueryResultJSONImpl
implements QueryResult,
Serializable {
    private long sinceId;
    private long maxId;
    private String refreshUrl;
    private int resultsPerPage;
    private String warning;
    private double completedIn;
    private int page;
    private String query;
    private List<Tweet> tweets;
    private static final long serialVersionUID = -9059136565234613286L;

    QueryResultJSONImpl(HttpResponse res, Configuration conf) throws TwitterException {
        JSONObject json = res.asJSONObject();
        try {
            this.sinceId = ParseUtil.getLong("since_id", json);
            this.maxId = ParseUtil.getLong("max_id", json);
            this.refreshUrl = ParseUtil.getUnescapedString("refresh_url", json);
            this.resultsPerPage = ParseUtil.getInt("results_per_page", json);
            this.warning = ParseUtil.getRawString("warning", json);
            this.completedIn = ParseUtil.getDouble("completed_in", json);
            this.page = ParseUtil.getInt("page", json);
            this.query = ParseUtil.getURLDecodedString("query", json);
            JSONArray array = json.getJSONArray("results");
            this.tweets = new ArrayList<Tweet>(array.length());
            if (conf.isJSONStoreEnabled()) {
                DataObjectFactoryUtil.clearThreadLocalMap();
            }
            for (int i = 0; i < array.length(); ++i) {
                JSONObject tweet = array.getJSONObject(i);
                this.tweets.add(new TweetJSONImpl(tweet, conf));
            }
        }
        catch (JSONException jsone) {
            throw new TwitterException(new StringBuffer().append(jsone.getMessage()).append(":").append(json.toString()).toString(), jsone);
        }
    }

    QueryResultJSONImpl(Query query) {
        this.sinceId = query.getSinceId();
        this.resultsPerPage = query.getRpp();
        this.page = query.getPage();
        this.tweets = new ArrayList<Tweet>(0);
    }

    @Override
    public long getSinceId() {
        return this.sinceId;
    }

    @Override
    public long getMaxId() {
        return this.maxId;
    }

    @Override
    public String getRefreshUrl() {
        return this.refreshUrl;
    }

    @Override
    public int getResultsPerPage() {
        return this.resultsPerPage;
    }

    @Override
    public String getWarning() {
        return this.warning;
    }

    @Override
    public double getCompletedIn() {
        return this.completedIn;
    }

    @Override
    public int getPage() {
        return this.page;
    }

    @Override
    public String getQuery() {
        return this.query;
    }

    @Override
    public List<Tweet> getTweets() {
        return this.tweets;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        QueryResult that = (QueryResult)o;
        if (Double.compare(that.getCompletedIn(), this.completedIn) != 0) {
            return false;
        }
        if (this.maxId != that.getMaxId()) {
            return false;
        }
        if (this.page != that.getPage()) {
            return false;
        }
        if (this.resultsPerPage != that.getResultsPerPage()) {
            return false;
        }
        if (this.sinceId != that.getSinceId()) {
            return false;
        }
        if (!this.query.equals(that.getQuery())) {
            return false;
        }
        if (this.refreshUrl != null ? !this.refreshUrl.equals(that.getRefreshUrl()) : that.getRefreshUrl() != null) {
            return false;
        }
        if (this.tweets != null ? !((Object)this.tweets).equals(that.getTweets()) : that.getTweets() != null) {
            return false;
        }
        return !(this.warning != null ? !this.warning.equals(that.getWarning()) : that.getWarning() != null);
    }

    public int hashCode() {
        int result = (int)(this.sinceId ^ this.sinceId >>> 32);
        result = 31 * result + (int)(this.maxId ^ this.maxId >>> 32);
        result = 31 * result + (this.refreshUrl != null ? this.refreshUrl.hashCode() : 0);
        result = 31 * result + this.resultsPerPage;
        result = 31 * result + (this.warning != null ? this.warning.hashCode() : 0);
        long temp = this.completedIn != 0.0 ? Double.doubleToLongBits(this.completedIn) : 0L;
        result = 31 * result + (int)(temp ^ temp >>> 32);
        result = 31 * result + this.page;
        result = 31 * result + this.query.hashCode();
        result = 31 * result + (this.tweets != null ? ((Object)this.tweets).hashCode() : 0);
        return result;
    }

    public String toString() {
        return new StringBuffer().append("QueryResultJSONImpl{sinceId=").append(this.sinceId).append(", maxId=").append(this.maxId).append(", refreshUrl='").append(this.refreshUrl).append('\'').append(", resultsPerPage=").append(this.resultsPerPage).append(", warning='").append(this.warning).append('\'').append(", completedIn=").append(this.completedIn).append(", page=").append(this.page).append(", query='").append(this.query).append('\'').append(", tweets=").append(this.tweets).append('}').toString();
    }
}

