#include	"multi_forward.h"

void	status_on (char call[], char ur_call[], char my_call[], 
		char rpt1_call[], char rpt2_call[]);
void	status_off (char call[]);
int	ja_check (char call[]);
int	mycall2_check (char call2[]);
int	getFifo (struct sockaddr_in addr, char str[]);
void	putFifo (int length, struct sockaddr_in addr, char str[]);

extern  struct  sockaddr_in     in_sock;
extern  socklen_t       len_in_sock;

void    forward_reply (char pkt[])
{
        char    forward_reply_frame[10];
        int     err;
        time_t  atime;

        memset (forward_reply_frame, 0x00, 10);
        memcpy (forward_reply_frame, pkt, 6);
        forward_reply_frame[6] = 'r';

        err = sendto (fwd_sd, forward_reply_frame, 10, 0,
                (struct sockaddr *)&fwd_addr, sizeof(fwd_addr));
        if (err == -1)
        {
                time (&atime);
                fprintf (log_file, "%24.24s sendto (forward reply) error:%s\n",
                        ctime(&atime), strerror(errno));
                fflush (log_file);
        }
}

int	forward_resend (void)
{
	//struct	ModuleTable	*m_pnt;
	int	length;
	time_t	atime;
	//struct	timeval		time_21ms;
	//struct	timeval		cur_time;
	struct	MultiConnectTable	*next;
	int	err;
	struct  area_callsign     *ar_call_next;
	int	ret;

	len_fwd_addr = sizeof (fwd_addr);	
    	length = recvfrom(fwd_sd, &forward_buff, sizeof(forward_buff), 0, 
		(struct sockaddr *)&fwd_addr, &len_fwd_addr);
	if (length < 0) {
               	time(&atime);
               	fprintf (log_file, "%24.24s xchage data Recv. error\n", ctime(&atime));
		fflush (log_file);
        	return FALSE;
    	}

	if (length < 16) return TRUE;

	if (!memcmp(forward_buff.d_packet.id, "DSTR", 4) && (forward_buff.d_packet.sr == 's')) 
	{
		forward_reply((char *)&forward_buff);
	}

        if (!memcmp (&forward_buff.forward_buffer[6], forward_buff_save, length-6)) return TRUE;
        memcpy (forward_buff_save, &forward_buff.forward_buffer[6], length-6);

	if (length > 10)
	{
		if (((forward_buff.d_packet.c & C_MASK) != VOICE)
			&& ((forward_buff.d_packet.c & C_MASK) != POSIT)) return TRUE;
		if ((length == 58) && (forward_buff.d_packet.l[1] == 0x30))
		{
			if (!mycall2_check (forward_buff.d_packet.body.header.mycall_ex)) return TRUE;
			if (!ja_check (forward_buff.d_packet.body.header.mycall)) return TRUE;
			if (!ja_check (forward_buff.d_packet.body.header.rpt1)
				|| !ja_check (forward_buff.d_packet.body.header.rpt2)) return TRUE;
			if (forward_buff.d_packet.c & ZR)
			{
				if (forward_buff.d_packet.body.header.rpt1[7] == 0x20)
					forward_buff.d_packet.body.header.rpt1[7] = 'A';
				if (!memcmp(forward_buff.d_packet.body.header.rpt2, zr_callsign, 7))
				{
                               		ar_call_next = ar_callsign_pnt;
                               		while (ar_call_next)
                               		{
                                     			if (!memcmp (ar_call_next->ar_callsign, forward_buff.d_packet.body.header.rpt1, 8))
                                       		{
							if ((ar_call_next->FrameID[0] == 0x00) && (ar_call_next->FrameID[1] == 0x00))
							{
                                       				memcpy (ar_call_next->FrameID, forward_buff.d_packet.trunk.FrameID, 2);
							}
							goto skip;
                                       		}
                                       		ar_call_next = ar_call_next->next;
                               		}
					goto create;
				}
			}
			else if (forward_buff.d_packet.c & GW) 
			{
				if (forward_buff.d_packet.body.header.rpt2[7] == 0x20)
					forward_buff.d_packet.body.header.rpt2[7] = 'A';
				if (!memcmp(forward_buff.d_packet.body.header.rpt1, zr_callsign, 8))
				{
					ar_call_next = ar_callsign_pnt;
					while (ar_call_next)
					{
						if (!memcmp (ar_call_next->ar_callsign, forward_buff.d_packet.body.header.rpt2, 8))
						{
							if ((ar_call_next->FrameID[0] == 0x00) && (ar_call_next->FrameID[1] == 0x00))
							{
								memcpy (ar_call_next->FrameID, forward_buff.d_packet.trunk.FrameID, 2);
							}
							goto skip;
						}
						ar_call_next = ar_call_next->next;
					}
					goto create;
				}
			}
			return  TRUE;

create:
			ar_call_next =  malloc (sizeof(struct area_callsign));
                       	memset (ar_call_next->ar_callsign, 0x20, 8);
			if (forward_buff.d_packet.c & ZR)
                       		memcpy (ar_call_next->ar_callsign, forward_buff.d_packet.body.header.rpt1, 8);
			else if (forward_buff.d_packet.c & GW)
				memcpy (ar_call_next->ar_callsign, forward_buff.d_packet.body.header.rpt2, 8);
			gettimeofday (&ar_call_next->rep_time, NULL);
			memcpy (ar_call_next->FrameID, forward_buff.d_packet.trunk.FrameID, 2);
			if (ar_callsign_pnt == NULL) 
			{
				ar_callsign_pnt = ar_call_next;
				ar_call_next->next = NULL;
			}
			else
			{
				ar_call_next->next = ar_callsign_pnt;
				ar_callsign_pnt = ar_call_next;
			}
skip:
			time (&ar_call_next->status_time);
			if (forward_buff.d_packet.c & ZR) 
				status_on (forward_buff.d_packet.body.header.rpt1,
					forward_buff.d_packet.body.header.urcall,
					forward_buff.d_packet.body.header.mycall,
					forward_buff.d_packet.body.header.rpt1,
					forward_buff.d_packet.body.header.rpt2);
			else if (forward_buff.d_packet.c & GW) 
				status_on (forward_buff.d_packet.body.header.rpt2,
					forward_buff.d_packet.body.header.urcall,
					forward_buff.d_packet.body.header.mycall,
					forward_buff.d_packet.body.header.rpt1,
					forward_buff.d_packet.body.header.rpt2);
			memcpy (ar_call_next->rf_header, &forward_buff, 58);
			ar_call_next->status = ON;
		}
		else if (((length == 29) && (forward_buff.d_packet.l[1] == 0x13))
			|| ((length == 32) && (forward_buff.d_packet.l[1] == 0x16)))
		{
			ar_call_next = ar_callsign_pnt;
			while (ar_call_next)
			{
				if (!memcmp (ar_call_next->FrameID, forward_buff.d_packet.trunk.FrameID, 2))
				{
					time (&ar_call_next->status_time);
					if ((length == 32) || (forward_buff.d_packet.trunk.FrameSeq & 0x40))
					{
						status_off (ar_call_next->ar_callsign);
						memset (ar_call_next->FrameID, 0x00, 2);
					}
					break;
				}
				ar_call_next = ar_call_next->next;
			}
		}
		forward_buff.d_packet.m[0] = (multi_send_seq >> 8) & 0xff;
		forward_buff.d_packet.m[1] = multi_send_seq & 0xff;
		multi_send_seq++;
		multi_send_seq &= 0xffff;
		if (forward_buff.d_packet.trunk.FrameSeq  == 0x14)
		{
			ar_call_next->rf_header[4] = (multi_send_seq >> 8) & 0xff;
			ar_call_next->rf_header[5] = multi_send_seq & 0xff;
			multi_send_seq++;
			multi_send_seq &= 0xffff;
		}
		next = MultiConnectTablePnt;
		while (next)
		{
			ret = sendto (multi_sd, &forward_buff, length, 0,
				(struct sockaddr *)&next->multi_addr, sizeof(struct sockaddr));
			if (forward_buff.d_packet.trunk.FrameSeq  == 0x14)
			{
				sendto (multi_sd, &ar_call_next->rf_header, 58, 0, 
					(struct sockaddr *)&next->multi_addr, sizeof(struct sockaddr));
			}
			next = next->f_chain;
		}
	}
	return TRUE;
}

int	forward_init(void)
{
	time_t	atime;

	if (fwd_port > 0)
	{
    		// IPv4 UDP socket
		// monitor port
    		if((fwd_sd = socket(AF_INET, SOCK_DGRAM, 0)) < 0)
		{
                	time(&atime);
                	fprintf (log_file, "%24.24s Forward  socket not open\n", ctime(&atime));
			fflush (log_file);
        		return FALSE;	
    		}

        	// 待ち受けるIPとポート番号を設定
        	fwd_addr.sin_family = PF_INET;
        	fwd_addr.sin_port = htons(fwd_port);
        	//fwd_addr.sin_addr.s_addr = INADDR_ANY;
		if (forward_addr[0] == 0x00)
		{
			memset (forward_addr, 0x00, sizeof(forward_addr));
			memcpy (forward_addr, "127.0.0.1", 9);
		}
		fwd_addr.sin_addr.s_addr = inet_addr(forward_addr);

		FD_SET (fwd_sd, &fd_save);

    		// Bind
    		if(bind(fwd_sd, (struct sockaddr *)&fwd_addr, sizeof(fwd_addr)) < 0) {
			time(&atime);
			fprintf (log_file, "%24.24s Forward socket not bind %s\n", 
				ctime(&atime), strerror(errno));
			fflush (log_file);
        		return FALSE;
    		}
	}

	return TRUE;
}

void      multi_connect (void)
{
        int     length;
        time_t  atime;
	struct	MultiConnectTable	*next;
	struct  area_callsign     *ar_call_next;

	len_multi_addr = sizeof(multi_addr);
        length = recvfrom(multi_sd, &multi_buff, sizeof(multi_buff), 0, 
		(struct sockaddr *)&multi_addr, &len_multi_addr);
        if (length < 0) {
                time(&atime);
                fprintf (log_file, "%24.24s Multi forward data Reciv. error\n", ctime(&atime));
		fflush (log_file);
                return;                   // end
        }
	if (length < 16) return;

        time (&atime);
	if (!memcmp (multi_buff.d_packet.id, "HPCH", 4))
	{
		read_hole_punch(&multi_buff, length);
		return;
	}

        if ((length == 40) && (multi_buff.d_packet.id[0] == 0x01) && (multi_buff.d_packet.id[1] == 0x03))
        {
                trust_read( length, &multi_buff);
                return;
        }
	next = MultiConnectTablePnt;
	while (next)
	{
		if (!memcmp (&multi_addr, &next->multi_addr, sizeof (multi_addr))) 
		{
			time (&next->AccessTime);
			goto next;
		}
		next = next->f_chain; 
	}
	next = malloc (sizeof(struct MultiConnectTable));
	next->f_chain = MultiConnectTablePnt;
	memcpy (&next->multi_addr, &multi_addr, sizeof (multi_addr));
	time (&next->AccessTime);
	next->in = 0;
	next->out = 0;
	next->gw = 0;
	next->zr = 0;
	MultiConnectTablePnt = next;
	time (&atime);
	fprintf (log_file, "%24.24s Connect from %s(%d)\n", ctime(&atime),
		inet_ntoa (multi_addr.sin_addr), multi_addr.sin_port);
	fflush (log_file);

next:
	if (!memcmp (multi_buff.d_packet.id, "DSTR", 4))
	{
		if (((multi_buff.d_packet.c & C_MASK) == VOICE)
			|| ((multi_buff.d_packet.c & C_MASK) == POSIT))
		{
			if ((length == 58) && (multi_buff.d_packet.l[1] == 0x30))
			{
				send_inquire(multi_buff.d_packet.body.header.mycall);
			}
			if (trust_status != SKIP) putFifo (length, multi_addr, multi_buff.multi_buffer);
		}
	}
}

void	multi_read()
{
        int     length;
        time_t  atime;
        //char  multi_buff[1024];
        struct  MultiConnectTable       *next;
        struct  area_callsign     *ar_call_next;

	length = getFifo (multi_addr, multi_buff.multi_buffer);

        if ((length == 58) && (multi_buff.d_packet.l[1] == 0x30))
        {
		if (!mycall2_check (multi_buff.d_packet.body.header.mycall_ex)) return;
		if (!ja_check (multi_buff.d_packet.body.header.mycall)) return;
		if (!ja_check (multi_buff.d_packet.body.header.rpt1) 
			|| !ja_check (multi_buff.d_packet.body.header.rpt2)) return;
		if (memcmp (zr_callsign, multi_buff.d_packet.body.header.rpt2, 7)) return;
		ar_call_next = ar_callsign_pnt;
                while (ar_call_next)
                {
                       	if (!memcmp (ar_call_next->ar_callsign, multi_buff.d_packet.body.header.rpt1, 8))
                        {
                               	if ((ar_call_next->FrameID[0] == 0x00) && (ar_call_next->FrameID[1] == 0x00))
                                {
                                       	memcpy (ar_call_next->FrameID, multi_buff.d_packet.trunk.FrameID, 2);
					//memcpy (&ar_call_next->in_addr, &multi_addr, sizeof(struct sockaddr_in));
                                        status_on (multi_buff.d_packet.body.header.rpt1,
						multi_buff.d_packet.body.header.urcall,
						multi_buff.d_packet.body.header.mycall,
						multi_buff.d_packet.body.header.rpt1,
						multi_buff.d_packet.body.header.rpt2);
					time (&ar_call_next->status_time);
					memcpy (ar_call_next->rf_header, &multi_buff, 58);
                                }
				goto send;
                        }
                        ar_call_next = ar_call_next->next;
              	}
		if (ar_call_next == NULL) return; 
	}
        else if (((length == 29) && (multi_buff.d_packet.l[1] == 0x13))
       		|| ((length == 32) && (multi_buff.d_packet.l[1] == 0x16)))
        {
		goto send;
        }
	else if ((length == 26) && (multi_buff.d_packet.l[1] == 0x10))
	{
		sendto (fwd_sd, &multi_buff, length, 0,
			(struct sockaddr *)&fwd_addr, sizeof(fwd_addr));
	}
	return;
send:
	ar_call_next = ar_callsign_pnt;
	while (ar_call_next)
	{
		if (!memcmp (ar_call_next->FrameID, multi_buff.d_packet.trunk.FrameID, 2))
		//if (!memcmp (ar_call_next->FrameID, &multi_buff[14], 2)
		//	&& !memcmp (&ar_call_next->in_addr, &multi_addr, sizeof(struct sockaddr_in)))
		{
			multi_buff.d_packet.c |= FWD;
			sendto (fwd_sd,  &multi_buff, length, 0,
				(struct sockaddr *)&fwd_addr, sizeof(fwd_addr));
                	multi_buff.d_packet.m[0] = (multi_send_seq >> 8) & 0xff;
                	multi_buff.d_packet.m[1] = multi_send_seq & 0xff;
                	multi_send_seq++;
                	multi_send_seq &= 0xffff;
                	if (forward_buff.d_packet.trunk.FrameSeq  == 0x14)
                	{
                        	ar_call_next->rf_header[4] = (multi_send_seq >> 8) & 0xff;
                        	ar_call_next->rf_header[5] = multi_send_seq & 0xff;
                        	multi_send_seq++;
                        	multi_send_seq &= 0xffff;
                	}
			next = MultiConnectTablePnt;
			while (next)
			{
				if (memcmp (&next->multi_addr, &multi_addr, sizeof(multi_addr)))
				{
					sendto (multi_sd, &multi_buff, length, 0,
						(struct sockaddr *)&next->multi_addr,
				 		sizeof(struct sockaddr));
                       			if ((multi_buff.d_packet.trunk.FrameSeq == 0x14) && ar_call_next)
                       			{
                               			sendto (multi_sd, &ar_call_next->rf_header, 58, 0,
                              				(struct sockaddr *)&next->multi_addr, sizeof(struct sockaddr));
                       			}
					next->out++;
				}
				else
				{
					next->in++;
					if (multi_buff.d_packet.c & GW) next->gw++;
					if (multi_buff.d_packet.c & ZR) next->zr++;
				}
				next = next->f_chain;
			}
                        if ((length == 32) || (multi_buff.d_packet.trunk.FrameSeq & 0x40))
                        {
                               	status_off (ar_call_next->ar_callsign);
                                memset (ar_call_next->FrameID, 0x00, 2);
                        }
			return;
		}	
		ar_call_next = ar_call_next->next;
	}
        return;
}
