#include	"multi_forward.h"

int	read_config(int argc, char **argv)
{
	char	buff[256];
	char	*delmi = "=\n\r\t\0";
	char	*pnt;
	char	*p;
	int	n;
	time_t	atime;
	int	false_ret;

	FILE	*config_file;
	
	if (argc == 2)
	{
		config_file = fopen (argv[1], "r");
		if (!config_file)
		{
			time(&atime);
			fprintf (log_file, "%24.24s config file not found (%s)\n", ctime(&atime), argv[1]);
			fflush (log_file);
			return FALSE;
		}
	} 
	else
	{
		config_file = fopen (CONFIG_FILE,"r");
		if (!config_file)
		{
			time(&atime);
			fprintf (log_file, "%24.24s config file not found (%s)\n", 
						ctime(&atime), CONFIG_FILE);
			fflush (log_file);
			return FALSE;
		}
	}

	while (fgets (buff, 255, config_file))
	{
		if (buff[0] != '#')
		{
			n = 0;
			while (buff[n] == 0x20) n++;
			p = strtok(&buff[n], delmi);
			if (p != NULL)
			{
				pnt = strtok(NULL, delmi);
	
				if (!memcmp (p, "FORWARD_PORT", 12))
				{
					fwd_port = atoi (pnt);
				}
				else if (!memcmp (p, "FORWARD_ADDR", 12))
				{
					memset (forward_addr, 0x00, sizeof(forward_addr));
					memcpy (forward_addr, pnt, sizeof(pnt));
				}
				else if (!memcmp (p, "MULTI_CONNECT_PORT", 18))
				{
					multi_port = atoi (pnt);
				}
				else if (!memcmp (p, "DEBUG", 5))
				{
					debug_sw = atoi(pnt);
				}
				else if (!memcmp (p, "HTTP_PORT", 9))
				{
					http_port = atoi (pnt);
				}
				else
				{
					time (&atime);
					fprintf (log_file, "%24.24s Error on config file : %s\n",ctime(&atime), buff);
					fflush (log_file);
				}
			}
		}
	}

	fclose (config_file);

	false_ret = FALSE;
	time (&atime);
	if (fwd_port <= 0)
	{
		fprintf (log_file, "%24.24s Forward  port not assign.\n", ctime(&atime));
		false_ret = TRUE;
		fflush (log_file);
	}

	if (false_ret) return FALSE;
	return TRUE;
	
}

