#include	"multi_forward.h"

void	dsgwd_conf_read (void)
{
	char	buff[256];
	char	*delmi = "=\n\r\t\0";
	char	*pnt;
	char	*p;
	int	len;
	int	n;
	time_t	atime;

	FILE	*dsgwd_conf_file;
	
	dsgwd_conf_file = fopen (DSGWD_CONF, "r");
	if (!dsgwd_conf_file)
	{
		time(&atime);
		fprintf (log_file, "%24.24s dsgwd config file not found (%s)\n", 
					ctime(&atime), DSGWD_CONF);
		fflush (log_file);
		return;
	}

	while (fgets (buff, 255, dsgwd_conf_file))
	{
		if (buff[0] != '#')
		{
			n = 0;
			while (buff[n] == 0x20) n++;
			p = strtok(&buff[n], delmi);
			if (p != NULL)
			{
				pnt = strtok(NULL, delmi);

				if (!memcmp (p, "ZR_CALLSIGN", 11))
                                {
                                        memset (zr_callsign, 0x20, 8);
                                        len = strlen(pnt);
                                        if (len > 7) len = 7;
                                        memcpy (zr_callsign, pnt, len);
					zr_callsign[7] = 'G';
				}
				else if (!memcmp (p, "MGSV_ADDR", 9))
				{
					memset (trust_server, 0x00, sizeof(trust_server));
					memcpy (trust_server, pnt, strlen(pnt));
				}
				else if (!memcmp (p, "MGSV_PORT", 9))
				{
					trust_port = atoi (pnt);
				} 
			
			}
		}
	}
	fclose (dsgwd_conf_file);
}


