/**
 * MOA Text v0.1.0 - Mouse Over Animation for Text in jQuery
 * Written by Osamu AKAMATSU (Bitmeister Inc.)
 * 
 * Copyright (c) Bitmeister Inc.
 * 
 * This software is under the MIT license (MIT-LICENSE.txt).
 *
 * http://sourceforge.jp/projects/moatext/
 *
 * Bitmeister Inc.
 * http://www.bitmeister.jp
 * 
 * @author Osamu AKAMATSU (Bitmeister Inc.)
 * @version 0.1.0
 *
 * You can use this jQuery plugin for adding flavor to your web site.
 * By this plugin, text messages on your site are animated on mouse over.
 * 
 * Usage
 *   Call the moatext() function or set prefixed class on your page.
 *
 *   By function
 *     $(selector).moatext(options)
 *     
 *     <script type="text/javascript" language="JavaScript"><!--
 *       $(function(){
 *         $(".moamoa").moatext();
 *       });
 *     // -->
 *     </script>
 *     
 *     <div class="moamoa">This message is animated!</div>
 *     
 *     *If moatext() is called no parameter, default effect 'lens' is performed.
 *   
 *   By prefixed class
 *     <div class="moatext_lens">This message is animated!</div>
 *     
 *     class             description
 *     ----------------------------------
 *     "moatext_lens"    'lens' effect
 *     "moatext_wave"    'wave' effect
 *     "moatext_opacity" 'opacity' effect
 *     
 *     *About effects, please read below.
 *   
 * options
 * 
 *   effect:[effect1,effect2...]
 *     "lens"        animate font-size (default)
 *     "wave"        animate top and right margin
 *     "opacity"     animate opacity
 *   oneway:{true/false}
 *     true        effect only at mouseover
 *     false       effect at mouseover and mouseleave (default)
 *   values:{effect:{base:base-value,enter:enter-value,leave:leave-value},...}
 *     effect = "lens"
 *                 CSS 'font-size' value.
 *     effect = "wave"
 *                 CSS 'top' and 'left' value.
 *     effect = "opacity"
 *                 CSS 'opacity' value.
 *     base-value  Used at on loading the page.
 *     enter-value Used at entering mouse.
 *     leave-value Used at leaving mouse.
 *   hover:[function1,function2]
 *      function    replace the animate function launched at mouseover and mouseleave
 *                  Attention: If this value is not null, all the other options are ignored.
 *                  default : null (don't replace)
 *   easing:
 *      xxxx        animation easing value
 *                  default : linear
 * 
 *   animation:{true/false}
 *      true        use 'animate' function (default)
 *      false       don't use 'animate' function
 */
(function(jQuery) {
    function debug_options(options) {
        // debug
        msg = 'effects:';
        for (var element in options.effects) {
            msg = msg + options.effects[element] + ',';
        }
        msg = msg + ' oneway:' + options.oneway + ' base:';
        for (var element in options.base) {
            msg = msg + options.base[element] + ',';
        }
        msg = msg + ' values:';
        for (var element in options.values) {
            msg = msg + element + ':[' + options.values[element]["base"] + ',' + options.values[element]["enter"] + ',' + options.values[element]["leave"] + '],';
        }
        msg = msg + ' leave:';
        for (var element in options.leave) {
            msg = msg + options.leave[element] + ',';
        }
        msg = msg + ' easing:' + options.easing + ' duration:' + options.duration + ' animation:' + options.animation;
        alert(msg);
    };
    jQuery.fn.moatext = function(options){
        var options = jQuery.extend( {},jQuery.fn.moatext.defaults,options);
        var valuedic = jQuery.fn.moatext.valuesdefaults;
        if (options.values != null) {
            for (var valuekey in options.values) {
                for (var subvaluekey in options.values[valuekey]) {
                    valuedic[valuekey][subvaluekey] = options.values[valuekey][subvaluekey];
                }
            }
        }
        options.values = valuedic;
//      debug_options(options);
        var array = [];
        this.each(function(){
            // "script" check
            // alert("MOA Text warning! This page cannot work correctly because of including 'SCRIPT'");
            var scriptarray = new Array();
            var scripts = jQuery(this).find("script");
            for (var i=0; i < scripts.size(); i++) {
                scriptarray.push(scripts.eq(i).html());
            }
            var jqobj = jQuery(this);
            var baseString = jqobj.html();
            var wrappedString = "";
            var mode = 0;
            for (var i = 0; i < baseString.length; i++) {
                if (mode == 0) {
                    if (baseString.charAt(i) == '<') {
                        mode = 1;
                        wrappedString = wrappedString + baseString.charAt(i);
                        continue;
                    }
                }
                else if (mode == 1) {
                    if (baseString.charAt(i) == '>') {
                        mode = 0;
                    }
                    wrappedString = wrappedString + baseString.charAt(i);
                    continue;
                }
                if (baseString.charAt(i) == ' ') {
                    wrappedString = wrappedString + baseString.charAt(i);
                }
                else {
                    wrappedString = wrappedString + '<span class="moa_char">' + baseString.charAt(i) + '</span>';
                }
            }
            jqobj.html(wrappedString);
            scripts = jqobj.find("script");
            for (var i=0; i < scripts.size(); i++) {
                scripts.eq(i).html(scriptarray[i]);
            }
            array.push(jqobj);
        });
        if (options.hover != null) {
            jQuery(this).find(".moa_char").hover(
                options.hover[0],
                options.hover[1]
            );
            return array;
        }
        var basecss = {};
        var entercss = {};
        var leavecss = {};
        for (var effectNo in options.effects) {
            var effects = options.effects[effectNo];
            if (options.effects[effectNo] == 'lens') {
                basecss['font-size'] = options.values[effects]["base"];
                entercss['font-size'] = options.values[effects]["enter"];
                entercss['fontSize'] = options.values[effects]["enter"];
                leavecss['font-size'] = options.values[effects]["leave"];
                leavecss['fontSize'] = options.values[effects]["leave"];
            }
            else if (options.effects[effectNo] == 'wave') {
                basecss['position'] = 'relative';
                basecss['top'] = options.values[effects]["base"][0];
                basecss['left'] = options.values[effects]["base"][1];
                entercss['top'] = options.values[effects]["enter"][0];
                entercss['left'] = options.values[effects]["enter"][1];
                leavecss['top'] = options.values[effects]["leave"][0];
                leavecss['left'] = options.values[effects]["leave"][1];
            }
            else if (options.effects[effectNo] == 'opacity') {
                basecss['opacity'] = basecss['-moz-opacity'] = options.values[effects]["base"];
				basecss['filter'] = 'alpha(opacity='+parseFloat(options.values[effects]["base"])*100 + ')';
				basecss['zoom'] = '1';
                entercss['opacity'] = entercss['-moz-opacity'] = options.values[effects]["enter"];
				entercss['filter'] = 'alpha(opacity='+parseFloat(options.values[effects]["enter"])*100 + ')';
                leavecss['opacity'] = leavecss['-moz-opacity'] = options.values[effects]["leave"];
				leavecss['filter'] = 'alpha(opacity='+parseFloat(options.values[effects]["leave"])*100 + ')';
            }
        }
        if (options.animation == true) {
            if (options.oneway == false) {
                jQuery(this).find(".moa_char").css(basecss).hover(
                    function() {jQuery(this).animate(entercss,options.duration,options.easing);},
                    function() {jQuery(this).animate(leavecss,options.duration,options.easing);}
                );
            }
            else {
                jQuery(this).find(".moa_char").css(basecss).mouseover(
                    function() {jQuery(this).animate(entercss,options.duration,options.easing);}
                );
            }
        }
        else {
            if (options.oneway == false) {
                jQuery(this).find(".moa_char").css(basecss).hover(
                    function() {jQuery(this).css(entercss);},
                    function() {jQuery(this).css(leavecss);}
                );
            }
            else {
                jQuery(this).find(".moa_char").css(basecss).mouseover(
                    function() {jQuery(this).css(entercss);}
                );
            }
        }
        return array;
    };  // don't forget the semi-colon to close the method
    
    jQuery.fn.moatext.valuesdefaults = {
        "lens":{"base":"100%","enter":"200%","leave":"100%"},
        "wave":{"base":["0px","0px"],"enter":["-10px","-10px"],"leave":["0px","0px"]},
        "opacity": {"base":"0.1","enter":"1.0","leave":"0.1"}
    }

    jQuery.fn.moatext.defaults = {
        effects: ["lens"],
        oneway: false,
        values: null,
        hover: null,
        easing: "linear",
        duration: 1000,
        animation: true
    };
    jQuery.fn.moatext.key_class = "moatext";

// this code ends the Closure structure 
})(jQuery);

jQuery(function(){
    if (jQuery.fn.moatext.key_class != null && jQuery.fn.moatext.key_class.length > 0) {
        jQuery("."+jQuery.fn.moatext.key_class).moatext();
        jQuery("."+jQuery.fn.moatext.key_class+"_lens").moatext({effects:["lens"]});
        jQuery("."+jQuery.fn.moatext.key_class+"_wave").moatext({effects:["wave"]});
        jQuery("."+jQuery.fn.moatext.key_class+"_opacity").moatext({effects:["opacity"]});
    }
});
