/*
 * Copyright (c) 2006-2008 Maskat Project.
 *
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     Maskat Project - initial API and implementation
 */
package org.maskat.ui.views.properties.tabbed.masterdetails;

import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.forms.widgets.ExpandableComposite;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Section;
import org.eclipse.ui.forms.widgets.TableWrapData;
import org.eclipse.ui.forms.widgets.TableWrapLayout;

import org.maskat.core.event.Bind;
import org.maskat.ui.Messages;
import org.maskat.ui.views.properties.tabbed.beanwrapper.TargetBind;
import org.maskat.ui.views.properties.tabbed.treenodewrapper.ITreeNode;

public class TargetBindDetailsPage extends AbstractMaskatDetailsPage {

	private static final String SECTION_TEXT = Messages
			.getString("targetBindDetails.sectionText"); //$NON-NLS-1$

	private static final String DESCRIPTION = Messages
			.getString("targetBindDetails.description"); //$NON-NLS-1$

	private Text nodeNameText;

	private Text indexText;

	private Bind bind;

	public TargetBindDetailsPage(TreeViewer masterBlockTreeViewer) {
		this.masterBlockTreeViewer = masterBlockTreeViewer;
	}

	public void createContents(Composite parent) {
		TableWrapLayout layout = new TableWrapLayout();
		layout.topMargin = 0;
		layout.leftMargin = 5;
		layout.rightMargin = 5;
		layout.bottomMargin = 5;
		parent.setLayout(layout);

		FormToolkit toolkit = managedForm.getToolkit();

		Section bindSection = toolkit.createSection(parent,
				ExpandableComposite.TITLE_BAR | Section.DESCRIPTION);
		bindSection.setText(SECTION_TEXT);
		bindSection.setDescription(DESCRIPTION);
		TableWrapData tableWrapData = new TableWrapData(TableWrapData.FILL,
				TableWrapData.TOP);
		tableWrapData.grabHorizontal = true;
		bindSection.setLayoutData(tableWrapData);

		Composite bindComposite = toolkit.createComposite(bindSection);

		bindComposite.setLayout(new GridLayout(3, false));

		toolkit.createLabel(bindComposite, Messages
				.getString("targetBindDetails.nodeNameLabel")); //$NON-NLS-1$
		toolkit.createLabel(bindComposite, ":");
		nodeNameText = toolkit.createText(bindComposite, "", SWT.SINGLE
				| SWT.BORDER);
		nodeNameText.setLayoutData(new GridData(SWT.FILL, 0, true, false));

		toolkit.createLabel(bindComposite, Messages
				.getString("targetBindDetails.Indexlabel")); //$NON-NLS-1$
		toolkit.createLabel(bindComposite, ":");
		indexText = toolkit.createText(bindComposite, "", SWT.SINGLE
				| SWT.BORDER);
		indexText.setLayoutData(new GridData(SWT.FILL, 0, true, false));

		nodeNameText.addKeyListener(new KeyAdapter() {

			private int oldCaretPosition;

			public void keyReleased(KeyEvent e) {
				if (!nodeNameText.equals("")) {
					if (bind.getNode() == null
							|| !bind.getNode().equals(nodeNameText.getText())) {
						EventPropertiesMasterDetailsBlock.setEventProperty(masterBlockTreeViewer,
								TargetBind.class, bind, "node", nodeNameText
										.getText());
					}
				} else {
					if (bind.getNode() != null) {
						EventPropertiesMasterDetailsBlock.setEventProperty(masterBlockTreeViewer,
								TargetBind.class, bind, "node", null);
					}
				}
				oldCaretPosition = nodeNameText.getCaretPosition();
				updateTreeViewer();
				nodeNameText.setSelection(oldCaretPosition);
			}
		});

		nodeNameText.addFocusListener(new FocusAdapter() {

			public void focusLost(FocusEvent e) {
				boolean changed = false;
				if (!nodeNameText.equals("")) {
					if (bind.getNode() == null
							|| !bind.getNode().equals(nodeNameText.getText())) {
						EventPropertiesMasterDetailsBlock.setEventProperty(masterBlockTreeViewer,
								TargetBind.class, bind, "node", nodeNameText
										.getText());
						changed = true;
					}
				} else {
					if (bind.getNode() != null) {
						EventPropertiesMasterDetailsBlock.setEventProperty(masterBlockTreeViewer,
								TargetBind.class, bind, "node", null);
						changed = true;
					}
				}
				if (changed) {
					int oldCaretPosition = nodeNameText.getCaretPosition();
					updateTreeViewer();
					nodeNameText.setSelection(oldCaretPosition);
				}
			}
		});

		indexText.addKeyListener(new KeyAdapter() {

			private int oldCaretPosition;

			public void keyReleased(KeyEvent e) {
				if (!indexText.equals("")) {
					if (bind.getTokey() == null
							|| !bind.getTokey().equals(indexText.getText())) {
						EventPropertiesMasterDetailsBlock.setEventProperty(masterBlockTreeViewer,
								TargetBind.class, bind, "tokey", indexText
										.getText());
					}
				} else {
					if (bind.getNode() != null) {
						EventPropertiesMasterDetailsBlock.setEventProperty(masterBlockTreeViewer,
								TargetBind.class, bind, "tokey", null);
					}
				}
				oldCaretPosition = indexText.getCaretPosition();
				updateTreeViewer();
				indexText.setSelection(oldCaretPosition);
			}
		});

		indexText.addFocusListener(new FocusAdapter() {

			public void focusLost(FocusEvent e) {
				boolean changed = false;
				if (!indexText.equals("")) {
					if (bind.getTokey() == null
							|| !bind.getTokey().equals(indexText.getText())) {
						EventPropertiesMasterDetailsBlock.setEventProperty(masterBlockTreeViewer,
								TargetBind.class, bind, "tokey", indexText
										.getText());
						changed = true;
					}
				} else {
					if (bind.getTokey() != null) {
						EventPropertiesMasterDetailsBlock.setEventProperty(masterBlockTreeViewer,
								TargetBind.class, bind, "tokey", null);
						changed = true;
					}
				}
				if (changed) {
					int oldCaretPosition = indexText.getCaretPosition();
					updateTreeViewer();
					indexText.setSelection(oldCaretPosition);
				}
			}
		});

		bindSection.setClient(bindComposite);

	}

	public void update() {
		if (bind.getNode() != null) {
			nodeNameText.setText(bind.getNode());
		} else {
			nodeNameText.setText("");
		}

		if (bind.getTokey() != null) {
			indexText.setText(bind.getTokey());
		} else {
			indexText.setText("");
		}

	}

	public void setBind(Bind bind) {
		this.bind = bind;
	}

	protected void initializeInterface() {
		update();
		setDirtyFlag(false);
	}

	private void updateTreeViewer() {
		ITreeNode treeNode = EventPropertiesMasterDetailsBlock.getTreeNode(
				bind, TargetBind.class);
		if (treeNode != null) {
			masterBlockTreeViewer.update(treeNode, null);
			masterBlockTreeViewer.setSelection(
					new StructuredSelection(treeNode), true);
		}
	}
}
