/*
 * Copyright (c) 2006-2008 Maskat Project.
 *
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     Maskat Project - initial API and implementation
 */
package org.maskat.ui.views.properties.tabbed;

import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IPageLayout;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.views.contentoutline.ContentOutline;
import org.eclipse.ui.views.properties.PropertySheet;
import org.eclipse.ui.views.properties.tabbed.ITabbedPropertySheetPageContributor;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetPage;

import org.maskat.ui.editors.MaskatEditor;
import org.maskat.ui.editors.layout.outline.LayoutOutLinePage;

public class TabbedEventPropertySheetPage extends TabbedPropertySheetPage {
	
	public TabbedEventPropertySheetPage(
			ITabbedPropertySheetPageContributor tabbedPropertySheetPageContributor) {
		super(tabbedPropertySheetPageContributor);
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetPage#selectionChanged(org.eclipse.ui.IWorkbenchPart,
	 *      org.eclipse.jface.viewers.ISelection)
	 */
	public void selectionChanged(IWorkbenchPart part, ISelection selection) {
		if (selection instanceof IStructuredSelection) {
			super.selectionChanged(part, selection);
		} else {
			super.selectionChanged(part, StructuredSelection.EMPTY);
		}
	}
	
	protected void handlePartActivated(IWorkbenchPart part) {
		super.handlePartActivated(part);

		boolean isMaskatProperty = (part instanceof MaskatEditor)
			|| (part instanceof PropertySheet && ((PropertySheet) part).getCurrentPage() instanceof TabbedEventPropertySheetPage)
			|| (part instanceof ContentOutline && (((ContentOutline)part).getCurrentPage() instanceof LayoutOutLinePage));
		
		if (!isMaskatProperty) {
			resetActionsBars(getActionBars());
		}
	}
	
	private IActionBars getActionBars() {
		IWorkbench workbench = PlatformUI.getWorkbench();
		IWorkbenchPage wpage = workbench.getActiveWorkbenchWindow().getActivePage();
		if (wpage == null) {
			return null;
		}
		
		IViewPart vp = wpage.findView(IPageLayout.ID_PROP_SHEET); 
		if (vp == null) {
			return null;
		}
		IActionBars actionBar = vp.getViewSite().getActionBars();
		return actionBar;
	}
	
	private void resetActionsBars(IActionBars actionBar) {
		IContributionItem[] items =  actionBar.getToolBarManager().getItems();
		for (int i=0; i<items.length; i++) {
			if (items[i] instanceof ActionContributionItem && 
					("categories".equals(items[i].getId()) || "defaults".equals(items[i].getId()) 
							|| "filter".equals(items[i].getId()))) {
				actionBar.getToolBarManager().remove(items[i]);
			}
		}
		items =  actionBar.getMenuManager().getItems();
		for (int i=0; i<items.length; i++) {
			if (items[i] instanceof ActionContributionItem && 
					("categories".equals(items[i].getId()) || "defaults".equals(items[i].getId()) 
							|| "filter".equals(items[i].getId()))) {
				actionBar.getMenuManager().remove(items[i]);
			}
		}
		actionBar.updateActionBars();
	}
	
}
