/*
 * Copyright (c) 2006-2008 Maskat Project.
 *
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     Maskat Project - initial API and implementation
 */
package org.maskat.ui.views.properties.tabbed;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExecutableExtension;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.GraphicalViewer;
import org.eclipse.gef.commands.CommandStack;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.forms.ManagedForm;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.ScrolledForm;
import org.eclipse.ui.views.properties.tabbed.AbstractPropertySection;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetPage;
import org.maskat.core.layout.Component;
import org.maskat.ui.Messages;
import org.maskat.ui.views.properties.tabbed.masterdetails.EventPropertiesMasterDetailsBlock;

public class EventPropertySection extends AbstractPropertySection implements
	PropertyChangeListener, /* IPropertyListener, */IExecutableExtension {

	private static final String SECTION_TEXT = Messages
			.getString("eventPropertySection.sectionText"); //$NON-NLS-1$

	private String eventType;

	private Component component;

	private FormToolkit toolkit;

	private ScrolledForm form;

	private ManagedForm managedForm;

	private EventPropertiesMasterDetailsBlock block;

	private Composite parent;

	public void createControls(Composite parent,
			TabbedPropertySheetPage aTabbedPropertySheetPage) {
		super.createControls(parent, aTabbedPropertySheetPage);

		this.parent = parent;

		toolkit = getWidgetFactory();

		form = toolkit.createScrolledForm(parent);

		form.setText(SECTION_TEXT);

		managedForm = new ManagedForm(toolkit, form);

		block = new EventPropertiesMasterDetailsBlock();

		block.createContent(managedForm);

	}

	public boolean shouldUseExtraSpace() {
		return true;
	}

	/**
	 * Passing the focus request to the form.
	 */
	public void setFocus() {
		form.setFocus();
	}

	public void dispose() {
		if(component != null) {
			component.removePropertyChangeListener(this);
		}
		super.dispose();
	}

	public void refresh() {
		if(component != null) {
			component.removePropertyChangeListener(this);
		}
		component = null;
		ISelection selection = getSelection();
		if (selection instanceof IStructuredSelection && !selection.isEmpty()) {
			Object element = ((IStructuredSelection) selection)
					.getFirstElement();
			if (element != null && element instanceof EditPart) {
				Object model = ((EditPart) element).getModel();
				if (model instanceof Component) {
					component = (Component) model;
				}
				component.addPropertyChangeListener(this);
			}
		}
		renew();
	}
	
	public void propertyChange(PropertyChangeEvent evt) {
		if ("event".equals(evt.getPropertyName())) {
			EventPropertySection.this.refresh();
		}
	}	

	private void renew() {
		if (block.getTreeViewer() == null
				|| block.getTreeViewer().getContentProvider() == null) {
			form.dispose();
			form = toolkit.createScrolledForm(parent);
			form.setText(SECTION_TEXT);
			managedForm = new ManagedForm(toolkit, form);
			block = new EventPropertiesMasterDetailsBlock();
			block.createContent(managedForm);
			block.setCommandStack((CommandStack) this.getPart().getAdapter(
					CommandStack.class));
			form.setSize(parent.getBounds().width - 5,
					parent.getBounds().height - 10);
			form.pack(true);
		}
		if (component != null) {
			block.refresh(component.getEvent(eventType));
		}
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.eclipse.ui.views.properties.tabbed.AbstractPropertySection#setInput(org.eclipse.ui.IWorkbenchPart,
	 *      org.eclipse.jface.viewers.ISelection)
	 */
	private GraphicalViewer graphicalViewer = null;

	public void setInput(IWorkbenchPart part, ISelection selection) {
		super.setInput(part, selection);
		graphicalViewer = (GraphicalViewer) part
				.getAdapter(GraphicalViewer.class);
		block.setGraphicalViewer(graphicalViewer);
		block.setCommandStack((CommandStack) part
				.getAdapter(CommandStack.class));
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.eclipse.core.runtime.IExecutableExtension#setInitializationData(org.eclipse.core.runtime.IConfigurationElement,
	 *      java.lang.String, java.lang.Object)
	 */
	public void setInitializationData(IConfigurationElement config,
			String propertyName, Object data) throws CoreException {
		String sectionId = config.getAttribute("id");
		eventType = EventPropertySectionRegistry.getEventType(sectionId);
	}
}
