/*
 * Copyright (c) 2006-2008 Maskat Project.
 *
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     Maskat Project - initial API and implementation
 */
package org.maskat.ui.views.properties.advanced;

import org.eclipse.jface.action.IAction;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.views.properties.PropertySheetPage;
import org.eclipse.ui.views.properties.PropertySheetSorter;


public class PropertySheetPageExt extends PropertySheetPage {
	
	public void createControl(Composite parent) {
		// TODO Auto-generated method stub
		super.createControl(parent);
		setSorter(getPropertySheetSorter());
	}

	public PropertySheetSorter getPropertySheetSorter() {
		return new UnsortPropertySheetSorter();
	}
	
	public void setActionBars(IActionBars actionBars) {
		super.setActionBars(actionBars);
		
		IEditorPart editorPart = getEditorPart();
		if (editorPart != null) {
			IActionBars partActionBars = editorPart.getEditorSite().getActionBars();
			IAction action = partActionBars.getGlobalActionHandler(ActionFactory.UNDO.getId());
	        if (action != null) {
	            actionBars.setGlobalActionHandler(ActionFactory.UNDO.getId(), action);
	        }
	        action = partActionBars.getGlobalActionHandler(ActionFactory.REDO.getId()); 
	        if (action != null) {
	            actionBars.setGlobalActionHandler(ActionFactory.REDO.getId(), action);
	        }
		}
	}
	
	private IEditorPart getEditorPart() {
		IWorkbench workbench = PlatformUI.getWorkbench();
		IWorkbenchPage wpage = workbench.getActiveWorkbenchWindow().getActivePage();
		if (wpage == null) {
			return null;
		}
		
		IEditorPart part = wpage.getActiveEditor();
		return part;
	}
}
