/*
 * Copyright (c) 2006-2008 Maskat Project.
 *
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     Maskat Project - initial API and implementation
 */
package org.maskat.ui.views.properties;

import org.apache.commons.beanutils.DynaBean;
import org.eclipse.core.runtime.IAdapterFactory;
import org.eclipse.ui.views.properties.IPropertySource;

import org.maskat.core.layout.Button;
import org.maskat.core.layout.Checkbox;
import org.maskat.core.layout.CodeLib;
import org.maskat.core.layout.Combo;
import org.maskat.core.layout.ComboItem;
import org.maskat.core.layout.DivHtml;
import org.maskat.core.layout.DivSplit;
import org.maskat.core.layout.Frame;
import org.maskat.core.layout.Grid;
import org.maskat.core.layout.GridHeader;
import org.maskat.core.layout.Image;
import org.maskat.core.layout.Label;
import org.maskat.core.layout.Layout;
import org.maskat.core.layout.Popup;
import org.maskat.core.layout.Radio;
import org.maskat.core.layout.Splitter;
import org.maskat.core.layout.TabFolder;
import org.maskat.core.layout.TabItem;
import org.maskat.core.layout.Text;
import org.maskat.core.layout.TreeNode;
import org.maskat.core.layout.TreeView;
import org.maskat.core.layout.Window;
import org.maskat.ui.editors.layout.models.TabDef;

/**
 * ComponentDef->IPropertySouce
 */
public class PropertySourceAdapterFactory implements IAdapterFactory {

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.eclipse.core.runtime.IAdapterFactory#getAdapter(java.lang.Object,
	 *      java.lang.Class)
	 */
	public Object getAdapter(Object adaptableObject, Class adapterType) {
		if (adapterType != IPropertySource.class) {
			return null;
		}
		
		if (adaptableObject instanceof DynaBean) {
			return new DynaBeanPropertySource((DynaBean) adaptableObject);
		}

		if (adaptableObject instanceof Layout) {
			return new LayoutPropertySource((Layout) adaptableObject);
		}

		if (adaptableObject instanceof Button) {
		   return new ButtonPropertySource((Button)adaptableObject);
		}
		
		if (adaptableObject instanceof Checkbox) {
		   return new CheckboxPropertySource((Checkbox)adaptableObject);
		}
		
		if (adaptableObject instanceof CodeLib) {
		   return new CodelibPropertySource((CodeLib)adaptableObject);
		}
		
		if (adaptableObject instanceof Combo) {
		   return new ComboPropertySource((Combo)adaptableObject);
		}
		
		if (adaptableObject instanceof ComboItem) {
		   return new ComboItemPropertySource((ComboItem)adaptableObject);
		}
		
		if (adaptableObject instanceof DivHtml) {
		   return new DivHtmlPropertySource((DivHtml)adaptableObject);
		}
		
		if (adaptableObject instanceof DivSplit) {
		   return new DivSplitPropertySource((DivSplit)adaptableObject);
		}
		
		if (adaptableObject instanceof Frame) {
		   return new FramePropertySource((Frame)adaptableObject);
		}
		
		if (adaptableObject instanceof Grid) {
		   return new GridPropertySource((Grid)adaptableObject);
		}
		
		if (adaptableObject instanceof GridHeader) {
		   return new GridHeaderPropertySource((GridHeader)adaptableObject);
		}
		
		if (adaptableObject instanceof Image) {
		   return new ImagePropertySource((Image)adaptableObject);
		}
		
		if (adaptableObject instanceof Label) {
		   return new LabelPropertySource((Label)adaptableObject);
		}
		
		if (adaptableObject instanceof Popup) {
		   return new PopupPropertySource((Popup)adaptableObject);
		}
		
		if (adaptableObject instanceof Radio) {
		   return new RadioPropertySource((Radio)adaptableObject);
		}
		
		if (adaptableObject instanceof Splitter) {
		   return new SplitterPropertySource((Splitter)adaptableObject);
		}
		
		if (adaptableObject instanceof TabFolder) {
		   return new TabFolderPropertySource((TabFolder)adaptableObject);
		}
		
		if (adaptableObject instanceof TabDef) {
			return new TabItemPropertySource(
					(TabItem) ((TabDef) adaptableObject).getModel());
//			return new TabItemPropertySource(((TabItem) adaptableObject));
		}
			
		if (adaptableObject instanceof TabItem) {
		   return new TabItemPropertySource((TabItem)adaptableObject);
		}
		
		if (adaptableObject instanceof Text) {
		   return new TextPropertySource((Text)adaptableObject);
		}
		
		if (adaptableObject instanceof TreeNode) {
		   return new TreeNodePropertySource((TreeNode)adaptableObject);
		}
		
		if (adaptableObject instanceof TreeView) {
		   return new TreeViewPropertySource((TreeView)adaptableObject);
		}
		
		if (adaptableObject instanceof Window) {
		   return new WindowPropertySource((Window)adaptableObject);
		}

		return null;
	}

	public Class[] getAdapterList() {
		return new Class[] { IPropertySource.class };
	}

}
