/*
 * Copyright (c) 2006-2008 Maskat Project.
 *
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     Maskat Project - initial API and implementation
 */
package org.maskat.ui.views.properties;

import org.eclipse.ui.views.properties.PropertyDescriptor;

import org.maskat.core.layout.Combo;
import org.maskat.ui.views.properties.descriptor.BooleanComboBoxPropertyDescriptor;
import org.maskat.ui.views.properties.descriptor.ComboBoxLabelConstants;
import org.maskat.ui.views.properties.descriptor.MaskatComboBoxPropertyDescriptor;
import org.maskat.ui.views.properties.descriptor.MaskatTextPropertyDescriptor;

public class ComboPropertySource extends AbstractComponentPropertySource {

	public static final String PROP_NAME = "_prop_name_";

	public static final String PROP_LEFT = "_prop_left_";
	
	public static final String PROP_TOP = "_prop_top_";
	
	public static final String PROP_WIDTH = "_prop_width_";
	
	public static final String PROP_ENABLE = "_prop_enable_";
	
	public static final String PROP_HEIGHTITEM = "_prop_heightItem_";
	
	public static final String PROP_POSITION = "_prop_position_";
	
	public static final String PROP_SUGGEST = "_prop_suggest_";
	
	public static final String PROP_TABINDEX = "_prop_tabIndex_";

	public ComboPropertySource(Combo combo) {
		super(combo);
	}
	
	protected void initialize() {
		descriptor = new PropertyDescriptor[] {
				  new MaskatTextPropertyDescriptor(PROP_NAME, "name"),
				  new MaskatTextPropertyDescriptor(PROP_LEFT, "left"),
				  new MaskatTextPropertyDescriptor(PROP_TOP, "top"),
				  new MaskatTextPropertyDescriptor(PROP_WIDTH, "width"),
				  new MaskatTextPropertyDescriptor(PROP_TABINDEX, "tabIndex"),
				  new BooleanComboBoxPropertyDescriptor(PROP_ENABLE, "enable"),
				  new MaskatTextPropertyDescriptor(PROP_HEIGHTITEM, "heightItem"),
				  new MaskatComboBoxPropertyDescriptor(PROP_POSITION, "position", ComboBoxLabelConstants.POSITION),
				  new BooleanComboBoxPropertyDescriptor(PROP_SUGGEST, "suggest")};
		
		//make sure the "..." values are the same as bean's properties.
	    propMap.put(PROP_NAME, "name");
	    propMap.put(PROP_LEFT, "left");
	    propMap.put(PROP_TOP, "top");
	    propMap.put(PROP_WIDTH, "width");
	    propMap.put(PROP_ENABLE, "enable");
	    propMap.put(PROP_HEIGHTITEM, "heightItem");
	    propMap.put(PROP_POSITION, "position");
	    propMap.put(PROP_SUGGEST, "suggest");
	    propMap.put(PROP_TABINDEX, "tabIndex");

	}
}
