/*
 * Copyright (c) 2006-2008 Maskat Project.
 *
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     Maskat Project - initial API and implementation
 */
package org.maskat.ui.editors.layout.figures;

import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Label;
import org.eclipse.draw2d.TreeSearch;
import org.eclipse.draw2d.XYLayout;
import org.eclipse.swt.graphics.Image;

public class TreeViewFigure extends Label {

	private MaskatFigureHelper helper;

	public TreeViewFigure() {
		helper = new MaskatFigureHelper(this);
		setForegroundColor(ColorConstants.black);
		setLayoutManager(new XYLayout());
	}

	public TreeViewFigure(String s) {
		super(s);
		helper = new MaskatFigureHelper(this);
		setForegroundColor(ColorConstants.black);
	}

	public TreeViewFigure(Image i) {
		super(i);
		helper = new MaskatFigureHelper(this);
		setForegroundColor(ColorConstants.black);
	}

	public TreeViewFigure(String s, Image i) {
		super(s, i);
		helper = new MaskatFigureHelper(this);
		setForegroundColor(ColorConstants.black);
	}

	/**
	 * comboItemのマウス選択動作対応
	 */
	protected IFigure findDescendantAtExcluding(int x, int y, TreeSearch search) {
		return helper.findDescendantAtExcluding(x, y, search);
	}

	/**
	 * comboItemの表示対応ために
	 */
	protected void paintChildren(Graphics graphics) {
		super.paintChildren(graphics);

		helper.paintChildren(graphics);
	}
}
