/*
 * Copyright (c) 2006-2008 Maskat Project.
 *
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     Maskat Project - initial API and implementation
 */
package org.maskat.ui.editors.layout.figures;

import java.util.Iterator;
import java.util.List;

import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.CompoundBorder;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Label;
import org.eclipse.draw2d.LineBorder;
import org.eclipse.draw2d.MarginBorder;
import org.eclipse.draw2d.XYLayout;
import org.eclipse.swt.SWT;
import org.eclipse.swt.widgets.Display;

public class TabFolderFigure extends Label {

	public TabFolderFigure() {
		setForegroundColor(ColorConstants.black);
		setBorder(new CompoundBorder(new LineBorder(),
			new MarginBorder(0)));
		setLayoutManager(new XYLayout());
	}
	
	/**
	 * すべてのタブページを非表示にする すべてのタブボタンを非活性化にする
	 */
	public void setAllTabPageInvisible() {
		List childrenFigure = getChildren();
		for (Iterator it = childrenFigure.iterator(); it.hasNext();) {
			IFigure figure = (IFigure) it.next();
			if (figure instanceof TabItemFigure) {
				figure.setVisible(false);
			}
			if (figure instanceof TabFigure) {
				figure.setForegroundColor(Display.getCurrent().getSystemColor(
						SWT.COLOR_GRAY));
			}
		}
	}

	/**
	 * nameのタブページを表示、タブボタンを活性化
	 * 
	 * @param name
	 */
	public void showNamedTabPage(String name) {
		List childrenFigure = getChildren();
		for (Iterator it = childrenFigure.iterator(); it.hasNext();) {
			IFigure figure = (IFigure) it.next();
			if (figure instanceof TabItemFigure) {
				TabItemFigure tabPage = (TabItemFigure) figure;
				if (name.equals(tabPage.getName())) {
					tabPage.setVisible(true);
				}
			}
			if (figure instanceof TabFigure) {
				TabFigure tab = (TabFigure) figure;
				if (name.equals(tab.getName())) {
					figure.setForegroundColor(Display.getCurrent().getSystemColor(
							SWT.COLOR_BLACK));
				}
			}
		}
	}
}
