/*
 * Copyright (c) 2006-2008 Maskat Project.
 *
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     Maskat Project - initial API and implementation
 */
package org.maskat.ui.editors.layout.figures;

import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.CompoundBorder;
import org.eclipse.draw2d.Label;
import org.eclipse.draw2d.LineBorder;
import org.eclipse.draw2d.MarginBorder;
import org.eclipse.draw2d.XYLayout;
import org.eclipse.swt.graphics.Font;

public class ButtonFigure extends Label {
	public static Font DEFAULT_FONT = new Font(null, "Arial", 8, 0);

	public ButtonFigure(String text) {
		setForegroundColor(ColorConstants.black);
		setFont(DEFAULT_FONT);
		setBorder(new CompoundBorder(new LineBorder(), new MarginBorder(1)));
		setBackgroundColor(ColorConstants.button);
		setOpaque(true);
		setText(text);
		setLayoutManager(new XYLayout());
	}
}
