/*
 * Copyright (c) 2006-2008 Maskat Project.
 *
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     Maskat Project - initial API and implementation
 */
package org.maskat.ui.editors.layout.editparts;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;

import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.MouseEvent;
import org.eclipse.draw2d.MouseListener;
import org.eclipse.draw2d.RectangleFigure;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.editparts.AbstractGraphicalEditPart;

import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Cursor;

import org.maskat.ui.editors.layout.figures.SplitterFigure;
import org.maskat.ui.editors.layout.models.SplitModel;

/**
 * スプリットコンポーネントのノブと対応するeditpart
 */
public class SplitEditPart extends  AbstractGraphicalEditPart
		implements PropertyChangeListener {

	private static Color GRAY_COLOR = new Color(null, 150, 150, 150);
	private RectangleFigure figure;

	public void activate() {
		super.activate();
		SplitModel model = (SplitModel) getModel();
		model.addPropertyChangeListener(this);
	}

	public void deactivate() {
		SplitModel model = (SplitModel) getModel();
		model.removePropertyChangeListener(this);
		super.deactivate();
	}

	protected IFigure createFigure() {
		figure = new RectangleFigure();
		figure.setBackgroundColor(GRAY_COLOR);
		figure.addMouseListener(new MouseListener.Stub() {
			public void mousePressed(MouseEvent me) {
				SplitterEditPart splitterEditPart = (SplitterEditPart) SplitEditPart.this.getParent();
				splitterEditPart.doSwitch();
				((SplitterFigure) figure.getParent()).showSplitPage(
						splitterEditPart.getCurrentSelectedSplitIdx());
			}
		});
		figure.setCursor(new Cursor(null, SWT.CURSOR_HAND));
		return figure;
	}

	protected void createEditPolicies() {}

	protected void refreshVisuals() {
		SplitModel split = (SplitModel) getModel();

		Rectangle constraint = new Rectangle(split.getX(), split.getY(),
				split.getWidth(), split.getHeight());
		((GraphicalEditPart) getParent()).setLayoutConstraint(this, getFigure(), constraint);
	}

	public void propertyChange(PropertyChangeEvent evt) {
		refreshVisuals();
	}
}
