/*
 * Copyright (c) 2006-2008 Maskat Project.
 *
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     Maskat Project - initial API and implementation
 */
package org.maskat.ui.editors.layout.commands;

import org.eclipse.gef.commands.Command;

import org.maskat.core.layout.Combo;
import org.maskat.core.layout.ComboItem;
import org.maskat.ui.Messages;

public class DelComboItemCommand extends Command {

	private Combo parent;

	private ComboItem component;

	private int idx;

	public DelComboItemCommand(Combo parent, ComboItem child) {
		super(Messages.getString("layout.cmd.remove.comboitem.msg")); //$NON-NLS-1$
		this.parent = parent;
		this.component = child;
	}

	public void execute() {
		idx = parent.getChildIdx(component);
		if (idx == -1) {
			throw new IllegalStateException(
					"The comboitem is not a child of the combobox.");
		}
		parent.removeChild(component);
	}

	public void undo() {
		parent.addChildToIdx(component, idx);
	}

	public boolean canUndo() {
		return true;
	}
}
