/*
 * Copyright (c) 2006-2008 Maskat Project.
 *
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     Maskat Project - initial API and implementation
 */
package org.maskat.ui.editors.layout.commands;

import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gef.commands.Command;

import org.maskat.core.layout.Component;
import org.maskat.core.layout.LayoutDef;
import org.maskat.core.layout.custom.DynaComponent;
import org.maskat.core.layout.custom.DynaComponentClass;
import org.maskat.core.layout.custom.ComponentLibrary;
import org.maskat.ui.editors.layout.tools.ComponentUtils;

public class AddComponentCommand extends Command {

	private Component parent;

	private Component component;

	private Rectangle constraint;

	private boolean addedPrefixMapping;

	public AddComponentCommand(Component parent, Component component) {
		this.parent = parent;
		this.component = component;
		this.addedPrefixMapping = false;
	}

	public void setConstraint(Rectangle rectangle) {
		this.constraint = rectangle;
	}

	public void execute() {
		if (constraint.width == -1 && constraint.height == -1) {
			// XYLayoutEditPolicy#DEFAULT_SIZEとgetConstraintForを参照してください
			// 位置だけ指定されているとき、デフォルトサイズで画面上に生成
			// デフォルトサイズはComponentCreateFactoryを参照
			component.setLeft(constraint.x);
			component.setTop(constraint.y);
			
		} else {
			component.setConstraint(constraint.x, constraint.y, constraint.width,
					constraint.height);
		}

		if (component instanceof DynaComponent) {
			// Must consider the extended component's namespace
			LayoutDef layoutDef = parent.getLayout().getLayoutDef();

			DynaComponent dynaComponent = (DynaComponent) component;
			DynaComponentClass dynaClass = (DynaComponentClass) dynaComponent
					.getDynaClass();
			ComponentLibrary library = dynaClass.getLibrary();
			String namespace = library.getNamespaceURI();
			String prefix = library.getPrefix();
			if (namespace == null || "".equals(namespace)) {
				addedPrefixMapping = false;
			} else if (!layoutDef.getNamespaces().containsKey(namespace)) {
				layoutDef.getNamespaces().put(namespace, prefix);
				addedPrefixMapping = true;
			}
		}
		ComponentUtils.setUniqueName(parent.getLayout(), component);
		parent.addChild(component);
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.eclipse.gef.commands.Command#undo()
	 */
	public void undo() {
		parent.removeChild(component);
		if (component instanceof DynaComponent && addedPrefixMapping) {
			DynaComponent dynaBean = (DynaComponent) component;
			DynaComponentClass dynaClass = (DynaComponentClass) dynaBean.getDynaClass();

			String namespaceURI = dynaClass.getLibrary().getNamespaceURI();
			LayoutDef layoutDef = parent.getLayout().getLayoutDef();
			layoutDef.getNamespaces().remove(namespaceURI);
		}
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.eclipse.gef.commands.Command#canUndo()
	 */
	public boolean canUndo() {
		return true;
	}

}
