/*
 * Copyright (c)  2006-2007 Maskat Project.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
maskat.lang.Class.declare("maskat.widget.rialto.RadioGroupWrapper")
	.extend("maskat.layout.Widget", {

	_static: {
		groupMap: {},
		
		getGroup: function(name) {
			return maskat.widget.rialto.RadioGroupWrapper.groupMap[name];
		}
	},
	
   	getWidgetId: function() {
		return this.name;
	},

	postCreateWidget: function() {
		for (var i = 0; i < this.members.length; i++) {
			maskat.widget.rialto.RadioGroupWrapper.groupMap[this.members[i]] = this.name;
		}
	},

	setFocus: function() {
		var widget = this.getSelectWidget();
		if (widget) {
			widget.radio.focus();
		}
	},
	
	getValue: function() {
		var widget = this.getSelectWidget();
		if (widget) {
			return widget.name;
		}
	},

	setValue: function(value) {
		if (this.getLayout().widgets[value]) {
			this.getLayout().widgets[value].widget.setCheck(true);
		}
	},
	
	getSelectWidget: function() {
		var widgets = this.getLayout().widgets;
		for (var i = 0; i < this.members.length; i++) {
			if (widgets[this.members[i]].widget.isCheck()) {
				return widgets[this.members[i]].widget;
			}
		}
		return null;
	}
});
